/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import com.google.common.collect.TreeBasedTable;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import thelm.jaopca.api.blocks.IBlockProvider;
import thelm.jaopca.api.fluids.IFluidProvider;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.items.IItemProvider;
import thelm.jaopca.api.materialforms.IMaterialFormInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.crafttweaker.Form;
import thelm.jaopca.compat.crafttweaker.Material;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenClass(value="mods.jaopca.MaterialForm")
public class MaterialForm {
    private static final TreeBasedTable<IForm, IMaterial, MaterialForm> MATERIAL_FORM_WRAPPERS = TreeBasedTable.create();
    private final IMaterialFormInfo info;

    public static MaterialForm getMaterialFormWrapper(IForm form, IMaterial material) {
        MaterialForm materialForm = (MaterialForm)MATERIAL_FORM_WRAPPERS.get((Object)form, (Object)material);
        if (materialForm == null) {
            IMaterialFormInfo info = form.getType().getMaterialFormInfo(form, material);
            materialForm = new MaterialForm(info);
        }
        return materialForm;
    }

    private MaterialForm(IMaterialFormInfo info) {
        this.info = info;
    }

    public IMaterialFormInfo getInternal() {
        return this.info;
    }

    @ZenGetter(value="form")
    public Form getForm() {
        return Form.getFormWrapper(this.info.getMaterialForm().getForm());
    }

    @ZenGetter(value="material")
    public Material getMaterial() {
        return Material.getMaterialWrapper(this.info.getMaterialForm().getMaterial());
    }

    @ZenMethod
    public IOreDictEntry asOreDictEntry() {
        return CraftTweakerMC.getOreDict((String)MiscHelper.INSTANCE.getOredictName(this.info.getMaterialForm().getForm().getSecondaryName(), this.info.getMaterialForm().getMaterial().getName()));
    }

    @ZenMethod
    public IItemStack asItemStack(int count) {
        if (!(this.info instanceof IItemProvider)) {
            return null;
        }
        return CraftTweakerMC.getIItemStack((ItemStack)new ItemStack(((IItemProvider)((Object)this.info)).asItem(), count));
    }

    @ZenMethod
    public IItemStack asItemStack() {
        return this.asItemStack(1);
    }

    @ZenMethod
    public ILiquidStack asLiquidStack(int amount) {
        if (!(this.info instanceof IFluidProvider)) {
            return null;
        }
        return CraftTweakerMC.getILiquidStack((FluidStack)new FluidStack(((IFluidProvider)((Object)this.info)).asFluid(), amount));
    }

    @ZenMethod
    public IBlockDefinition asBlockDefinition() {
        if (!(this.info instanceof IBlockProvider)) {
            return null;
        }
        return CraftTweakerMC.getBlockDefinition((Block)((IBlockProvider)((Object)this.info)).asBlock());
    }

    @ZenMethod
    public crafttweaker.api.block.IBlockState asBlockState() {
        if (!(this.info instanceof IBlockProvider)) {
            return null;
        }
        return CraftTweakerMC.getBlockState((IBlockState)((IBlockProvider)((Object)this.info)).asBlock().func_176223_P());
    }
}

