/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.compat.crafttweaker.Material;
import thelm.jaopca.compat.crafttweaker.MaterialForm;
import thelm.jaopca.compat.crafttweaker.Module;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenClass(value="mods.jaopca.Form")
public class Form {
    private static final TreeMap<IForm, Form> FORM_WRAPPERS = new TreeMap();
    private final IForm form;

    public static Form getFormWrapper(IForm form) {
        return FORM_WRAPPERS.computeIfAbsent(form, Form::new);
    }

    private Form(IForm form) {
        this.form = form;
    }

    public IForm getInternal() {
        return this.form;
    }

    @ZenGetter(value="name")
    public String getName() {
        return this.form.getName();
    }

    @ZenGetter(value="type")
    public String getType() {
        return this.form.getType().getName();
    }

    @ZenGetter(value="module")
    public Module getModule() {
        return Module.getModuleWrapper(this.form.getModule());
    }

    @ZenGetter(value="secondaryName")
    public String getSecondaryName() {
        return this.form.getSecondaryName();
    }

    @ZenGetter(value="materialTypes")
    public String[] getMaterialTypes() {
        return (String[])this.form.getMaterialTypes().stream().map(MaterialType::getName).toArray(String[]::new);
    }

    @ZenGetter(value="materials")
    public Material[] getMaterials() {
        return (Material[])this.form.getMaterials().stream().map(Material::getMaterialWrapper).toArray(Material[]::new);
    }

    @ZenMethod
    public boolean containsMaterial(Material material) {
        return this.form.getMaterials().contains(material.getInternal());
    }

    @ZenMethod
    public IOreDictEntry getOreDictEntry(String suffix) {
        return CraftTweakerMC.getOreDict((String)MiscHelper.INSTANCE.getOredictName(this.form.getSecondaryName(), suffix));
    }

    @ZenMethod
    public IItemStack getItemStack(String suffix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        ItemStack stack = helper.getItemStack(helper.getOredictName(this.form.getSecondaryName(), suffix), count);
        return CraftTweakerMC.getIItemStack((ItemStack)stack);
    }

    @ZenMethod
    public IItemStack getItemStack(String suffix) {
        return this.getItemStack(suffix, 1);
    }

    @ZenMethod
    public ILiquidStack getLiquidStack(String suffix, int amount) {
        MiscHelper helper = MiscHelper.INSTANCE;
        FluidStack stack = helper.getFluidStack(helper.getFluidName(this.form.getSecondaryName(), suffix), amount);
        return CraftTweakerMC.getILiquidStack((FluidStack)stack);
    }

    @ZenMethod
    public MaterialForm getMaterialForm(Material material) {
        if (!this.containsMaterial(material)) {
            return null;
        }
        return MaterialForm.getMaterialFormWrapper(this.form, material.getInternal());
    }

    @ZenGetter(value="materialForms")
    public MaterialForm[] getMaterialForms() {
        return (MaterialForm[])this.form.getMaterials().stream().map(m -> MaterialForm.getMaterialFormWrapper(this.form, m)).toArray(MaterialForm[]::new);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Form)) {
            return false;
        }
        return this.form == ((Form)obj).form;
    }

    public int hashCode() {
        return this.form.hashCode() + 5;
    }
}

