/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.bcoreprocessing.recipes;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class CoolableRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final int outputAmount;
    public final int heatFrom;
    public final int heatTo;

    public CoolableRecipeAction(ResourceLocation key, Object input, int inputAmount, Object output, int outputAmount, int heatFrom, int heatTo) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputAmount = outputAmount;
        this.heatFrom = heatFrom;
        this.heatTo = heatTo;
    }

    @Override
    public boolean register() {
        FluidStack ing = MiscHelper.INSTANCE.getFluidStack(this.input, this.inputAmount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.outputAmount);
        if (stack == null) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        BuildcraftRecipeRegistry.refineryRecipes.addCoolableRecipe(ing, stack, this.heatFrom, this.heatTo);
        return true;
    }
}

