/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.astralsorcery.recipes;

import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.crafting.infusion.InfusionRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.infusion.recipes.BasicInfusionRecipe;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.astralsorcery.AstralSorceryHelper;
import thelm.jaopca.utils.MiscHelper;

public class InfusionRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final float consumptionChance;
    public final boolean consumeMultiple;
    public final boolean acceptsChalices;

    public InfusionRecipeAction(ResourceLocation key, Object input, Object output, int outputCount, float consumptionChance, boolean consumeMultiple, boolean acceptsChalices) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.consumptionChance = consumptionChance;
        this.consumeMultiple = consumeMultiple;
        this.acceptsChalices = acceptsChalices;
    }

    @Override
    public boolean register() {
        ItemHandle ing = AstralSorceryHelper.INSTANCE.getItemHandle(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        BasicInfusionRecipe recipe = new BasicInfusionRecipe(stack, ing);
        recipe.setLiquidStarlightConsumptionChance(this.consumptionChance);
        if (this.consumeMultiple) {
            recipe.setConsumeMultiple();
        }
        recipe.setCanBeSupportedByChalices(this.acceptsChalices);
        return InfusionRecipeRegistry.registerInfusionRecipe((AbstractInfusionRecipe)recipe) != null;
    }
}

