/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.advancedrocketry;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.advancedrocketry.AdvancedRocketryHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"advancedrocketry@[1.12.2-2,)"})
public class AdvancedRocketryModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Aluminium", "Aluminum", "Copper", "Gold", "Iridium", "Iron", "Tin", "Titanium"));

    @Override
    public String getName() {
        return "advancedrocketry";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dust");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        AdvancedRocketryHelper helper = AdvancedRocketryHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            helper.registerSmallPlatePressRecipe(miscHelper.getRecipeKey("advancedrocketry.ore_to_dust", material.getName()), oreOredict, dustOredict, 2);
        }
    }
}

