/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.models.fluids;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.BlockFluidBase;
import thelm.jaopca.api.fluids.IFluidBlockModelMapCreator;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAFluidBlockModelMapCreator
implements IFluidBlockModelMapCreator {
    public static final JAOPCAFluidBlockModelMapCreator INSTANCE = new JAOPCAFluidBlockModelMapCreator();

    @Override
    public Map<IBlockState, ModelResourceLocation> create(IMaterialFormFluidBlock fluidBlock, IFluidFormSettings settings) {
        ResourceLocation baseModelLocation = this.getBaseModelLocation(fluidBlock);
        LinkedHashMap<IBlockState, ModelResourceLocation> map = new LinkedHashMap<IBlockState, ModelResourceLocation>();
        for (IBlockState state : fluidBlock.asBlock().func_176194_O().func_177619_a()) {
            map.put(state, this.getModelLocation(baseModelLocation, state));
        }
        return map;
    }

    public ResourceLocation getBaseModelLocation(IMaterialFormFluidBlock materialFormFluidBlock) {
        Block block = materialFormFluidBlock.asBlock();
        ResourceLocation location = block.getRegistryName();
        ResourceLocation location1 = new ResourceLocation(location.func_110624_b(), "blockstates/" + location.func_110623_a() + ".json");
        if (MiscHelper.INSTANCE.hasResource(location1)) {
            return location;
        }
        return new ResourceLocation(location.func_110624_b(), materialFormFluidBlock.getMaterial().getModelType() + '/' + materialFormFluidBlock.getForm().getName());
    }

    public String getPropertyString(Map<IProperty<?>, Comparable<?>> values) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> property = entry.getKey();
            stringbuilder.append(property.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(this.getPropertyName(property, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    public <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    public ModelResourceLocation getModelLocation(ResourceLocation location, IBlockState state) {
        LinkedHashMap map = new LinkedHashMap((Map<IProperty<?>, Comparable<?>>)state.func_177228_b());
        map.remove(BlockFluidBase.LEVEL);
        return new ModelResourceLocation(location, this.getPropertyString(map));
    }
}

