/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.models.blocks;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IBlockItemModelFunctionCreator;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCABlockItemModelFunctionCreator
implements IBlockItemModelFunctionCreator {
    public static final JAOPCABlockItemModelFunctionCreator INSTANCE = new JAOPCABlockItemModelFunctionCreator();

    @Override
    public Pair<Function<ItemStack, ModelResourceLocation>, Set<ModelResourceLocation>> create(IMaterialFormBlockItem blockItem, IBlockFormSettings settings) {
        ResourceLocation baseModelLocation = this.getBaseModelLocation(blockItem);
        ModelResourceLocation modelLocation = new ModelResourceLocation(baseModelLocation, "inventory");
        return Pair.of(s -> modelLocation, Collections.singleton(modelLocation));
    }

    public ResourceLocation getBaseModelLocation(IMaterialFormBlockItem materialFormBlockItem) {
        ItemBlock blockItem = materialFormBlockItem.asBlockItem();
        ResourceLocation location = blockItem.getRegistryName();
        ResourceLocation location1 = new ResourceLocation(location.func_110624_b(), "blockstates/" + location.func_110623_a() + ".json");
        ResourceLocation location2 = new ResourceLocation(location.func_110624_b(), "models/item/" + location.func_110623_a() + ".json");
        if (MiscHelper.INSTANCE.hasResource(location1) || MiscHelper.INSTANCE.hasResource(location2)) {
            return location;
        }
        return new ResourceLocation(location.func_110624_b(), materialFormBlockItem.getMaterial().getModelType() + '/' + materialFormBlockItem.getForm().getName());
    }
}

