/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materialforms.IMaterialForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlockItem
extends ItemBlock
implements IMaterialFormBlockItem {
    protected final IBlockFormSettings settings;
    protected OptionalInt itemStackLimit = OptionalInt.empty();
    protected Optional<Boolean> hasEffect = Optional.empty();
    protected Optional<EnumRarity> rarity = Optional.empty();
    protected OptionalInt burnTime = OptionalInt.empty();

    public JAOPCABlockItem(IMaterialFormBlock block, IBlockFormSettings settings) {
        super(block.asBlock());
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return ((IMaterialForm)this.func_179223_d()).getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return ((IMaterialForm)this.func_179223_d()).getMaterial();
    }

    public int getItemStackLimit(ItemStack stack) {
        if (!this.itemStackLimit.isPresent()) {
            this.itemStackLimit = OptionalInt.of(this.settings.getItemStackLimitFunction().applyAsInt(this.getMaterial()));
        }
        return this.itemStackLimit.getAsInt();
    }

    public boolean func_77636_d(ItemStack stack) {
        if (!this.hasEffect.isPresent()) {
            this.hasEffect = Optional.of(this.settings.getHasEffectFunction().test(this.getMaterial()));
        }
        return this.hasEffect.get() != false || super.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (!this.rarity.isPresent()) {
            this.rarity = Optional.of(this.settings.getDisplayRarityFunction().apply(this.getMaterial()));
        }
        return this.rarity.get();
    }

    public int getItemBurnTime(ItemStack itemStack) {
        if (!this.burnTime.isPresent()) {
            this.burnTime = OptionalInt.of(this.settings.getBurnTimeFunction().applyAsInt(this.getMaterial()));
        }
        return this.burnTime.getAsInt();
    }

    public String func_77653_i(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.getForm().getName(), this.getMaterial(), this.func_77667_c(stack));
    }
}

