/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlock
extends Block
implements IMaterialFormBlock {
    private final IForm form;
    private final IMaterial material;
    protected final IBlockFormSettings settings;
    protected boolean blocksMovement;
    protected Optional<Material> blockMaterial = Optional.empty();
    protected Optional<MapColor> mapColor = Optional.empty();
    protected Optional<SoundType> soundType = Optional.empty();
    protected OptionalInt lightOpacity = OptionalInt.empty();
    protected OptionalInt lightValue = OptionalInt.empty();
    protected OptionalDouble blockHardness = OptionalDouble.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected OptionalDouble slipperiness = OptionalDouble.empty();
    protected AxisAlignedBB boundingBox;
    protected Optional<String> harvestTool = Optional.empty();
    protected OptionalInt harvestLevel = OptionalInt.empty();
    protected OptionalInt flammability = OptionalInt.empty();
    protected OptionalInt fireSpreadSpeed = OptionalInt.empty();
    protected Optional<Boolean> isFireSource = Optional.empty();
    protected Optional<Boolean> isBeaconBase = Optional.empty();
    protected Optional<String> translationKey = Optional.empty();

    public JAOPCABlock(IForm form, IMaterial material, IBlockFormSettings settings) {
        super(Material.field_151573_f);
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.blocksMovement = settings.getBlocksMovement();
        this.boundingBox = settings.getBoundingBox();
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    @Override
    public Block asBlock() {
        return this;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public Material func_149688_o(IBlockState state) {
        if (!this.blockMaterial.isPresent()) {
            this.blockMaterial = Optional.of(this.settings.getMaterialFunction().apply(this.material));
        }
        return this.blockMaterial.get();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!this.mapColor.isPresent()) {
            this.mapColor = Optional.of(this.settings.getMapColorFunction().apply(this.material));
        }
        return this.mapColor.get();
    }

    public SoundType func_185467_w() {
        if (!this.soundType.isPresent()) {
            this.soundType = Optional.of(this.settings.getSoundTypeFunction().apply(this.material));
        }
        return this.soundType.get();
    }

    public int func_149717_k(IBlockState state) {
        if (!this.lightOpacity.isPresent()) {
            this.lightOpacity = OptionalInt.of(this.settings.getLightOpacityFunction().applyAsInt(this.material));
        }
        return this.lightOpacity.getAsInt();
    }

    public int func_149750_m(IBlockState state) {
        if (!this.lightValue.isPresent()) {
            this.lightValue = OptionalInt.of(this.settings.getLightValueFunction().applyAsInt(this.material));
        }
        return this.lightValue.getAsInt();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (!this.blockHardness.isPresent()) {
            this.blockHardness = OptionalDouble.of(this.settings.getBlockHardnessFunction().applyAsDouble(this.material));
        }
        return (float)this.blockHardness.getAsDouble();
    }

    public float func_149638_a(Entity exploder) {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.material));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (!this.slipperiness.isPresent()) {
            this.slipperiness = OptionalDouble.of(this.settings.getSlipperinessFunction().applyAsDouble(this.material));
        }
        return (float)this.slipperiness.getAsDouble();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.blocksMovement ? blockState.func_185900_c(worldIn, pos) : field_185506_k;
    }

    public String getHarvestTool(IBlockState state) {
        if (!this.harvestTool.isPresent()) {
            this.harvestTool = Optional.of(this.settings.getHarvestToolFunction().apply(this.material));
        }
        return Strings.emptyToNull((String)this.harvestTool.get());
    }

    public int getHarvestLevel(IBlockState state) {
        if (!this.harvestLevel.isPresent()) {
            this.harvestLevel = OptionalInt.of(this.settings.getHarvestLevelFunction().applyAsInt(this.material));
        }
        return this.harvestLevel.getAsInt();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (!this.flammability.isPresent()) {
            this.flammability = OptionalInt.of(this.settings.getFireSpreadSpeedFunction().applyAsInt(this.material));
        }
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (!this.fireSpreadSpeed.isPresent()) {
            this.fireSpreadSpeed = OptionalInt.of(this.settings.getFlammabilityFunction().applyAsInt(this.material));
        }
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        if (!this.isFireSource.isPresent()) {
            this.isFireSource = Optional.of(this.settings.getIsFireSourceFunction().test(this.material));
        }
        return this.isFireSource.get();
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        if (!this.isBeaconBase.isPresent()) {
            this.isBeaconBase = Optional.of(this.settings.getIsBeaconBaseFunction().test(this.material));
        }
        return this.isBeaconBase.get();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return field_185505_j.equals((Object)this.boundingBox);
    }

    public String func_149739_a() {
        if (!this.translationKey.isPresent()) {
            ResourceLocation id = this.getRegistryName();
            this.translationKey = Optional.of("block." + id.func_110624_b() + "." + id.func_110623_a().replace('/', '.'));
        }
        return this.translationKey.get();
    }

    public String func_149732_F() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.form.getName(), this.material, this.func_149739_a());
    }
}

