/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api;

import com.google.gson.JsonDeserializer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.jaopca.api.blocks.IBlockFormType;
import thelm.jaopca.api.entities.IEntityEntryFormType;
import thelm.jaopca.api.fluids.IFluidFormType;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.helpers.IJsonHelper;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.items.IItemFormType;
import thelm.jaopca.api.localization.ILocalizer;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.recipes.IRecipeAction;

public abstract class JAOPCAApi {
    private static JAOPCAApi instance;

    protected static void setInstance(JAOPCAApi api) {
        if (instance == null) {
            instance = api;
        }
    }

    public static boolean initialized() {
        return instance != null;
    }

    public static JAOPCAApi instance() {
        if (instance == null) {
            throw new IllegalStateException("Got API instance before it is set");
        }
        return instance;
    }

    public abstract IBlockFormType blockFormType();

    public abstract IItemFormType itemFormType();

    public abstract IFluidFormType fluidFormType();

    public abstract IEntityEntryFormType entityTypeFormType();

    public abstract IFormType getFormType(String var1);

    public abstract IForm newForm(IModule var1, String var2, IFormType var3);

    public abstract IFormRequest newFormRequest(IModule var1, IForm ... var2);

    public abstract IMiscHelper miscHelper();

    public abstract IJsonHelper jsonHelper();

    public abstract JsonDeserializer<Enum<?>> enumDeserializer();

    public abstract JsonDeserializer<Function<IMaterial, Enum<?>>> materialEnumFunctionDeserializer();

    public abstract <T> JsonDeserializer<Function<IMaterial, T>> materialMappedFunctionDeserializer(Function<String, T> var1, Function<T, String> var2);

    public abstract JsonDeserializer<Function<IMaterial, ?>> materialFunctionDeserializer();

    public abstract JsonDeserializer<Supplier<IForgeRegistryEntry<?>>> forgeRegistryEntrySupplierDeserializer();

    public abstract IForm getForm(String var1);

    public abstract Set<IForm> getForms();

    public abstract IMaterial getMaterial(String var1);

    public abstract Set<IMaterial> getMaterials();

    public abstract CreativeTabs creativeTab();

    public abstract Set<String> getOredict();

    public abstract Set<ResourceLocation> getRecipes();

    public abstract ILocalizer currentLocalizer();

    public abstract Map<String, String> currentMaterialLocalizationMap();

    public abstract boolean registerBlacklistedMaterialNames(String ... var1);

    public abstract boolean registerUsedPlainPrefixes(String ... var1);

    public abstract boolean registerMaterialAlternativeNames(String var1, String ... var2);

    public abstract boolean registerFormType(IFormType var1);

    public abstract boolean registerOredict(String var1, Item var2);

    public abstract boolean registerOredict(String var1, Block var2);

    public abstract boolean registerOredict(String var1, ItemStack var2);

    public abstract boolean registerOredict(String var1, String var2);

    public abstract void registerDefaultGemOverride(String var1);

    public abstract void registerDefaultCrystalOverride(String var1);

    public abstract void registerDefaultDustOverride(String var1);

    public abstract boolean registerRecipe(ResourceLocation var1, IRecipeAction var2);

    public abstract boolean registerLateRecipe(ResourceLocation var1, IRecipeAction var2);

    public abstract boolean registerShapedRecipe(ResourceLocation var1, String var2, Object var3, int var4, Object ... var5);

    public abstract boolean registerShapedRecipe(ResourceLocation var1, Object var2, int var3, Object ... var4);

    public abstract boolean registerShapelessRecipe(ResourceLocation var1, String var2, Object var3, int var4, Object ... var5);

    public abstract boolean registerShapelessRecipe(ResourceLocation var1, Object var2, int var3, Object ... var4);

    public abstract boolean registerSmeltingRecipe(ResourceLocation var1, Object var2, Object var3, int var4, float var5);

    public abstract void registerTextures(Supplier<List<ResourceLocation>> var1);

    public abstract void registerLocalizer(ILocalizer var1, String ... var2);
}

