/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.network;

import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import crazypants.enderio.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.invpanel.invpanel.InventoryPanelContainer;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketItemInfo
implements IMessage {
    private int windowId;
    private int generation;
    private byte[] compressed;

    public PacketItemInfo() {
    }

    public PacketItemInfo(int windowId, IInventoryDatabaseServer db, List<? extends IServerItemEntry> items) {
        this.windowId = windowId;
        this.generation = db.getGeneration();
        try {
            this.compressed = db.compressItemInfo(items);
        }
        catch (IOException ex) {
            Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while compressing items", ex);
            this.compressed = new byte[0];
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.generation = buf.readInt();
        this.compressed = NetworkUtil.readByteArray((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeInt(this.generation);
        NetworkUtil.writeByteArray((ByteBuf)buf, (byte[])this.compressed);
    }

    public static class Handler
    implements IMessageHandler<PacketItemInfo, IMessage> {
        public IMessage onMessage(PacketItemInfo message, MessageContext ctx) {
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            if (player.field_71070_bA.field_75152_c == message.windowId && player.field_71070_bA instanceof InventoryPanelContainer) {
                InventoryPanelContainer ipc = (InventoryPanelContainer)player.field_71070_bA;
                TileInventoryPanel teInvPanel = (TileInventoryPanel)ipc.getTe();
                InventoryDatabaseClient db = teInvPanel.getDatabaseClient(message.generation);
                try {
                    db.readCompressedItems(message.compressed);
                }
                catch (IOException ex) {
                    Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while reading item info", ex);
                }
            }
            return null;
        }
    }
}

