/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.chest;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.CapacitorKeyType;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.capacitor.Scaler;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.ScalerFactory;
import crazypants.enderio.invpanel.init.InvpanelObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderioinvpanel")
public enum EnumChestSize implements IStringSerializable
{
    TINY(InvpanelObject.blockInventoryChestTiny),
    SMALL(InvpanelObject.blockInventoryChestSmall),
    MEDIUM(InvpanelObject.blockInventoryChestMedium),
    BIG(InvpanelObject.blockInventoryChestBig),
    LARGE(InvpanelObject.blockInventoryChestLarge),
    HUGE(InvpanelObject.blockInventoryChestHuge),
    ENORMOUS(InvpanelObject.blockInventoryChestEnormous),
    WAREHOUSE(InvpanelObject.blockInventoryChestWarehouse),
    WAREHOUSE13(InvpanelObject.blockInventoryChestWarehouse13);

    @Nonnull
    private final IModObject owner;
    @Nonnull
    private final ICapacitorKey intake;
    @Nonnull
    private final ICapacitorKey buffer;
    @Nonnull
    private final ICapacitorKey use;
    @Nonnull
    private final ICapacitorKey size;
    @Nonnull
    public static final PropertyEnum<EnumChestSize> SIZE;

    private EnumChestSize(IModObject owner) {
        this.owner = owner;
        this.intake = new CapacitorKey(CapacitorKeyType.ENERGY_INTAKE, "intake");
        this.buffer = new CapacitorKey(CapacitorKeyType.ENERGY_BUFFER, "buffer");
        this.use = new CapacitorKey(CapacitorKeyType.ENERGY_USE, "use");
        this.size = new CapacitorKey(CapacitorKeyType.AMOUNT, "size");
    }

    public int getSlots() {
        return this.size.getDefault();
    }

    @Nonnull
    public String func_176610_l() {
        return (String)NullHelper.notnullJ((Object)this.name().toLowerCase(Locale.ENGLISH), (String)"String.toLowerCase()");
    }

    @Nonnull
    public String getUnlocalizedName(Item me) {
        return me.func_77658_a() + "_" + this.func_176610_l();
    }

    public static int getMetaFromType(EnumChestSize value) {
        return value.ordinal();
    }

    @Nonnull
    public ICapacitorKey getIntake() {
        return this.intake;
    }

    @Nonnull
    public ICapacitorKey getBuffer() {
        return this.buffer;
    }

    @Nonnull
    public ICapacitorKey getUse() {
        return this.use;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<ICapacitorKey> event) {
        for (EnumChestSize key : EnumChestSize.values()) {
            event.getRegistry().register((IForgeRegistryEntry)key.intake);
            Log.debug("<capacitor key=\"", key.intake.getRegistryName() + "\" base=\"\" scaler=\"FIXED\" />");
            event.getRegistry().register((IForgeRegistryEntry)key.buffer);
            Log.debug("<capacitor key=\"", key.buffer.getRegistryName() + "\" base=\"\" scaler=\"FIXED\" />");
            event.getRegistry().register((IForgeRegistryEntry)key.use);
            Log.debug("<capacitor key=\"", key.use.getRegistryName() + "\" base=\"\" scaler=\"FIXED\" />");
            event.getRegistry().register((IForgeRegistryEntry)key.size);
            Log.debug("<capacitor key=\"", key.size.getRegistryName() + "\" base=\"\" scaler=\"FIXED\" />");
        }
    }

    static {
        SIZE = PropertyEnum.func_177709_a((String)"size", EnumChestSize.class);
    }

    private class CapacitorKey
    implements ICapacitorKey {
        @Nonnull
        private final ResourceLocation registryName;
        @Nonnull
        private final CapacitorKeyType valueType;
        @Nonnull
        private Scaler scaler = ScalerFactory.INVALID;
        private int baseValue = Integer.MIN_VALUE;

        private CapacitorKey(@Nonnull CapacitorKeyType valueType, String shortname) {
            this.valueType = valueType;
            this.registryName = new ResourceLocation(EnumChestSize.this.owner.getRegistryName().func_110624_b(), EnumChestSize.this.owner.getRegistryName().func_110623_a() + "/" + shortname.toLowerCase(Locale.ENGLISH));
        }

        @Override
        public float getFloat(float level) {
            return (float)this.baseValue * this.scaler.scaleValue(level);
        }

        @Override
        public int getBaseValue() {
            return this.baseValue;
        }

        @Override
        @Nonnull
        public IModObject getOwner() {
            return EnumChestSize.this.owner;
        }

        @Override
        @Nonnull
        public CapacitorKeyType getValueType() {
            return this.valueType;
        }

        @Override
        @Nonnull
        public String getLegacyName() {
            return EnumChestSize.this.name().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public void setScaler(@Nonnull Scaler scaler) {
            this.scaler = scaler;
        }

        @Override
        public void setBaseValue(int baseValue) {
            this.baseValue = baseValue;
        }

        @Override
        public void validate() {
            if (this.scaler == ScalerFactory.INVALID || this.baseValue == Integer.MIN_VALUE) {
                throw new ICapacitorKey.UnconfiguredCapKeyException("CapacitorKey " + this.getRegistryName() + " has not been configured. This should not be possible and may be caused by a 3rd-party addon mod.");
            }
        }

        public final ICapacitorKey setRegistryName(ResourceLocation name) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
        }

        @Override
        @Nonnull
        public final ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public final Class<ICapacitorKey> getRegistryType() {
            return ICapacitorKey.class;
        }
    }
}

