/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.tool;

import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.tool.IToolProvider;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;

public class ToolUtil {
    @Nonnull
    private static final ToolUtil instance = new ToolUtil();
    @Nonnull
    private final List<IToolProvider> toolProviders = new ArrayList<IToolProvider>();

    public static boolean isToolEquipped(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        return ToolUtil.getInstance().isToolEquippedImpl(player, hand);
    }

    public static ITool getEquippedTool(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        return ToolUtil.getInstance().getEquippedToolImpl(player, hand);
    }

    public static boolean breakBlockWithTool(@Nonnull Block block, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull String permissionNode) {
        ItemStack heldItem = entityPlayer.func_184586_b(hand);
        ITool tool = ToolUtil.getToolFromStack(heldItem);
        if (tool != null && entityPlayer.func_70093_af() && tool.canUse(hand, entityPlayer, pos)) {
            IBlockState bs = world.func_180495_p(pos);
            if (!PermissionAPI.hasPermission((GameProfile)entityPlayer.func_146103_bH(), (String)permissionNode, (IContext)new BlockPosContext(entityPlayer, pos, bs, side))) {
                entityPlayer.func_145747_a((ITextComponent)Lang.WRENCH_DENIED.toChatServer());
                return false;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, bs, entityPlayer);
            event.setExpToDrop(0);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                entityPlayer.func_145747_a((ITextComponent)Lang.WRENCH_DENIED_BLOCKBREAK.toChatServer());
                return false;
            }
            if (!world.field_72995_K && block.removedByPlayer(bs, world, pos, entityPlayer, true)) {
                block.func_180657_a(world, entityPlayer, pos, world.func_180495_p(pos), world.func_175625_s(pos), heldItem);
            }
            tool.used(hand, entityPlayer, pos);
            return true;
        }
        return false;
    }

    @Nonnull
    public static ToolUtil getInstance() {
        return instance;
    }

    private ToolUtil() {
    }

    public void registerToolProvider(@Nonnull IToolProvider toolProvider) {
        this.toolProviders.add(toolProvider);
    }

    private boolean isToolEquippedImpl(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        return this.getEquippedToolImpl(player, hand) != null;
    }

    @Nullable
    private ITool getEquippedToolImpl(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack equipped = player.func_184586_b(hand);
        return ToolUtil.getToolFromStack(equipped);
    }

    @Nullable
    public static ITool getToolFromStack(@Nonnull ItemStack equipped) {
        if (Prep.isInvalid(equipped)) {
            return null;
        }
        if (equipped.func_77973_b() instanceof ITool) {
            return (ITool)equipped.func_77973_b();
        }
        return ToolUtil.getInstance().getToolImpl(equipped);
    }

    private ITool getToolImpl(@Nonnull ItemStack equipped) {
        for (IToolProvider provider : this.toolProviders) {
            ITool result = provider.getTool(equipped);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

