/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.staffoflevity;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.MappedCapabilityProvider;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.config.config.ItemConfig;
import crazypants.enderio.base.handler.darksteel.DarkSteelTooltipManager;
import crazypants.enderio.base.item.darksteel.attributes.EquipmentData;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStaffOfLevity
extends Item
implements IAdvancedTooltipProvider,
IOverlayRenderAware,
IDarkSteelItem {
    private long lastActivationTick = 0L;
    private boolean isEffectActive = false;

    public static ItemStaffOfLevity create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemStaffOfLevity(modObject);
    }

    public ItemStaffOfLevity(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            long ticksSinceActivation = EnderIO.proxy.getTickCount() - this.lastActivationTick;
            if (ticksSinceActivation < 0L) {
                this.lastActivationTick = -1L;
            }
            player.func_184609_a(hand);
            if (world.field_72995_K && (ticksSinceActivation == 0L || ticksSinceActivation >= (long)((Integer)ItemConfig.staffOfLevityTicksBetweenActivation.get()).intValue())) {
                if (!this.isEffectActive && this.hasFluid(stack)) {
                    this.useFluid(stack);
                    player.func_70690_d(new PotionEffect(MobEffects.field_188424_y, (Integer)ItemConfig.staffOfLevityDurationSeconds.get() * 20));
                } else {
                    player.func_184589_d(MobEffects.field_188424_y);
                }
                this.lastActivationTick = EnderIO.proxy.getTickCount();
                this.isEffectActive = !this.isEffectActive;
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean canDestroyBlockInCreative(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return false;
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition, true);
        PowerBarOverlayRenderHelper.instance_fluid.render(stack, xPosition, yPosition, 1, true);
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelTooltipManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelTooltipManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelTooltipManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            NbtValue.FLUIDAMOUNT.setInt(is, (int)((Integer)ItemConfig.staffOfLevityFluidStorage.get()));
            list.add((Object)is);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }

    private boolean hasFluid(@Nonnull ItemStack contianer) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(contianer);
        return (Integer)ItemConfig.staffOfLevityFluidUsePerTeleport.get() <= amount;
    }

    private boolean useFluid(@Nonnull ItemStack container) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if ((Integer)ItemConfig.staffOfLevityFluidUsePerTeleport.get() > amount) {
            NbtValue.FLUIDAMOUNT.setInt(container, 0);
            return false;
        }
        NbtValue.FLUIDAMOUNT.setInt(container, amount - (Integer)ItemConfig.staffOfLevityFluidUsePerTeleport.get());
        return true;
    }

    public FluidStack getFluid(@Nonnull ItemStack container) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (amount > 0) {
            return new FluidStack((Fluid)ItemConfig.staffOfLevityFluidType.get(), amount);
        }
        return null;
    }

    public int fill(@Nonnull ItemStack container, @Nonnull FluidStack resource, boolean doFill) {
        if (container.func_77973_b() != this || resource.amount <= 0 || resource.getFluid() == null || resource.getFluid() != ItemConfig.staffOfLevityFluidType.get()) {
            return 0;
        }
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        int capacity = (Integer)ItemConfig.staffOfLevityFluidStorage.get();
        int free = capacity - amount;
        int toFill = Math.min(resource.amount, free);
        if (toFill > 0 && doFill) {
            NbtValue.FLUIDAMOUNT.setInt(container, amount + toFill);
        }
        return toFill;
    }

    @Override
    @Nonnull
    public MappedCapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt, @Nonnull MappedCapabilityProvider capProv) {
        return capProv.add(FluidUtil.getFluidItemCapability(), (Object)new FluidCapabilityProvider(stack));
    }

    @Override
    @Nonnull
    public IEquipmentData getEquipmentData() {
        return EquipmentData.IRON;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_LEVITY_ENERGY_BUFFER;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_LEVITY_ENERGY_INPUT;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_LEVITY_ENERGY_USE;
    }

    @Override
    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack stack) {
        return CapacitorKey.NO_POWER;
    }

    private final class FluidCapabilityProvider
    implements IFluidHandlerItem {
        @Nonnull
        protected final ItemStack container;

        private FluidCapabilityProvider(ItemStack container) {
            this.container = container;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return ItemStaffOfLevity.this.getFluid(FluidCapabilityProvider.this.container);
                }

                public int getCapacity() {
                    return (Integer)ItemConfig.staffOfLevityFluidStorage.get();
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return false;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return fluidStack != null && fluidStack.getFluid() == ItemConfig.staffOfLevityFluidType.get();
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return false;
                }
            }};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return ItemStaffOfLevity.this.fill(this.container, (FluidStack)NullHelper.notnull((Object)resource, (String)"Cannot use null as a fluid stack"), doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }
    }
}

