/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.network;

import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.IItemFilterUpgrade;
import crazypants.enderio.util.EnumReader;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketHeldFilterUpdate
implements IMessage {
    private IFilter filter;
    private int param;

    public PacketHeldFilterUpdate() {
    }

    public PacketHeldFilterUpdate(@Nonnull IFilter filter, int param) {
        this.filter = filter;
        this.param = param;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf != null) {
            this.filter = FilterRegistry.readFilter(buf);
            this.param = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        if (buf != null) {
            FilterRegistry.writeFilter(buf, this.filter);
            buf.writeInt(this.param);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketHeldFilterUpdate, IMessage> {
        public IMessage onMessage(PacketHeldFilterUpdate message, MessageContext ctx) {
            ItemStack filterStack = ctx.getServerHandler().field_147369_b.func_184586_b(EnumReader.get(EnumHand.class, message.param));
            if (!filterStack.func_190926_b() && filterStack.func_77973_b() instanceof IItemFilterUpgrade) {
                FilterRegistry.writeFilterToStack(message.filter, filterStack);
            }
            return null;
        }
    }
}

