/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Fluid;
import crazypants.enderio.base.fluid.FluidFuelRegister;
import crazypants.enderio.base.recipe.RecipeLevel;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;

public class Coolant
extends AbstractConditional {
    private Optional<Fluid> fluid = this.empty();
    private Optional<Float> amount = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (!this.fluid.isPresent()) {
                throw new InvalidRecipeConfigException("Missing attribute 'fluid'");
            }
            if (!this.amount.isPresent() || this.amount.get().floatValue() <= 0.0f) {
                throw new InvalidRecipeConfigException("Missing attribute 'amount'");
            }
            this.valid = this.fluid.get().isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <coolant>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.fluid.get().enforceValidity();
    }

    @Override
    public void register(@Nonnull String recipeName, @Nonnull RecipeLevel recipeLevel) {
        if (this.isValid() && this.isActive()) {
            FluidFuelRegister.instance.addCoolant(this.fluid.get().getFluid(), this.amount.get().floatValue());
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("fluid".equals(name)) {
            this.fluid = this.of(new Fluid());
            this.fluid.get().setAttribute(factory, "name", value);
            this.fluid.get().readResolve();
            return true;
        }
        if ("amount".equals(name)) {
            try {
                this.amount = this.of(Float.valueOf(Float.parseFloat(value)));
            }
            catch (NumberFormatException e) {
                throw new InvalidRecipeConfigException("Invalid value in 'amount': Not a number");
            }
            return true;
        }
        return super.setAttribute(factory, name, value);
    }
}

