/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.gui;

import info.loenwind.autoconfig.factory.IRootFactory;
import info.loenwind.autoconfig.gui.ConfigElementCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;

public abstract class ConfigFactory
implements IModGuiFactory {
    public void initialize(@Nullable Minecraft minecraftInstance) {
    }

    @Nullable
    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }

    public boolean hasConfigGui() {
        return true;
    }

    @Nullable
    public GuiScreen createConfigGui(@Nullable GuiScreen parentScreen) {
        return parentScreen == null ? null : new GuiConfig(parentScreen, this.getConfigElements(parentScreen), this.getModID(), false, false, this.getTitle(), this.getTitle2());
    }

    protected abstract String getModID();

    protected abstract String getTitle();

    protected abstract String getTitle2();

    protected abstract Map<String, Configuration> getConfigurations();

    protected Map<String, Configuration> singleConfig(IRootFactory rootFactory) {
        HashMap<String, Configuration> result = new HashMap<String, Configuration>();
        result.put("", rootFactory.getConfig());
        return result;
    }

    protected List<IConfigElement> getConfigElements(GuiScreen parent) {
        ArrayList<IConfigElement> result;
        block4: {
            Map<String, Configuration> configurations;
            block3: {
                result = new ArrayList<IConfigElement>();
                configurations = this.getConfigurations();
                if (configurations.size() != 1) break block3;
                Configuration configuration = configurations.values().iterator().next();
                if (configuration == null) break block4;
                for (String section : configuration.getCategoryNames()) {
                    ConfigCategory category = configuration.getCategory(section);
                    category.setLanguageKey(this.getModID() + ".config." + category.getQualifiedName());
                    if (category.isChild()) continue;
                    result.add(new ConfigElementCategory(category));
                }
                break block4;
            }
            for (Map.Entry<String, Configuration> entry : configurations.entrySet()) {
                if (entry == null) continue;
                String name = entry.getKey();
                Configuration configuration = entry.getValue();
                if (name == null || configuration == null) continue;
                ArrayList<ConfigElementCategory> list = new ArrayList<ConfigElementCategory>();
                for (String section : configuration.getCategoryNames()) {
                    ConfigCategory category = configuration.getCategory(section);
                    category.setLanguageKey(this.getModID() + ".config." + category.getQualifiedName());
                    if (category.isChild()) continue;
                    list.add(new ConfigElementCategory(category));
                }
                result.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(name, this.getModID() + ".config.title." + name, list));
            }
        }
        return result;
    }
}

