/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.game;

import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import openmods.config.BlockInstances;
import openmods.config.ConfigStorage;
import openmods.config.InstanceContainer;
import openmods.config.ItemInstances;
import openmods.config.game.ConfigurableFeatureManager;
import openmods.config.game.FactoryRegistry;
import openmods.config.game.FeatureRegistry;
import openmods.config.game.GameRegistryObjectsProvider;

public class ModStartupHelper {
    private final Set<Class<? extends BlockInstances>> blockHolders = Sets.newHashSet();
    private final Set<Class<? extends ItemInstances>> itemHolders = Sets.newHashSet();
    private final GameRegistryObjectsProvider gameObjectsProvider;

    public ModStartupHelper(String modId) {
        this.gameObjectsProvider = new GameRegistryObjectsProvider(modId);
    }

    public void registerBlocksHolder(Class<? extends BlockInstances> holder) {
        this.blockHolders.add(holder);
    }

    public void registerItemsHolder(Class<? extends ItemInstances> holder) {
        this.itemHolders.add(holder);
    }

    public void preInit(File configFile) {
        this.preInit(new Configuration(configFile));
    }

    public void preInit(Configuration config) {
        ConfigurableFeatureManager features = new ConfigurableFeatureManager();
        for (Class<? extends BlockInstances> clazz : this.blockHolders) {
            features.collectFromBlocks(clazz);
        }
        for (Class<InstanceContainer<Block>> clazz : this.itemHolders) {
            features.collectFromItems(clazz);
        }
        this.registerCustomFeatures(features);
        this.populateConfig(config);
        Table<String, String, Property> properties = features.loadFromConfiguration(config);
        FeatureRegistry.instance.register(features, properties);
        if (config.hasChanged()) {
            config.save();
        }
        ConfigStorage.instance.register(config);
        this.gameObjectsProvider.setFeatures(features);
        this.setupConfigPre(this.gameObjectsProvider);
        this.setupBlockFactory(this.gameObjectsProvider.getBlockFactory());
        this.setupItemFactory(this.gameObjectsProvider.getItemFactory());
        IForgeRegistry iForgeRegistry = GameRegistry.findRegistry(Item.class);
        IForgeRegistry blocks = GameRegistry.findRegistry(Block.class);
        for (Class<? extends BlockInstances> clazz : this.blockHolders) {
            this.gameObjectsProvider.registerBlocks(clazz, (IForgeRegistry<Block>)blocks, (IForgeRegistry<Item>)iForgeRegistry);
        }
        for (Class<InstanceContainer<Block>> clazz : this.itemHolders) {
            this.gameObjectsProvider.registerItems(clazz, (IForgeRegistry<Item>)iForgeRegistry);
        }
        this.setupConfigPost(this.gameObjectsProvider);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void init() {
        this.gameObjectsProvider.registerItemModels();
    }

    @SubscribeEvent
    public void handleBlockRenames(RegistryEvent.MissingMappings<Block> event) {
        this.gameObjectsProvider.handleBlockRemaps((Collection<RegistryEvent.MissingMappings.Mapping<Block>>)(this.gameObjectsProvider.hasIntraModRenames() ? event.getAllMappings() : event.getMappings()));
    }

    @SubscribeEvent
    public void handleItemRenames(RegistryEvent.MissingMappings<Item> event) {
        this.gameObjectsProvider.handleItemRemaps((Collection<RegistryEvent.MissingMappings.Mapping<Item>>)(this.gameObjectsProvider.hasIntraModRenames() ? event.getAllMappings() : event.getMappings()));
    }

    protected void setupItemFactory(FactoryRegistry<Item> itemFactory) {
    }

    protected void setupBlockFactory(FactoryRegistry<Block> blockFactory) {
    }

    protected void populateConfig(Configuration config) {
    }

    protected void registerCustomFeatures(ConfigurableFeatureManager features) {
    }

    protected void setupConfigPre(GameRegistryObjectsProvider gameConfig) {
    }

    protected void setupConfigPost(GameRegistryObjectsProvider gameConfig) {
    }
}

