/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.armor;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import net.minecraft.nbt.NBTTagCompound;

public class ArmorNBT {
    public int durability = 0;
    public float defense = 0.0f;
    public float toughness = 0.0f;
    public int modifiers = 3;
    private final NBTTagCompound parent;

    public ArmorNBT() {
        this.parent = new NBTTagCompound();
    }

    public ArmorNBT(NBTTagCompound tag) {
        this.read(tag);
        this.parent = tag;
    }

    public ArmorNBT core(int slotIn, CoreMaterialStats core) {
        if (core != null) {
            this.durability += Math.round(core.durability * (float)ArmorHelper.durabilityMultipliers[slotIn]);
            this.defense += core.defense;
        }
        this.durability = Math.max(1, this.durability);
        return this;
    }

    public ArmorNBT trim(int slotIn, TrimMaterialStats trim) {
        if (trim != null) {
            this.durability += Math.round(trim.extraDurability * (float)ArmorHelper.durabilityMultipliers[slotIn]);
        }
        this.durability = Math.max(1, this.durability);
        return this;
    }

    public void plating(int slotIn, PlatesMaterialStats plating) {
        int dur = 0;
        float mod = 0.0f;
        if (plating != null) {
            dur += Math.round(plating.durability * (float)ArmorHelper.durabilityMultipliers[slotIn]);
            mod += plating.modifier;
            this.toughness += plating.toughness;
        }
        this.durability = Math.round((float)this.durability * mod);
        this.durability += dur;
        this.durability = Math.max(1, this.durability);
    }

    public void read(NBTTagCompound tag) {
        this.durability = tag.func_74762_e("Durability");
        this.defense = tag.func_74760_g("Defense");
        this.toughness = tag.func_74760_g("Toughness");
        this.modifiers = tag.func_74762_e("FreeModifiers");
    }

    public void write(NBTTagCompound tag) {
        tag.func_74768_a("Durability", this.durability);
        tag.func_74776_a("Defense", this.defense);
        tag.func_74776_a("Toughness", this.toughness);
        tag.func_74768_a("FreeModifiers", this.modifiers);
    }

    public NBTTagCompound get() {
        NBTTagCompound tag = this.parent.func_74737_b();
        this.write(tag);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArmorNBT armorNBT = (ArmorNBT)o;
        if (this.durability != armorNBT.durability) {
            return false;
        }
        if (Float.compare(armorNBT.defense, this.defense) != 0) {
            return false;
        }
        if (Float.compare(armorNBT.toughness, this.toughness) != 0) {
            return false;
        }
        return this.modifiers == armorNBT.modifiers;
    }

    public int hashCode() {
        int result = this.durability;
        result = 31 * result + (this.defense != 0.0f ? Float.floatToIntBits(this.defense) : 0);
        result = 31 * result + (this.toughness != 0.0f ? Float.floatToIntBits(this.toughness) : 0);
        result = 31 * result + this.modifiers;
        return result;
    }
}

