/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.ASMEventHandler;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.Placebo;
import shadows.placebo.loot.PlaceboLootEntry;
import shadows.placebo.loot.PlaceboLootPool;
import shadows.placebo.loot.PlaceboLootSystem;
import shadows.placebo.util.FastShapelessRecipe;

public class PlaceboDebug {
    public static void debug() {
        PlaceboLootPool.PoolBuilder build = new PlaceboLootPool.PoolBuilder(2.0f, 5.0f, 1.0f, 4.0f);
        build.addEntries(new PlaceboLootEntry(new ItemStack(Items.field_151044_h), 2, 5, 1, 2));
        PlaceboLootSystem.registerLootTable(new ResourceLocation("placebo", "debug"), new LootTable(new LootPool[]{build.build()}));
    }

    public static void dumpEventHandlers() {
        try {
            ConcurrentHashMap map = (ConcurrentHashMap)ReflectionHelper.getPrivateValue(EventBus.class, (Object)MinecraftForge.EVENT_BUS, (String[])new String[]{"listeners"});
            for (Object o : map.keySet()) {
                for (IEventListener iel : (ArrayList)map.get(o)) {
                    String desc = "";
                    if (iel instanceof ASMEventHandler) {
                        desc = desc + ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)((ASMEventHandler)iel), (String[])new String[]{"readable"});
                        Placebo.LOG.info("Found event handler: " + desc);
                        continue;
                    }
                    Placebo.LOG.info("Class " + o.getClass().getName() + " has event handler, but it is not an ASMEventHandler!");
                }
            }
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            Placebo.LOG.error("Failed to dump event handlers!");
        }
    }

    public static void enableFastShapeless() {
        Placebo.LOG.info("Beginning replacement of all shapeless recipes...");
        Placebo.LOG.info("Expect log spam from FML!");
        ArrayList<FastShapelessRecipe> fastRecipes = new ArrayList<FastShapelessRecipe>();
        for (IRecipe iRecipe : ForgeRegistries.RECIPES) {
            if (iRecipe.getClass() != ShapelessRecipes.class && iRecipe.getClass() != ShapelessOreRecipe.class) continue;
            FastShapelessRecipe res = new FastShapelessRecipe(iRecipe.func_193358_e(), iRecipe.func_77571_b(), (NonNullList<Ingredient>)iRecipe.func_192400_c());
            res.setRegistryName(iRecipe.getRegistryName());
            fastRecipes.add(res);
        }
        for (IRecipe iRecipe : fastRecipes) {
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)iRecipe);
        }
        Placebo.LOG.info("Successfully replaced {} recipes with fast recipes.", (Object)fastRecipes.size());
    }
}

