/*
 * Decompiled with CFR 0.152.
 */
package glmath.jglm;

import glmath.jglm.Jglm;
import glmath.jglm.Mat4;
import glmath.jglm.Vec3;

public class Quat {
    public float x;
    public float y;
    public float z;
    public float w;

    public Quat() {
    }

    public Quat(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quat(Vec3 vec, float w) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        this.w = w;
    }

    public Quat(float[] vector1, float[] vector2) {
        float theta = (float)Math.acos(this.dot(vector1, vector2));
        float[] cross = this.cross(vector1, vector2);
        cross = this.normalizeVec(cross);
        this.x = (float)Math.sin(theta / 2.0f) * cross[0];
        this.y = (float)Math.sin(theta / 2.0f) * cross[1];
        this.z = (float)Math.sin(theta / 2.0f) * cross[2];
        this.w = (float)Math.cos(theta / 2.0f);
        this.normalize();
    }

    public float[] toAxis() {
        float[] vec = new float[4];
        float scale = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        vec[0] = (float)Math.acos(this.w) * 2.0f;
        vec[1] = this.x / scale;
        vec[2] = this.y / scale;
        vec[3] = this.z / scale;
        return vec;
    }

    public void printEulerAngles() {
        double d;
        double attitude;
        double heading;
        double test = this.x * this.y + this.z * this.w;
        if (test > 0.499) {
            heading = 2.0 * Math.atan2(this.x, this.w);
            attitude = 1.5707963267948966;
            d = 0.0;
        }
        if (test < -0.499) {
            heading = -2.0 * Math.atan2(this.x, this.w);
            attitude = -1.5707963267948966;
            d = 0.0;
        }
        double sqx = this.x * this.x;
        double sqy = this.y * this.y;
        double sqz = this.z * this.z;
        heading = Math.atan2(2.0f * this.y * this.w - 2.0f * this.x * this.z, 1.0 - 2.0 * sqy - 2.0 * sqz);
        attitude = Math.asin(2.0 * test);
        double bank = Math.atan2(2.0f * this.x * this.w - 2.0f * this.y * this.z, 1.0 - 2.0 * sqx - 2.0 * sqz);
        System.out.println("heading: " + heading + " attitude: " + attitude + " bank: " + bank + " ");
    }

    private float[] normalizeVec(float[] vector) {
        float[] newVector = new float[3];
        float d = (float)Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        if (d > 0.0f) {
            newVector[0] = vector[0] / d;
            newVector[1] = vector[1] / d;
            newVector[2] = vector[2] / d;
        }
        return newVector;
    }

    private float dot(float[] vec1, float[] vec2) {
        return vec1[0] * vec2[0] + vec1[1] * vec2[1] + vec1[2] * vec2[2];
    }

    private float[] cross(float[] vec1, float[] vec2) {
        float[] out = new float[]{vec2[2] * vec1[1] - vec2[1] * vec1[2], vec2[0] * vec1[2] - vec2[2] * vec1[0], vec2[1] * vec1[0] - vec2[0] * vec1[1]};
        return out;
    }

    public static Quat getQuatBetweenVecs(Vec3 v1, Vec3 v2) {
        Vec3 cross = v1.crossProduct(v2);
        Quat quat = new Quat();
        quat.x = cross.x;
        quat.y = cross.y;
        quat.z = cross.z;
        quat.w = v1.length() * v2.length() + v1.dot(v2);
        return quat;
    }

    public static Quat getQuatBetweenVecs1(Vec3 a, Vec3 b) {
        Quat quat;
        Vec3 xUnit = new Vec3(1.0f, 0.0f, 0.0f);
        Vec3 yUnit = new Vec3(0.0f, 1.0f, 0.0f);
        float dot = a.dot(b);
        if ((double)dot < -0.999999) {
            Vec3 tmp = xUnit.crossProduct(a);
            if ((double)tmp.length() < 1.0E-6) {
                tmp = yUnit.crossProduct(a);
            }
            tmp.normalize();
            quat = Jglm.angleAxis(180.0f, tmp);
        } else if ((double)dot > 0.999999) {
            quat = new Quat(0.0f, 0.0f, 0.0f, 1.0f);
        } else {
            Vec3 tmp = a.crossProduct(b);
            quat = new Quat(tmp.x, tmp.y, tmp.z, 1.0f + dot);
            quat.normalize();
        }
        return quat;
    }

    public float getW() {
        return this.w;
    }

    public void setW(float w) {
        this.w = w;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void add(Quat q) {
        this.x += q.x;
        this.y += q.y;
        this.z += q.z;
    }

    public void subtract(Quat q) {
        this.x -= q.x;
        this.y -= q.y;
        this.z -= q.z;
    }

    public void divide(float n) {
        this.x /= n;
        this.y /= n;
        this.z /= n;
    }

    public Quat mult(Quat q) {
        Quat result = new Quat();
        result.x = this.w * q.x + this.x * q.w + this.y * q.z - this.z * q.y;
        result.y = this.w * q.y + this.y * q.w + this.z * q.x - this.x * q.z;
        result.z = this.w * q.z + this.z * q.w + this.x * q.y - this.y * q.x;
        result.w = this.w * q.w - (this.x * q.x + this.y * q.y + this.z * q.z);
        return result;
    }

    public Quat mult(float n) {
        Quat result = new Quat(this.x, this.y, this.z, this.w);
        result.x *= n;
        result.y *= n;
        result.z *= n;
        return result;
    }

    public Vec3 mult(Vec3 v) {
        Vec3 quatVector = new Vec3(this.x, this.y, this.z);
        Vec3 uv = quatVector.crossProduct(v);
        Vec3 uuv = quatVector.crossProduct(uv);
        uv = uv.times(2.0f * this.w);
        uuv = uuv.times(2.0f);
        return v.plus(uv).plus(uuv);
    }

    public final void normalize() {
        float norme = (float)Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
        if (norme == 0.0f) {
            this.w = 1.0f;
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        } else {
            float recip = 1.0f / norme;
            this.w *= recip;
            this.x *= recip;
            this.y *= recip;
            this.z *= recip;
        }
    }

    public Quat conjugate() {
        float norm = this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
        return new Quat(-this.x / norm, -this.y / norm, -this.z / norm, this.w / norm);
    }

    public Mat4 toMatrix() {
        float[] matrix = new float[]{1.0f - 2.0f * this.y * this.y - 2.0f * this.z * this.z, 2.0f * this.x * this.y + 2.0f * this.w * this.z, 2.0f * this.x * this.z - 2.0f * this.w * this.y, 0.0f, 2.0f * this.x * this.y - 2.0f * this.w * this.z, 1.0f - 2.0f * this.x * this.x - 2.0f * this.z * this.z, 2.0f * this.y * this.z + 2.0f * this.w * this.x, 0.0f, 2.0f * this.x * this.z + 2.0f * this.w * this.y, 2.0f * this.y * this.z - 2.0f * this.w * this.x, 1.0f - 2.0f * this.x * this.x - 2.0f * this.y * this.y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return new Mat4(matrix);
    }

    public void slerp(Quat a, Quat b, float t) {
        float cosom = a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
        if ((double)(1.0f + cosom) > Math.E) {
            float sclq;
            float sclp;
            if ((double)(1.0f - cosom) > Math.E) {
                float omega = (float)Math.acos(cosom);
                float sinom = (float)Math.sin(omega);
                sclp = (float)Math.sin((1.0f - t) * omega) / sinom;
                sclq = (float)Math.sin(t * omega) / sinom;
            } else {
                sclp = 1.0f - t;
                sclq = t;
            }
            this.x = sclp * a.x + sclq * b.x;
            this.y = sclp * a.y + sclq * b.y;
            this.z = sclp * a.z + sclq * b.z;
            this.w = sclp * a.w + sclq * b.w;
        } else {
            this.x = -a.y;
            this.y = a.x;
            this.z = -a.w;
            this.w = a.z;
            float sclp = (float)Math.sin((double)(1.0f - t) * Math.PI * 0.5);
            float sclq = (float)Math.sin((double)t * Math.PI * 0.5);
            this.x = sclp * a.x + sclq * b.x;
            this.y = sclp * a.y + sclq * b.y;
            this.z = sclp * a.z + sclq * b.z;
        }
    }

    public boolean isEmpty() {
        return this.w == 1.0f && this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public boolean isIdentity() {
        return this.w == 0.0f && this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public void setFromMatrix(float[] m) {
        float T = m[0] + m[4] + m[8] + 1.0f;
        if (T > 0.0f) {
            float S = 0.5f / (float)Math.sqrt(T);
            this.w = 0.25f / S;
            this.x = (m[5] - m[7]) * S;
            this.y = (m[6] - m[2]) * S;
            this.z = (m[1] - m[3]) * S;
        } else if (m[0] > m[4] & m[0] > m[8]) {
            float S = (float)(Math.sqrt(1.0f + m[0] - m[4] - m[8]) * 2.0);
            this.w = (m[7] - m[5]) / S;
            this.x = 0.25f * S;
            this.y = (m[3] + m[1]) / S;
            this.z = (m[6] + m[2]) / S;
        } else if (m[4] > m[8]) {
            float S = (float)(Math.sqrt(1.0f + m[4] - m[0] - m[8]) * 2.0);
            this.w = (m[6] - m[2]) / S;
            this.x = (m[3] + m[1]) / S;
            this.y = 0.25f * S;
            this.z = (m[7] + m[5]) / S;
        } else {
            float S = (float)(Math.sqrt(1.0f + m[8] - m[0] - m[4]) * 2.0);
            this.w = (m[3] - m[1]) / S;
            this.x = (m[6] + m[2]) / S;
            this.y = (m[7] + m[5]) / S;
            this.z = 0.25f * S;
        }
    }

    public boolean isRotationMatrix(float[] m) {
        double epsilon = 0.01;
        if ((double)Math.abs(m[0] * m[3] + m[3] * m[4] + m[6] * m[7]) > epsilon) {
            return false;
        }
        if ((double)Math.abs(m[0] * m[2] + m[3] * m[5] + m[6] * m[8]) > epsilon) {
            return false;
        }
        if ((double)Math.abs(m[1] * m[2] + m[4] * m[5] + m[7] * m[8]) > epsilon) {
            return false;
        }
        if ((double)Math.abs(m[0] * m[0] + m[3] * m[3] + m[6] * m[6] - 1.0f) > epsilon) {
            return false;
        }
        if ((double)Math.abs(m[1] * m[1] + m[4] * m[4] + m[7] * m[7] - 1.0f) > epsilon) {
            return false;
        }
        if ((double)Math.abs(m[2] * m[2] + m[5] * m[5] + m[8] * m[8] - 1.0f) > epsilon) {
            return false;
        }
        return (double)Math.abs(this.determinant(m) - 1.0f) < epsilon;
    }

    private float determinant(float[] m) {
        return m[0] * m[4] * m[8] + m[3] * m[7] * m[2] + m[6] * m[1] * m[5] - m[0] * m[7] * m[5] - m[3] * m[1] * m[8] - m[6] * m[4] * m[2];
    }

    public void print(String title) {
        System.out.println(title + " (" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")");
    }
}

