/*
 * Decompiled with CFR 0.152.
 */
package glmath.jglm;

import glmath.jglm.Mat;
import glmath.jglm.Mat4;
import glmath.jglm.Vec3;

public class Mat3
extends Mat {
    public Vec3 c0;
    public Vec3 c1;
    public Vec3 c2;

    public Mat3() {
        this.order = 3;
        this.c0 = new Vec3();
        this.c1 = new Vec3();
        this.c2 = new Vec3();
    }

    public Mat3(float value) {
        this();
        for (int i = 0; i < this.order; ++i) {
            this.set(i * (this.order + 1), value);
        }
    }

    public Mat3(Mat4 mat4) {
        this();
        this.c0 = new Vec3(mat4.c0.x, mat4.c0.y, mat4.c0.z);
        this.c1 = new Vec3(mat4.c1.x, mat4.c1.y, mat4.c1.z);
        this.c2 = new Vec3(mat4.c2.x, mat4.c2.y, mat4.c2.z);
    }

    public Mat3(Vec3 v0, Vec3 v1, Vec3 v2) {
        this();
        this.c0 = v0;
        this.c1 = v1;
        this.c2 = v2;
    }

    public Mat3(float[] fs) {
        this();
        this.c0 = new Vec3(fs, this.order * 0);
        this.c1 = new Vec3(fs, this.order * 1);
        this.c2 = new Vec3(fs, this.order * 2);
    }

    public float[] toFloatArray() {
        return new float[]{this.c0.x, this.c0.y, this.c0.z, this.c1.x, this.c1.y, this.c1.z, this.c2.x, this.c2.y, this.c2.z};
    }

    public void setDiagonal(Vec3 vec3) {
        this.c0.x = vec3.x;
        this.c1.y = vec3.y;
        this.c2.z = vec3.z;
    }

    public static Mat3 rotateX(float fAngDeg) {
        float fAngRad = (float)Math.toRadians(fAngDeg);
        float fCos = (float)Math.cos(fAngRad);
        float fSin = (float)Math.sin(fAngRad);
        Mat3 mat3 = new Mat3(1.0f);
        mat3.c1.y = fCos;
        mat3.c1.z = fSin;
        mat3.c2.y = -fSin;
        mat3.c2.z = fCos;
        return mat3;
    }

    public static Mat3 rotateY(float fAngDeg) {
        float fAngRad = (float)Math.toRadians(fAngDeg);
        float fCos = (float)Math.cos(fAngRad);
        float fSin = (float)Math.sin(fAngRad);
        Mat3 mat3 = new Mat3(1.0f);
        mat3.c0.x = fCos;
        mat3.c0.z = -fSin;
        mat3.c2.x = fSin;
        mat3.c2.z = fCos;
        return mat3;
    }

    public static Mat3 rotateZ(float fAngDeg) {
        float fAngRad = (float)Math.toRadians(fAngDeg);
        float fCos = (float)Math.cos(fAngRad);
        float fSin = (float)Math.sin(fAngRad);
        Mat3 mat3 = new Mat3(1.0f);
        mat3.c0.x = fCos;
        mat3.c0.y = fSin;
        mat3.c1.x = -fSin;
        mat3.c1.y = fCos;
        return mat3;
    }

    public Mat3 times(Mat3 mat) {
        float[] result = new float[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                float partial = 0.0f;
                for (int k = 0; k < 3; ++k) {
                    partial += this.toFloatArray()[3 * k + j] * mat.toFloatArray()[3 * i + k];
                }
                result[3 * i + j] = partial;
            }
        }
        return new Mat3(result);
    }

    public Vec3 mult(Vec3 second) {
        float[] result = new float[3];
        for (int i = 0; i < this.order; ++i) {
            float partial = 0.0f;
            for (int j = 0; j < this.order; ++j) {
                partial += this.toFloatArray()[3 * j + i] * second.toFloatArray()[j];
            }
            result[i] = partial;
        }
        return new Vec3(result);
    }

    public Mat3 inverse() {
        Mat3 inverse = new Mat3();
        inverse.c0.x = this.c1.y * this.c2.z - this.c2.y * this.c1.z;
        inverse.c1.x = -(this.c1.x * this.c2.z - this.c2.x * this.c1.z);
        inverse.c2.x = this.c1.x * this.c2.y - this.c2.x * this.c1.y;
        inverse.c0.y = -(this.c0.y * this.c2.z - this.c2.y * this.c0.z);
        inverse.c1.y = this.c0.x * this.c2.z - this.c2.x * this.c0.z;
        inverse.c2.y = -(this.c0.x * this.c2.y - this.c2.x * this.c0.y);
        inverse.c0.z = this.c0.y * this.c1.z - this.c1.y * this.c0.z;
        inverse.c1.z = -(this.c0.x * this.c1.z - this.c1.x * this.c0.z);
        inverse.c2.z = this.c0.x * this.c1.y - this.c1.x * this.c0.y;
        inverse.divide(this.determinant());
        return inverse;
    }

    public Mat3 divide(float s) {
        Vec3 newC0 = new Vec3(this.c0.x / s, this.c0.y / s, this.c0.z / s);
        Vec3 newC1 = new Vec3(this.c1.x / s, this.c1.y / s, this.c1.z / s);
        Vec3 newC2 = new Vec3(this.c2.x / s, this.c2.y / s, this.c2.z / s);
        return new Mat3(newC0, newC1, newC2);
    }

    public float determinant() {
        return this.c0.x * (this.c1.y * this.c2.z - this.c2.y * this.c1.z) - this.c1.x * (this.c0.y * this.c2.z - this.c2.y * this.c0.z) + this.c2.x * (this.c0.y * this.c1.z - this.c1.y * this.c0.z);
    }

    public Mat3 transpose() {
        Mat3 result = new Mat3();
        result.c0.x = this.c0.x;
        result.c0.y = this.c1.x;
        result.c0.z = this.c2.x;
        result.c1.x = this.c0.y;
        result.c1.y = this.c1.y;
        result.c1.z = this.c2.y;
        result.c2.x = this.c0.z;
        result.c2.y = this.c1.z;
        result.c2.z = this.c2.z;
        return result;
    }

    public final void set(int index, float value) {
        switch (index) {
            case 0: {
                this.c0.x = value;
                break;
            }
            case 1: {
                this.c0.y = value;
                break;
            }
            case 2: {
                this.c0.z = value;
                break;
            }
            case 3: {
                this.c1.x = value;
                break;
            }
            case 4: {
                this.c1.y = value;
                break;
            }
            case 5: {
                this.c1.z = value;
                break;
            }
            case 6: {
                this.c2.x = value;
                break;
            }
            case 7: {
                this.c2.y = value;
                break;
            }
            case 8: {
                this.c2.z = value;
            }
        }
    }

    public final float get(int index) {
        switch (index) {
            case 0: {
                return this.c0.x;
            }
            case 1: {
                return this.c0.y;
            }
            case 2: {
                return this.c0.z;
            }
            case 3: {
                return this.c1.x;
            }
            case 4: {
                return this.c1.y;
            }
            case 5: {
                return this.c1.z;
            }
            case 6: {
                return this.c2.x;
            }
            case 7: {
                return this.c1.y;
            }
            case 8: {
                return this.c1.z;
            }
        }
        return -1.0f;
    }

    public void print() {
        System.out.println(this.c0.x + " " + this.c1.x + " " + this.c2.x + "\n");
        System.out.println(this.c0.y + " " + this.c1.y + " " + this.c2.y + "\n");
        System.out.println(this.c0.z + " " + this.c1.z + " " + this.c2.z + "\n");
    }

    public void print(String title) {
        System.out.println("" + title);
        System.out.println(this.c0.x + " " + this.c1.x + " " + this.c2.x + "\n");
        System.out.println(this.c0.y + " " + this.c1.y + " " + this.c2.y + "\n");
        System.out.println(this.c0.z + " " + this.c1.z + " " + this.c2.z + "\n");
    }
}

