/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator;

import com.hbm.render.amlfrom1710.Vec3;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class DungeonToolbox {
    public static void generateBox(World world, int x, int y, int z, int sx, int sy, int sz, List<IBlockState> blocks) {
        if (blocks.isEmpty()) {
            return;
        }
        for (int i = x; i < x + sx; ++i) {
            for (int j = y; j < y + sy; ++j) {
                for (int k = z; k < z + sz; ++k) {
                    IBlockState b = DungeonToolbox.getRandom(blocks, world.field_73012_v);
                    if (b == null) {
                        b = Blocks.field_150350_a.func_176223_P();
                    }
                    world.func_180501_a(new BlockPos(i, j, k), b, 2);
                }
            }
        }
    }

    public static void generateBox(World world, int x, int y, int z, int sx, int sy, int sz, IBlockState block) {
        for (int i = x; i < x + sx; ++i) {
            for (int j = y; j < y + sy; ++j) {
                for (int k = z; k < z + sz; ++k) {
                    world.func_180501_a(new BlockPos(i, j, k), block, 2);
                }
            }
        }
    }

    public static void generateBox(World world, int x, int y, int z, Vec3 size, List<IBlockState> blocks) {
        DungeonToolbox.generateBox(world, x, y, z, (int)size.xCoord, (int)size.yCoord, (int)size.zCoord, blocks);
    }

    public static <T> T getRandom(List<T> list, Random rand) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(rand.nextInt(list.size()));
    }

    public static void generateOre(World world, Random rand, int chunkX, int chunkZ, int veinCount, int amount, int minHeight, int variance, Block ore) {
        DungeonToolbox.generateOre(world, rand, chunkX, chunkZ, veinCount, amount, minHeight, variance, ore.func_176223_P(), Blocks.field_150348_b);
    }

    public static void generateOre(World world, Random rand, int chunkX, int chunkZ, int veinCount, int amount, int minHeight, int variance, IBlockState ore) {
        DungeonToolbox.generateOre(world, rand, chunkX, chunkZ, veinCount, amount, minHeight, variance, ore, Blocks.field_150348_b);
    }

    public static void generateOre(World world, Random rand, int chunkX, int chunkZ, int veinCount, int amount, int minHeight, int variance, Block ore, Block target) {
        DungeonToolbox.generateOre(world, rand, chunkX, chunkZ, veinCount, amount, minHeight, variance, ore.func_176223_P(), target);
    }

    public static void generateOre(World world, Random rand, int chunkX, int chunkZ, int veinCount, int amount, int minHeight, int variance, IBlockState ore, Block target) {
        if (veinCount > 0) {
            for (int i = 0; i < veinCount; ++i) {
                int x = chunkX + rand.nextInt(16);
                int y = minHeight + (variance > 0 ? rand.nextInt(variance) : 0);
                int z = chunkZ + rand.nextInt(16);
                new WorldGenMinable(ore, amount, state -> state.func_177230_c() == target).func_180709_b(world, rand, new BlockPos(x, y, z));
            }
        }
    }
}

