/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.blocks.items.ItemBlockHazard;
import com.hbm.capability.HbmLivingCapability;
import com.hbm.capability.HbmLivingProps;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.mob.EntityQuackos;
import com.hbm.handler.ArmorUtil;
import com.hbm.handler.HazmatRegistry;
import com.hbm.interfaces.IItemHazard;
import com.hbm.interfaces.IRadiationImmune;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.potion.HbmPotion;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.ArmorRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ContaminationUtil {
    public static final String NTM_NEUTRON_NBT_KEY = "ntmNeutron";

    public static float calculateRadiationMod(EntityLivingBase entity) {
        if (entity.func_70644_a((Potion)HbmPotion.mutation)) {
            return 0.0f;
        }
        float mult = 1.0f;
        if (entity.getEntityData().func_150297_b("hbmradmultiplier", 99)) {
            mult = entity.getEntityData().func_74760_g("hbmradmultiplier");
        }
        float koeff = 10.0f;
        return (float)Math.pow(koeff, -(ContaminationUtil.getConfigEntityRadResistance((Entity)entity) + HazmatRegistry.getResistance(entity))) * mult;
    }

    private static void applyRadData(Entity e, float f) {
        if (e instanceof IRadiationImmune) {
            return;
        }
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        if (e instanceof EntityPlayer && (((EntityPlayer)e).field_71075_bZ.field_75098_d || ((EntityPlayer)e).func_175149_v())) {
            return;
        }
        if (e instanceof EntityPlayer && e.field_70173_aa < 200) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        f *= ContaminationUtil.calculateRadiationMod(entity);
        if (entity.hasCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null)) {
            HbmLivingCapability.IEntityHbmProps ent = (HbmLivingCapability.IEntityHbmProps)entity.getCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null);
            ent.increaseRads(f);
        }
    }

    private static void applyRadDirect(Entity entity, float f) {
        if (entity instanceof IRadiationImmune) {
            return;
        }
        if (entity.getEntityData().func_150297_b("hbmradmultiplier", 99)) {
            f *= entity.getEntityData().func_74760_g("hbmradmultiplier");
        }
        if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).func_175149_v())) {
            return;
        }
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        if (((EntityLivingBase)entity).func_70644_a((Potion)HbmPotion.mutation)) {
            return;
        }
        if (entity.hasCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null)) {
            HbmLivingCapability.IEntityHbmProps ent = (HbmLivingCapability.IEntityHbmProps)entity.getCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null);
            ent.increaseRads(f);
        }
    }

    public static void printGeigerData(EntityPlayer player) {
        double eRad = (double)((long)(HbmLivingProps.getRadiation((EntityLivingBase)player) * 1000.0f)) / 1000.0;
        RadiationSavedData data = RadiationSavedData.getData(player.field_70170_p);
        double rads = (double)((long)((double)data.getRadNumFromCoord(player.func_180425_c()) * 1000.0)) / 1000.0;
        double env = (double)((long)(ContaminationUtil.getPlayerRads((EntityLivingBase)player) * 1000.0)) / 1000.0;
        double res = Library.roundFloat((1.0 - (double)ContaminationUtil.calculateRadiationMod((EntityLivingBase)player)) * 100.0, 6);
        double resKoeff = (double)((long)((double)HazmatRegistry.getResistance((EntityLivingBase)player) * 100.0)) / 100.0;
        double rec = (double)((long)(env * (100.0 - res) / 100.0 * 1000.0)) / 1000.0;
        String chunkPrefix = ContaminationUtil.getPreffixFromRad(rads);
        String envPrefix = ContaminationUtil.getPreffixFromRad(env);
        String recPrefix = ContaminationUtil.getPreffixFromRad(rec);
        String radPrefix = "";
        String resPrefix = "" + TextFormatting.WHITE;
        radPrefix = eRad < 200.0 ? radPrefix + TextFormatting.GREEN : (eRad < 400.0 ? radPrefix + TextFormatting.YELLOW : (eRad < 600.0 ? radPrefix + TextFormatting.GOLD : (eRad < 800.0 ? radPrefix + TextFormatting.RED : (eRad < 1000.0 ? radPrefix + TextFormatting.DARK_RED : radPrefix + TextFormatting.DARK_GRAY))));
        if (resKoeff > 0.0) {
            resPrefix = resPrefix + TextFormatting.GREEN;
        }
        player.func_145747_a(new TextComponentString("===== \u2622 ").func_150257_a((ITextComponent)new TextComponentTranslation("geiger.title", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" \u2622 =====")).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        player.func_145747_a(new TextComponentTranslation("geiger.chunkRad", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(" " + chunkPrefix + rads + " RAD/s")).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        player.func_145747_a(new TextComponentTranslation("geiger.envRad", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(" " + envPrefix + env + " RAD/s")).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        player.func_145747_a(new TextComponentTranslation("geiger.recievedRad", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(" " + recPrefix + rec + " RAD/s")).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        player.func_145747_a(new TextComponentTranslation("geiger.playerRad", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(" " + radPrefix + eRad + " RAD")).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        player.func_145747_a(new TextComponentTranslation("geiger.playerRes", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(" " + resPrefix + String.format("%.6f", res) + "% (" + resKoeff + ")")).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
    }

    public static void printDosimeterData(EntityPlayer player) {
        double rads = ContaminationUtil.getActualPlayerRads((EntityLivingBase)player);
        boolean limit = false;
        if (rads > 3.6) {
            rads = 3.6;
            limit = true;
        }
        rads = (double)((int)(1000.0 * rads)) / 1000.0;
        String radsPrefix = ContaminationUtil.getPreffixFromRad(rads);
        player.func_145747_a(new TextComponentString("===== \u2622 ").func_150257_a((ITextComponent)new TextComponentTranslation("dosimeter.title", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" \u2622 =====")).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        player.func_145747_a(new TextComponentTranslation("geiger.recievedRad", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(" " + radsPrefix + (limit ? ">" : "") + rads + " RAD/s")).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
    }

    public static String getTextColorFromPercent(double percent) {
        if (percent < 0.5) {
            return "" + TextFormatting.GREEN;
        }
        if (percent < 0.6) {
            return "" + TextFormatting.YELLOW;
        }
        if (percent < 0.7) {
            return "" + TextFormatting.GOLD;
        }
        if (percent < 0.8) {
            return "" + TextFormatting.RED;
        }
        if (percent < 0.9) {
            return "" + TextFormatting.DARK_RED;
        }
        return "" + TextFormatting.DARK_GRAY;
    }

    public static String getTextColorLung(double percent) {
        if (percent > 0.9) {
            return "" + TextFormatting.GREEN;
        }
        if (percent > 0.75) {
            return "" + TextFormatting.YELLOW;
        }
        if (percent > 0.5) {
            return "" + TextFormatting.GOLD;
        }
        if (percent > 0.25) {
            return "" + TextFormatting.RED;
        }
        if (percent > 0.1) {
            return "" + TextFormatting.DARK_RED;
        }
        return "" + TextFormatting.DARK_GRAY;
    }

    public static void printDiagnosticData(EntityPlayer player) {
        double digamma = (double)((int)(HbmLivingProps.getDigamma((EntityLivingBase)player) * 1000.0f)) / 1000.0;
        double halflife = (double)((int)((1.0 - Math.pow(0.5, digamma)) * 10000.0)) / 100.0;
        player.func_145747_a(new TextComponentString("===== \u03dc ").func_150257_a((ITextComponent)new TextComponentTranslation("digamma.title", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" \u03dc =====")).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)));
        player.func_145747_a(new TextComponentTranslation("digamma.playerDigamma", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(TextFormatting.RED + " " + digamma + " DRX")).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)));
        player.func_145747_a(new TextComponentTranslation("digamma.playerHealth", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(ContaminationUtil.getTextColorFromPercent(halflife / 100.0) + String.format(" %6.2f", halflife) + "%")).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)));
    }

    public static void printLungDiagnosticData(EntityPlayer player) {
        float playerAsbestos = 100.0f - (float)((int)(10000.0f * (float)HbmLivingProps.getAsbestos((EntityLivingBase)player) / 72000.0f)) / 100.0f;
        float playerBlacklung = 100.0f - (float)((int)(10000.0f * (float)HbmLivingProps.getBlackLung((EntityLivingBase)player) / 72000.0f)) / 100.0f;
        float playerTotal = playerAsbestos * playerBlacklung / 100.0f;
        player.func_145747_a(new TextComponentString("===== L ").func_150257_a((ITextComponent)new TextComponentTranslation("lung_scanner.title", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" L =====")).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
        player.func_145747_a(new TextComponentTranslation("lung_scanner.player_asbestos_health", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)).func_150257_a((ITextComponent)new TextComponentString(String.format(ContaminationUtil.getTextColorLung((double)playerAsbestos / 100.0) + " %6.2f", Float.valueOf(playerAsbestos)) + " %")));
        player.func_145747_a(new TextComponentTranslation("lung_scanner.player_coal_health", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)).func_150257_a((ITextComponent)new TextComponentString(String.format(ContaminationUtil.getTextColorLung((double)playerBlacklung / 100.0) + " %6.2f", Float.valueOf(playerBlacklung)) + " %")));
        player.func_145747_a(new TextComponentTranslation("lung_scanner.player_total_health", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150257_a((ITextComponent)new TextComponentString(String.format(ContaminationUtil.getTextColorLung((double)playerTotal / 100.0) + " %6.2f", Float.valueOf(playerTotal)) + " %")));
    }

    public static double getStackRads(ItemStack stack) {
        NBTTagCompound stackNBT;
        if (stack == null) {
            return 0.0;
        }
        Item item = stack.func_77973_b();
        double rads = 0.0;
        if (item instanceof IItemHazard) {
            rads += (double)((IItemHazard)item).getModule().radiation;
        }
        if (item instanceof ItemBlockHazard) {
            rads += (double)((ItemBlockHazard)item).getModule().radiation;
        }
        if (stack.func_77942_o() && (stackNBT = stack.func_77978_p()).func_74764_b(NTM_NEUTRON_NBT_KEY)) {
            rads += (double)stackNBT.func_74760_g(NTM_NEUTRON_NBT_KEY);
        }
        if (rads > 1.0) {
            return rads;
        }
        return 0.0;
    }

    public static double getActualPlayerRads(EntityLivingBase entity) {
        return ContaminationUtil.getPlayerRads(entity) * (double)ContaminationUtil.calculateRadiationMod(entity);
    }

    public static double getPlayerRads(EntityLivingBase entity) {
        float rads = HbmLivingProps.getRadBuf(entity);
        if (entity instanceof EntityPlayer) {
            rads += HbmLivingProps.getNeutron((EntityLivingBase)((EntityPlayer)entity)) * 20.0f;
        }
        return rads;
    }

    public static double getNoNeutronPlayerRads(EntityLivingBase entity) {
        return (double)HbmLivingProps.getRadBuf(entity) * (double)ContaminationUtil.calculateRadiationMod(entity);
    }

    public static float getPlayerNeutronRads(EntityPlayer player) {
        float radBuffer = 0.0f;
        for (ItemStack slotI : player.field_71071_by.field_70462_a) {
            radBuffer += ContaminationUtil.getNeutronRads(slotI);
        }
        for (ItemStack slotA : player.field_71071_by.field_70460_b) {
            radBuffer += ContaminationUtil.getNeutronRads(slotA);
        }
        return radBuffer;
    }

    public static boolean isRadItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof IItemHazard && ((IItemHazard)stack.func_77973_b()).isRadioactive()) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemBlockHazard && ((ItemBlockHazard)stack.func_77973_b()).getModule().radiation > 0.0f;
    }

    public static float getNeutronRads(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack != null && !stack.func_190926_b() && !ContaminationUtil.isRadItem(stack) && stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b(NTM_NEUTRON_NBT_KEY)) {
            return nbt.func_74760_g(NTM_NEUTRON_NBT_KEY) * (float)stack.func_190916_E();
        }
        return 0.0f;
    }

    public static void neutronActivateInventory(EntityPlayer player, float rad, float decay) {
        for (int slotI = 0; slotI < player.field_71071_by.func_70302_i_() - 1; ++slotI) {
            if (slotI == player.field_71071_by.field_70461_c) continue;
            ContaminationUtil.neutronActivateItem(player.field_71071_by.func_70301_a(slotI), rad, decay);
        }
        for (ItemStack slotA : player.field_71071_by.field_70460_b) {
            ContaminationUtil.neutronActivateItem(slotA, rad, decay);
        }
    }

    public static void neutronActivateItem(ItemStack stack, float rad, float decay) {
        if (stack != null && !stack.func_190926_b() && !ContaminationUtil.isRadItem(stack)) {
            if (stack.func_190916_E() > 1) {
                return;
            }
            NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            float prevActivation = 0.0f;
            if (nbt.func_74764_b(NTM_NEUTRON_NBT_KEY)) {
                prevActivation = nbt.func_74760_g(NTM_NEUTRON_NBT_KEY);
            }
            if (prevActivation + rad == 0.0f) {
                return;
            }
            float newActivation = prevActivation * decay + rad / (float)stack.func_190916_E();
            if (prevActivation * decay + rad < 1.0E-4f || rad <= 0.0f && newActivation < 0.001f) {
                nbt.func_82580_o(NTM_NEUTRON_NBT_KEY);
            } else {
                nbt.func_74776_a(NTM_NEUTRON_NBT_KEY, newActivation);
            }
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            } else {
                stack.func_77982_d(nbt);
            }
        }
    }

    public static boolean isContaminated(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(NTM_NEUTRON_NBT_KEY);
    }

    public static String getPreffixFromRad(double rads) {
        String chunkPrefix = "";
        chunkPrefix = rads == 0.0 ? chunkPrefix + TextFormatting.GREEN : (rads < 1.0 ? chunkPrefix + TextFormatting.YELLOW : (rads < 10.0 ? chunkPrefix + TextFormatting.GOLD : (rads < 100.0 ? chunkPrefix + TextFormatting.RED : (rads < 1000.0 ? chunkPrefix + TextFormatting.DARK_RED : chunkPrefix + TextFormatting.DARK_GRAY))));
        return chunkPrefix;
    }

    public static float getRads(Entity e) {
        if (e instanceof IRadiationImmune) {
            return 0.0f;
        }
        if (e instanceof EntityLivingBase) {
            return HbmLivingProps.getRadiation((EntityLivingBase)e);
        }
        return 0.0f;
    }

    public static float getConfigEntityRadResistance(Entity e) {
        float totalResistanceValue = 0.0f;
        if (!(e instanceof EntityPlayer)) {
            ResourceLocation entity_path = EntityList.func_191301_a((Entity)e);
            Object resistanceMod = CompatibilityConfig.mobModRadresistance.get(entity_path.func_110624_b());
            Object resistanceMob = CompatibilityConfig.mobRadresistance.get(entity_path.toString());
            if (resistanceMod != null) {
                totalResistanceValue += ((Float)resistanceMod).floatValue();
            }
            if (resistanceMob != null) {
                totalResistanceValue += ((Float)resistanceMob).floatValue();
            }
        }
        return totalResistanceValue;
    }

    public static boolean checkConfigEntityImmunity(Entity e) {
        ResourceLocation entity_path;
        if (!(e instanceof EntityPlayer) && (entity_path = EntityList.func_191301_a((Entity)e)) != null) {
            if (CompatibilityConfig.mobModRadimmune.contains(entity_path.func_110624_b())) {
                return true;
            }
            return CompatibilityConfig.mobRadimmune.contains(entity_path.toString());
        }
        return false;
    }

    public static boolean isRadImmune(Entity e) {
        if (e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70644_a((Potion)HbmPotion.mutation)) {
            return true;
        }
        return e instanceof EntityZombie || e instanceof EntitySkeleton || e instanceof EntityQuackos || e instanceof EntityOcelot || e instanceof EntityMooshroom || e instanceof EntityZombieHorse || e instanceof EntitySkeletonHorse || e instanceof IRadiationImmune || ContaminationUtil.checkConfigEntityImmunity(e);
    }

    public static void applyAsbestos(Entity e, int i, int dmg) {
        ContaminationUtil.applyAsbestos(e, i, dmg, 1);
    }

    public static void applyAsbestos(Entity e, int i, int dmg, int chance) {
        if (!GeneralConfig.enableAsbestos) {
            return;
        }
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            return;
        }
        if (e instanceof EntityPlayer && e.field_70173_aa < 200) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        if (ArmorRegistry.hasProtection(entity, EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.PARTICLE_FINE)) {
            if (chance > 1) {
                if (entity.field_70170_p.field_73012_v.nextInt(chance) == 0) {
                    ArmorUtil.damageGasMaskFilter(entity, 1);
                }
            } else {
                ArmorUtil.damageGasMaskFilter(entity, dmg);
            }
        } else {
            HbmLivingProps.incrementAsbestos(entity, i);
        }
    }

    public static void applyCoal(Entity e, int i, int dmg) {
        ContaminationUtil.applyCoal(e, i, dmg, 1);
    }

    public static void applyCoal(Entity e, int i, int dmg, int chance) {
        if (!GeneralConfig.enableCoal) {
            return;
        }
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            return;
        }
        if (e instanceof EntityPlayer && e.field_70173_aa < 200) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        if (ArmorRegistry.hasProtection(entity, EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.PARTICLE_COARSE)) {
            if (chance > 1) {
                if (entity.field_70170_p.field_73012_v.nextInt(chance) == 0) {
                    ArmorUtil.damageGasMaskFilter(entity, 1);
                }
            } else {
                ArmorUtil.damageGasMaskFilter(entity, dmg);
            }
        } else {
            HbmLivingProps.incrementBlackLung(entity, i);
        }
    }

    public static void applyDigammaData(Entity e, float f) {
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        if (e instanceof EntityQuackos || e instanceof EntityOcelot) {
            return;
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            return;
        }
        if (e instanceof EntityPlayer && e.field_70173_aa < 200) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        if (entity.func_70644_a((Potion)HbmPotion.stability)) {
            return;
        }
        if (!(entity instanceof EntityPlayer) || !ArmorUtil.checkForDigamma((EntityPlayer)entity)) {
            HbmLivingProps.incrementDigamma(entity, f);
        }
    }

    public static void applyDigammaDirect(Entity e, float f) {
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        if (e instanceof IRadiationImmune) {
            return;
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        HbmLivingProps.incrementDigamma(entity, f);
    }

    public static float getDigamma(Entity e) {
        if (!(e instanceof EntityLivingBase)) {
            return 0.0f;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        return HbmLivingProps.getDigamma(entity);
    }

    public static void radiate(World world, double x, double y, double z, double range, float rad3d) {
        ContaminationUtil.radiate(world, x, y, z, range, rad3d, 0.0f, 0.0f);
    }

    public static void radiate(World world, double x, double y, double z, double range, float rad3d, float fire3d) {
        ContaminationUtil.radiate(world, x, y, z, range, rad3d, 0.0f, fire3d);
    }

    public static void radiate(World world, double x, double y, double z, double range, float rad3d, float dig3d, float fire3d) {
        List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(x, y, z, x, y, z).func_72314_b(range, range, range));
        for (EntityLivingBase e : entities) {
            Vec3 vec = Vec3.createVectorHelper(e.field_70165_t - x, e.field_70163_u + (double)e.func_70047_e() - y, e.field_70161_v - z);
            double len = vec.lengthVector();
            vec = vec.normalize();
            float res = 0.0f;
            int i = 1;
            while ((double)i < len) {
                int ix = (int)Math.floor(x + vec.xCoord * (double)i);
                int iy = (int)Math.floor(y + vec.yCoord * (double)i);
                int iz = (int)Math.floor(z + vec.zCoord * (double)i);
                res += world.func_180495_p(new BlockPos(ix, iy, iz)).func_177230_c().func_149638_a(null);
                ++i;
            }
            if (res < 1.0f) {
                res = 1.0f;
            }
            if (rad3d > 0.0f) {
                float eRads = rad3d;
                eRads /= res;
                ContaminationUtil.contaminate(e, HazardType.RADIATION, ContaminationType.CREATIVE, eRads /= (float)(len * len));
            }
            if (dig3d > 0.0f) {
                float eDig = dig3d;
                eDig /= res;
                ContaminationUtil.contaminate(e, HazardType.DIGAMMA, ContaminationType.DIGAMMA, eDig /= (float)(len * len));
            }
            if (len < 15.0 && fire3d > 0.0f) {
                float fireDmg = fire3d;
                fireDmg /= (float)Math.sqrt(res);
                e.func_70097_a(DamageSource.field_76372_a, fireDmg /= (float)(len * len));
            }
            if (!(e instanceof EntityPlayer) || !(len < 10.0)) continue;
            EntityPlayer p = (EntityPlayer)e;
            if (p.func_184614_ca().func_77973_b() == ModItems.marshmallow && p.func_70681_au().nextInt(100) == 0) {
                p.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(ModItems.marshmallow_roasted));
            }
            if (p.func_184592_cb().func_77973_b() != ModItems.marshmallow || p.func_70681_au().nextInt(100) != 0) continue;
            p.func_184611_a(EnumHand.OFF_HAND, new ItemStack(ModItems.marshmallow_roasted));
        }
    }

    public static boolean contaminate(EntityLivingBase entity, HazardType hazard, ContaminationType cont, float amount) {
        if (hazard == HazardType.RADIATION) {
            float radEnv = HbmLivingProps.getRadEnv(entity);
            HbmLivingProps.setRadEnv(entity, radEnv + amount);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            switch (cont) {
                case GOGGLES: {
                    if (!ArmorUtil.checkForGoggles(player)) break;
                    return false;
                }
                case FARADAY: {
                    if (!ArmorUtil.checkForFaraday(player)) break;
                    return false;
                }
                case HAZMAT: {
                    if (!ArmorUtil.checkForHazmat(player)) break;
                    return false;
                }
                case HAZMAT2: {
                    if (!ArmorUtil.checkForHaz2(player)) break;
                    return false;
                }
                case DIGAMMA: {
                    if (!ArmorUtil.checkForDigamma(player)) break;
                    return false;
                }
            }
            if (player.field_71075_bZ.field_75098_d && cont != ContaminationType.NONE) {
                if (hazard == HazardType.NEUTRON) {
                    HbmLivingProps.setNeutron(entity, amount);
                }
                return false;
            }
            if (player.field_70173_aa < 200) {
                return false;
            }
        }
        if ((hazard == HazardType.RADIATION || hazard == HazardType.NEUTRON) && ContaminationUtil.isRadImmune((Entity)entity)) {
            return false;
        }
        switch (hazard) {
            case MONOXIDE: {
                entity.func_70097_a(ModDamageSource.monoxide, amount);
                break;
            }
            case RADIATION: {
                HbmLivingProps.incrementRadiation(entity, amount * (cont == ContaminationType.RAD_BYPASS ? 1.0f : ContaminationUtil.calculateRadiationMod(entity)));
                break;
            }
            case NEUTRON: {
                HbmLivingProps.incrementRadiation(entity, amount * (cont == ContaminationType.RAD_BYPASS ? 1.0f : ContaminationUtil.calculateRadiationMod(entity)));
                HbmLivingProps.setNeutron(entity, amount);
                break;
            }
            case DIGAMMA: {
                ContaminationUtil.applyDigammaData((Entity)entity, amount);
            }
        }
        return true;
    }

    public static enum ContaminationType {
        GAS,
        GAS_NON_REACTIVE,
        GOGGLES,
        FARADAY,
        HAZMAT,
        HAZMAT2,
        DIGAMMA,
        DIGAMMA2,
        CREATIVE,
        RAD_BYPASS,
        NONE;

    }

    public static enum HazardType {
        MONOXIDE,
        RADIATION,
        NEUTRON,
        DIGAMMA;

    }
}

