/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.blocks.turret.TurretBase;
import com.hbm.entity.logic.EntityBomber;
import com.hbm.entity.missile.EntityMIRV;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.lib.Library;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TETurretCIWSPacket;
import com.hbm.packet.TETurretPacket;
import com.hbm.tileentity.turret.TileEntityTurretCIWS;
import com.hbm.tileentity.turret.TileEntityTurretCheapo;
import com.hbm.tileentity.turret.TileEntityTurretFlamer;
import com.hbm.tileentity.turret.TileEntityTurretSpitfire;
import com.hbm.tileentity.turret.TileEntityTurretTau;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityTurretBase
extends TileEntity
implements ITickable {
    public double rotationYaw;
    public double rotationPitch;
    public double oldRotationYaw = 0.0;
    public double oldRotationPitch = 0.0;
    public boolean isAI = false;
    public List<String> players = new ArrayList<String>();
    public int use;
    public int ammo = 0;
    private int detectAmmo;
    private boolean detectIsAI;
    public boolean playerListChanged = true;

    public void func_73660_a() {
        if (this.isAI) {
            Object[] iter = this.field_145850_b.field_72996_f.toArray();
            double radius = 1000.0;
            if (this instanceof TileEntityTurretFlamer) {
                radius /= 3.0;
            }
            if (this instanceof TileEntityTurretSpitfire) {
                radius *= 3.0;
            }
            if (this instanceof TileEntityTurretCIWS) {
                radius *= 250.0;
            }
            Entity target = null;
            for (int i = 0; i < iter.length; ++i) {
                double distance;
                Entity e = (Entity)iter[i];
                if (!e.func_70089_S() || !this.isInSight(e) || !((distance = e.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5)) < radius)) continue;
                radius = distance;
                target = e;
            }
            if (target != null) {
                Vec3d turret = new Vec3d(target.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5), target.field_70163_u + (double)target.func_70047_e() - (double)(this.field_174879_c.func_177956_o() + 1), target.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5));
                if (this instanceof TileEntityTurretCIWS || this instanceof TileEntityTurretSpitfire || this instanceof TileEntityTurretCheapo) {
                    Vec3d targetPos = target.func_174813_aQ().func_189972_c();
                    turret = new Vec3d(targetPos.field_72450_a - ((double)this.field_174879_c.func_177958_n() + 0.5), targetPos.field_72448_b - ((double)this.field_174879_c.func_177956_o() + 1.5), targetPos.field_72449_c - ((double)this.field_174879_c.func_177952_p() + 0.5));
                }
                this.oldRotationPitch = this.rotationPitch;
                this.oldRotationYaw = this.rotationYaw;
                double sqrt = MathHelper.func_76133_a((double)(turret.field_72450_a * turret.field_72450_a + turret.field_72449_c * turret.field_72449_c));
                this.rotationPitch = -Math.atan2(turret.field_72448_b, sqrt) * 180.0 / Math.PI;
                this.rotationYaw = -Math.atan2(turret.field_72450_a, turret.field_72449_c) * 180.0 / Math.PI;
                float maxAngle = -60.0f;
                if (this instanceof TileEntityTurretCIWS) {
                    maxAngle = -80.0f;
                }
                if (this.rotationPitch < (double)maxAngle) {
                    this.rotationPitch = maxAngle;
                }
                if (this.rotationPitch > 30.0) {
                    this.rotationPitch = 30.0;
                }
                if (this instanceof TileEntityTurretCheapo) {
                    if (this.rotationPitch < -30.0) {
                        this.rotationPitch = -30.0;
                    }
                    if (this.rotationPitch > 15.0) {
                        this.rotationPitch = 15.0;
                    }
                }
                if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof TurretBase && this.ammo > 0 && ((TurretBase)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).executeHoldAction(this.field_145850_b, this.use, this.rotationYaw, this.rotationPitch, this.field_174879_c)) {
                    --this.ammo;
                }
                ++this.use;
            } else {
                this.use = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.detectAndSendChanges();
        }
    }

    private boolean isInSight(Entity e) {
        if (!(e instanceof EntityLivingBase || e instanceof EntityMissileBaseAdvanced || e instanceof EntityBomber || e instanceof EntityMIRV || e instanceof EntityMissileCustom)) {
            return false;
        }
        if (!(!(this instanceof TileEntityTurretCIWS) || e instanceof EntityMissileBaseAdvanced || e instanceof EntityMissileCustom || e instanceof EntityBomber || e instanceof EntityMIRV)) {
            return false;
        }
        if (e instanceof EntityPlayer && this.players.contains(((EntityPlayer)e).func_145748_c_().func_150260_c())) {
            return false;
        }
        if (this instanceof TileEntityTurretTau) {
            return true;
        }
        if (e instanceof EntityBomber && !((EntityBomber)e).isBomberAlive()) {
            return false;
        }
        Vec3d turret = this instanceof TileEntityTurretSpitfire || this instanceof TileEntityTurretCIWS || this instanceof TileEntityTurretCheapo ? new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5) : new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5);
        Vec3d entity = new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v);
        Vec3d side = new Vec3d(entity.field_72450_a - turret.field_72450_a, entity.field_72448_b - turret.field_72448_b, entity.field_72449_c - turret.field_72449_c);
        side = side.func_72432_b();
        Vec3d check = new Vec3d(turret.field_72450_a + side.field_72450_a, turret.field_72448_b + side.field_72448_b, turret.field_72449_c + side.field_72449_c);
        return !Library.isObstructed(this.field_145850_b, check.field_72450_a, check.field_72448_b, check.field_72449_c, entity.field_72450_a, entity.field_72448_b, entity.field_72449_c);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.rotationYaw = nbt.func_74769_h("yaw");
        this.rotationPitch = nbt.func_74769_h("pitch");
        this.isAI = nbt.func_74767_n("AI");
        this.ammo = nbt.func_74762_e("ammo");
        int playercount = nbt.func_74762_e("playercount");
        for (int i = 0; i < playercount; ++i) {
            if (!nbt.func_74764_b("player_" + i)) continue;
            this.players.add(nbt.func_74779_i("player_" + i));
        }
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74780_a("yaw", this.rotationYaw);
        nbt.func_74780_a("pitch", this.rotationPitch);
        nbt.func_74757_a("AI", this.isAI);
        nbt.func_74768_a("ammo", this.ammo);
        nbt.func_74768_a("playercount", this.players.size());
        for (int i = 0; i < this.players.size(); ++i) {
            nbt.func_74778_a("player_" + i, this.players.get(i));
        }
        return super.func_189515_b(nbt);
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.isAI != this.detectIsAI) {
            this.detectIsAI = this.isAI;
            mark = true;
        }
        if (this.ammo != this.detectAmmo) {
            this.detectAmmo = this.ammo;
            mark = true;
        }
        if (this.playerListChanged) {
            for (EntityPlayer player : this.field_145850_b.field_73010_i) {
                if (!(player instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound())));
            }
            this.playerListChanged = false;
            mark = true;
        }
        if (this.isAI && this instanceof TileEntityTurretCIWS) {
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new TETurretCIWSPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.rotationYaw, this.rotationPitch), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 1000.0));
        }
        PacketDispatcher.wrapper.sendToAllTracking((IMessage)new TETurretPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.isAI), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

