/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network.energy;

import api.hbm.energy.IEnergyConnector;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.hbm.config.GeneralConfig;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntityLoadedBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityConverterHeRf
extends TileEntityLoadedBase
implements ITickable,
IEnergyConnector,
IEnergyProvider,
IEnergyStorage {
    private boolean recursionBrake = false;
    private long lastTransfer = 0L;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public long transferPower(long power) {
        if (this.recursionBrake) {
            return power;
        }
        this.recursionBrake = true;
        int toRF = (int)Math.min(Integer.MAX_VALUE, power);
        int rfTransferred = 0;
        int totalTransferred = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyStorage storage;
            TileEntity entity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
            if (entity != null && entity instanceof IEnergyReceiver) {
                IEnergyReceiver receiver = (IEnergyReceiver)entity;
                rfTransferred = receiver.receiveEnergy(dir.getOpposite().toEnumFacing(), toRF, false);
                totalTransferred += rfTransferred;
                toRF -= rfTransferred;
            }
            if (entity == null || !entity.hasCapability(CapabilityEnergy.ENERGY, dir.getOpposite().toEnumFacing()) || !(storage = (IEnergyStorage)entity.getCapability(CapabilityEnergy.ENERGY, dir.getOpposite().toEnumFacing())).canReceive()) continue;
            rfTransferred = storage.receiveEnergy(toRF, false);
            totalTransferred += rfTransferred;
            toRF -= rfTransferred;
        }
        this.recursionBrake = false;
        this.lastTransfer = totalTransferred / GeneralConfig.rfConversionRate;
        return power - (long)(totalTransferred / GeneralConfig.rfConversionRate);
    }

    @Override
    public long getPower() {
        return 0L;
    }

    @Override
    public long getMaxPower() {
        return Integer.MAX_VALUE / GeneralConfig.rfConversionRate;
    }

    @Override
    public long getTransferWeight() {
        if (this.lastTransfer > 0L) {
            return this.lastTransfer * 2L;
        }
        return this.getMaxPower();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return maxExtract;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }
}

