/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network.energy;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IPowerNet;
import api.hbm.energy.PowerNet;
import com.hbm.lib.ForgeDirection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class TileEntityCableBaseNT
extends TileEntity
implements ITickable,
IEnergyConductor {
    protected IPowerNet network;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.canUpdate()) {
            this.setPowerNet(null);
            this.connect();
            if (this.getPowerNet() == null) {
                this.setPowerNet(new PowerNet().joinLink(this));
            }
        }
    }

    protected void connect() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyConductor conductor;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
            if (!(te instanceof IEnergyConductor) || !(conductor = (IEnergyConductor)te).canConnect(dir.getOpposite())) continue;
            if (this.getPowerNet() == null && conductor.getPowerNet() != null) {
                conductor.getPowerNet().joinLink(this);
            }
            if (this.getPowerNet() == null || conductor.getPowerNet() == null || this.getPowerNet() == conductor.getPowerNet()) continue;
            conductor.getPowerNet().joinNetworks(this.getPowerNet());
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.network != null) {
            this.network.reevaluate();
            this.network = null;
        }
    }

    public boolean canUpdate() {
        return (this.network == null || !this.network.isValid()) && !this.func_145837_r();
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN;
    }

    @Override
    public long getPower() {
        return 0L;
    }

    @Override
    public long getMaxPower() {
        return 0L;
    }

    @Override
    public void setPowerNet(IPowerNet network) {
        this.network = network;
    }

    @Override
    public long transferPower(long power) {
        if (this.network == null) {
            return power;
        }
        return this.network.transferPower(power);
    }

    @Override
    public IPowerNet getPowerNet() {
        return this.network;
    }
}

