/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.machine.rbmk.RBMKControl;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityRBMKControlManual
extends TileEntityRBMKControl
implements IControlReceiver {
    public RBMKColor color;
    public double startingLevel;

    public void setColor(int color) {
        RBMKColor new_color;
        this.color = new_color = RBMKColor.values()[color];
    }

    public boolean isSameColor(int color) {
        return this.color == RBMKColor.values()[color];
    }

    @Override
    public String getName() {
        return "container.rbmkControl";
    }

    @Override
    public boolean isModerated() {
        return ((RBMKControl)this.func_145838_q()).moderated;
    }

    @Override
    public void setTarget(double target) {
        this.targetLevel = target;
        this.startingLevel = this.level;
    }

    @Override
    public double getMult() {
        double surge = 0.0;
        if (this.targetLevel < this.startingLevel && Math.abs(this.level - this.targetLevel) > 0.01) {
            surge = Math.sin(Math.pow(1.0 - this.level, 15.0) * Math.PI) * (this.startingLevel - this.targetLevel) * RBMKDials.getSurgeMod(this.field_145850_b);
        }
        return this.level + surge;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.createVectorHelper((double)this.field_174879_c.func_177958_n() - player.field_70165_t, (double)this.field_174879_c.func_177956_o() - player.field_70163_u, (double)this.field_174879_c.func_177952_p() - player.field_70161_v).lengthVector() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("level")) {
            this.setTarget(data.func_74769_h("level"));
        }
        if (data.func_74764_b("color")) {
            int c = Math.abs(data.func_74762_e("color")) % RBMKColor.values().length;
            RBMKColor newCol = RBMKColor.values()[c];
            this.color = newCol == this.color ? null : newCol;
        }
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("startingLevel")) {
            this.startingLevel = nbt.func_74769_h("startingLevel");
        }
        this.color = nbt.func_74764_b("color") ? RBMKColor.values()[nbt.func_74762_e("color")] : null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("startingLevel", this.startingLevel);
        nbt.func_74780_a("mult", this.getMult());
        if (this.color != null) {
            nbt.func_74768_a("color", this.color.ordinal());
        }
        return nbt;
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.CONTROL;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = super.getNBTForConsole();
        if (this.color != null) {
            data.func_74777_a("color", (short)this.color.ordinal());
        } else {
            data.func_74777_a("color", (short)-1);
        }
        return data;
    }

    public static enum RBMKColor {
        RED,
        YELLOW,
        GREEN,
        BLUE,
        PURPLE;

    }
}

