/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCapacitor;
import com.hbm.items.special.WatzFuel;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.world.Watz;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityWatzCore
extends TileEntityLoadedBase
implements ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 1000000000L;
    public int heat;
    public int heatMultiplier;
    public int powerMultiplier;
    public int decayMultiplier;
    public int heatList;
    public int wasteList;
    public int powerList;
    public int age = 0;
    Random rand = new Random();
    public ItemStackHandler inventory = new ItemStackHandler(40){

        protected void onContentsChanged(int slot) {
            TileEntityWatzCore.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    public FluidTank tank = new FluidTank(64000);
    public Fluid tankType = ModForgeFluids.watz;
    public boolean needsUpdate = false;
    private String customName;

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.watzPowerplant";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.tank.readFromNBT(compound);
        this.tankType = ModForgeFluids.watz;
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        this.tank.writeToNBT(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isStructureValid(this.field_145850_b)) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tank);
            }
            this.sendWatzPower();
            this.powerMultiplier = 100;
            this.heatMultiplier = 100;
            this.decayMultiplier = 100;
            this.powerList = 0;
            this.heatList = 0;
            this.heat = 0;
            if (this.hasFuse()) {
                int i;
                for (i = 0; i < 36; ++i) {
                    this.surveyPellet(this.inventory.getStackInSlot(i));
                }
                for (i = 0; i < 36; ++i) {
                    this.surveyPelletAgain(this.inventory.getStackInSlot(i));
                }
                for (i = 0; i < 36; ++i) {
                    this.decayPellet(i);
                }
            }
            if (this.heatList > 0) {
                ItemCapacitor.setDura(this.inventory.getStackInSlot(38), ItemCapacitor.getDura(this.inventory.getStackInSlot(38)) - 1);
                this.func_70296_d();
            }
            this.heatList *= this.heatMultiplier;
            this.heatList /= 100;
            this.heat = this.heatList;
            this.powerList *= this.powerMultiplier;
            this.powerList /= 100;
            this.power += (long)this.powerList;
            this.tank.fill(new FluidStack(this.tankType, this.decayMultiplier * this.heat / 100 / 100), true);
            this.needsUpdate = true;
            if (this.power > 1000000000L) {
                this.power = 1000000000L;
            }
            if (this.tank.getFluidAmount() >= this.tank.getCapacity()) {
                this.emptyWaste();
            }
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 37, this.power, 1000000000L);
            if (FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 36, 39)) {
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
        }
    }

    public boolean isStructureValid(World world) {
        return Watz.checkHull(world, this.field_174879_c);
    }

    public boolean hasFuse() {
        return this.inventory.getStackInSlot(38).func_77973_b() == ModItems.titanium_filter && ItemCapacitor.getDura(this.inventory.getStackInSlot(38)) > 0;
    }

    public long getPowerScaled(long i) {
        return this.power / 100L * i / 10000000L;
    }

    public void surveyPellet(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof WatzFuel) {
            WatzFuel fuel = (WatzFuel)stack.func_77973_b();
            this.powerList += fuel.power;
            this.heatList += fuel.heat;
        }
    }

    public void surveyPelletAgain(ItemStack stack) {
        if (stack.func_77973_b() instanceof WatzFuel) {
            WatzFuel fuel = (WatzFuel)stack.func_77973_b();
            this.powerMultiplier = (int)((float)this.powerMultiplier * fuel.powerMultiplier);
            this.heatMultiplier = (int)((float)this.heatMultiplier * fuel.heatMultiplier);
            this.decayMultiplier = (int)((float)this.decayMultiplier * fuel.decayMultiplier);
        }
    }

    public void decayPellet(int i) {
        if (this.inventory.getStackInSlot(i).func_77973_b() instanceof WatzFuel) {
            WatzFuel fuel = (WatzFuel)this.inventory.getStackInSlot(i).func_77973_b();
            WatzFuel.setLifeTime(this.inventory.getStackInSlot(i), WatzFuel.getLifeTime(this.inventory.getStackInSlot(i)) + this.decayMultiplier);
            WatzFuel.updateDamage(this.inventory.getStackInSlot(i));
            if (WatzFuel.getLifeTime(this.inventory.getStackInSlot(i)) >= fuel.lifeTime) {
                if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.pellet_lead) {
                    this.inventory.setStackInSlot(i, new ItemStack(ModItems.powder_lead));
                } else {
                    this.inventory.setStackInSlot(i, new ItemStack(ModItems.pellet_lead));
                }
            }
        }
    }

    public void emptyWaste() {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        this.tank.drain(this.tank.getFluidAmount() / 4, true);
        this.needsUpdate = true;
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 4, y, z)).func_177230_c() == Blocks.field_150350_a) {
                this.field_145850_b.func_175656_a((BlockPos)mPos.func_181079_c(x + 4, y, z), ModBlocks.mud_block.func_176223_P());
                this.field_145850_b.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 3.0f, 0.5f);
            } else if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 4, y, z)).func_177230_c() == Blocks.field_150350_a) {
                this.field_145850_b.func_175656_a((BlockPos)mPos.func_181079_c(x - 4, y, z), ModBlocks.mud_block.func_176223_P());
                this.field_145850_b.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 3.0f, 0.5f);
            } else if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z + 4)).func_177230_c() == Blocks.field_150350_a) {
                this.field_145850_b.func_175656_a((BlockPos)mPos.func_181079_c(x, y, z + 4), ModBlocks.mud_block.func_176223_P());
                this.field_145850_b.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 3.0f, 0.5f);
            } else if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z - 4)).func_177230_c() == Blocks.field_150350_a) {
                this.field_145850_b.func_175656_a((BlockPos)mPos.func_181079_c(x, y, z - 4), ModBlocks.mud_block.func_176223_P());
                this.field_145850_b.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 3.0f, 0.5f);
            } else if (this.rand.nextInt(10) != 0) {
                for (int i = -3; i <= 3; ++i) {
                    for (int j = -5; j <= 5; ++j) {
                        for (int k = -3; k <= 3; ++k) {
                            if (this.rand.nextInt(2) != 0) continue;
                            this.field_145850_b.func_175656_a((BlockPos)mPos.func_181079_c(x + i, y + j, z + k), ModBlocks.mud_block.func_176223_P());
                        }
                    }
                }
                this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.mud_block.func_176223_P());
                this.field_145850_b.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 3.0f, 0.5f);
                this.field_145850_b.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 3.0f, 0.75f);
            } else {
                EntityNukeExplosionMK3 entity = new EntityNukeExplosionMK3(this.field_145850_b);
                entity.field_70165_t = x;
                entity.field_70163_u = y;
                entity.field_70161_v = z;
                entity.destructionRange = BombConfig.fleijaRadius;
                entity.speed = 25;
                entity.coefficient = 1.0f;
                entity.waste = false;
                this.field_145850_b.func_72838_d((Entity)entity);
            }
        }
    }

    public void sendWatzPower() {
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177981_b(7), ForgeDirection.UP);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177979_c(7), ForgeDirection.DOWN);
    }

    public void fillFluidInit(FluidTank tank) {
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(4, 0, 0), 16000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-4, 0, 0), 16000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 4), 16000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -4), 16000) || this.needsUpdate;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == this.tankType) {
            this.needsUpdate = true;
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tank.getFluidAmount() > 0) {
            this.needsUpdate = true;
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this) : super.getCapability(capability, facing));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000000L;
    }
}

