/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.entity.particle.EntitySSmokeFX;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TETurbofanPacket;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineTurbofan
extends TileEntityLoadedBase
implements ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor {
    public ItemStackHandler inventory = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            TileEntityMachineTurbofan.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    public long power;
    public int soundCycle = 0;
    public static final long maxPower = 1000000L;
    public FluidTank tank = new FluidTank(64000);
    public int afterburner;
    public boolean isRunning;
    public float spin;
    public float lastSpin;
    public int momentum = 0;
    public boolean needsUpdate = false;
    private String customName;
    public AudioWrapper audio;

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.machineTurbofan";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        this.tank.readFromNBT(compound);
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        this.tank.writeToNBT(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000L;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int nrg = 1250;
            int cnsp = 1;
            this.afterburner = 0;
            if (!this.inventory.getStackInSlot(2).func_190926_b()) {
                if (this.inventory.getStackInSlot(2).func_77973_b() == ModItems.upgrade_afterburn_1) {
                    nrg *= 2;
                    cnsp = (int)((double)cnsp * 2.5);
                    this.afterburner = 1;
                }
                if (this.inventory.getStackInSlot(2).func_77973_b() == ModItems.upgrade_afterburn_2) {
                    nrg *= 3;
                    cnsp *= 5;
                    this.afterburner = 2;
                }
                if (this.inventory.getStackInSlot(2).func_77973_b() == ModItems.upgrade_afterburn_3) {
                    nrg *= 4;
                    cnsp = (int)((double)cnsp * 7.5);
                    this.afterburner = 3;
                }
            }
            int prevFluidAmount = this.tank.getFluidAmount();
            long prevPower = this.power;
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.sendTurboPower();
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 3, this.power, 1000000L);
            if (this.inputValidForTank(-1, 0) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 0, 1)) {
                this.needsUpdate = true;
            }
            this.isRunning = false;
            if (this.tank.getFluidAmount() >= cnsp) {
                this.tank.drain(cnsp, true);
                this.needsUpdate = true;
                this.power += (long)nrg;
                this.isRunning = true;
                if (this.power > 1000000L) {
                    this.power = 1000000L;
                }
                ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getRotation(ForgeDirection.UP);
                ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                if (this.afterburner > 0) {
                    for (int i = 0; i < this.afterburner * 2; ++i) {
                        if (this.afterburner <= 0 || this.field_145850_b.field_73012_v.nextInt(2) != 0) continue;
                        double speed = 2.0 + this.field_145850_b.field_73012_v.nextDouble() * 3.0;
                        double deviation = this.field_145850_b.field_73012_v.nextGaussian() * 0.2;
                        EntitySSmokeFX smoke = new EntitySSmokeFX(this.field_145850_b);
                        smoke.field_70165_t = (double)this.field_174879_c.func_177958_n() + 0.5;
                        smoke.field_70163_u = (double)this.field_174879_c.func_177956_o() + 1.25;
                        smoke.field_70161_v = (double)this.field_174879_c.func_177952_p() + 0.5;
                        smoke.field_70159_w = (double)(-dir.offsetX) * speed + deviation;
                        smoke.field_70181_x = 0.0;
                        smoke.field_70179_y = (double)(-dir.offsetZ) * speed + deviation;
                        if (this.field_145850_b.field_72995_K) continue;
                        this.field_145850_b.func_72838_d((Entity)smoke);
                    }
                }
                double minX = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                double maxX = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 12.5 + (double)rot.offsetX * 1.5;
                double minZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                double maxZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 12.5 + (double)rot.offsetZ * 1.5;
                List listIntake = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(Math.min(minX, maxX), (double)this.field_174879_c.func_177956_o(), Math.min(minZ, maxZ), Math.max(minX, maxX), (double)(this.field_174879_c.func_177956_o() + 3), Math.max(minZ, maxZ)));
                for (Object e : listIntake) {
                    e.func_70024_g((double)(-dir.offsetX) * 0.3 * (double)(this.afterburner + 1), 0.0, (double)(-dir.offsetZ) * 0.3 * (double)(this.afterburner + 1));
                }
                minX = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                maxX = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 3.75 + (double)rot.offsetX * 1.5;
                minZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                maxZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 3.75 + (double)rot.offsetZ * 1.5;
                List listKill = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(Math.min(minX, maxX), (double)this.field_174879_c.func_177956_o(), Math.min(minZ, maxZ), Math.max(minX, maxX), (double)(this.field_174879_c.func_177956_o() + 3), Math.max(minZ, maxZ)));
                for (Entity e : listKill) {
                    e.func_70097_a(ModDamageSource.turbofan, 1000.0f);
                    e.func_70110_aj();
                    if (e.func_70089_S() || !(e instanceof EntityLivingBase)) continue;
                    NBTTagCompound vdat = new NBTTagCompound();
                    vdat.func_74778_a("type", "giblets");
                    vdat.func_74768_a("ent", e.func_145782_y());
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(vdat, e.field_70165_t, e.field_70163_u + (double)e.field_70131_O * 0.5, e.field_70161_v), new NetworkRegistry.TargetPoint(e.field_71093_bK, e.field_70165_t, e.field_70163_u + (double)e.field_70131_O * 0.5, e.field_70161_v, 150.0));
                    this.field_145850_b.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, SoundEvents.field_187929_hc, SoundCategory.HOSTILE, 2.0f, 0.95f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                }
                minX = (double)this.field_174879_c.func_177958_n() + 0.5 - (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                maxX = (double)this.field_174879_c.func_177958_n() + 0.5 - (double)dir.offsetX * 19.5 + (double)rot.offsetX * 1.5;
                minZ = (double)this.field_174879_c.func_177952_p() + 0.5 - (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                maxZ = (double)this.field_174879_c.func_177952_p() + 0.5 - (double)dir.offsetZ * 19.5 + (double)rot.offsetZ * 1.5;
                List listExhaust = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(Math.min(minX, maxX), (double)this.field_174879_c.func_177956_o(), Math.min(minZ, maxZ), Math.max(minX, maxX), (double)(this.field_174879_c.func_177956_o() + 3), Math.max(minZ, maxZ)));
                for (Entity e : listExhaust) {
                    if (this.afterburner > 0) {
                        e.func_70015_d(5);
                        e.func_70097_a(DamageSource.field_76372_a, 3.0f * (float)this.afterburner);
                    }
                    e.func_70024_g((double)(-dir.offsetX) * 0.5 * (double)(this.afterburner + 1), 0.0, (double)(-dir.offsetZ) * 0.5 * (double)(this.afterburner + 1));
                }
            }
            if (prevFluidAmount != this.tank.getFluidAmount() || prevPower != this.power) {
                this.func_70296_d();
            }
        } else {
            this.lastSpin = this.spin;
            if (this.isRunning) {
                if (this.momentum < 50 + this.afterburner * 50) {
                    ++this.momentum;
                } else if (this.momentum > 50 + this.afterburner * 50) {
                    --this.momentum;
                }
                ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getRotation(ForgeDirection.UP);
                ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                double minX = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                double maxX = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 12.5 + (double)rot.offsetX * 1.5;
                double minZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                double maxZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 12.5 + (double)rot.offsetZ * 1.5;
                List listIntake = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(Math.min(minX, maxX), (double)this.field_174879_c.func_177956_o(), Math.min(minZ, maxZ), Math.max(minX, maxX), (double)(this.field_174879_c.func_177956_o() + 3), Math.max(minZ, maxZ)));
                for (EntityPlayer e : listIntake) {
                    if (e != MainRegistry.proxy.me()) continue;
                    e.func_70024_g((double)(-dir.offsetX) * 0.3 * (double)(this.afterburner + 1), 0.0, (double)(-dir.offsetZ) * 0.3 * (double)(this.afterburner + 1));
                }
                minX = (double)this.field_174879_c.func_177958_n() + 0.5 - (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                maxX = (double)this.field_174879_c.func_177958_n() + 0.5 - (double)dir.offsetX * 19.5 + (double)rot.offsetX * 1.5;
                minZ = (double)this.field_174879_c.func_177952_p() + 0.5 - (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                maxZ = (double)this.field_174879_c.func_177952_p() + 0.5 - (double)dir.offsetZ * 19.5 + (double)rot.offsetZ * 1.5;
                List listExhaust = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(Math.min(minX, maxX), (double)this.field_174879_c.func_177956_o(), Math.min(minZ, maxZ), Math.max(minX, maxX), (double)(this.field_174879_c.func_177956_o() + 3), Math.max(minZ, maxZ)));
                for (EntityPlayer e : listExhaust) {
                    if (e != MainRegistry.proxy.me()) continue;
                    e.func_70024_g((double)(-dir.offsetX) * 0.5 * (double)(this.afterburner + 1), 0.0, (double)(-dir.offsetZ) * 0.5 * (double)(this.afterburner + 1));
                }
            } else if (this.momentum > 0) {
                --this.momentum;
            }
            this.spin += (float)(this.momentum / 2);
            if (this.spin >= 360.0f) {
                this.spin -= 360.0f;
                this.lastSpin -= 360.0f;
            }
            if (this.momentum > 0) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                }
                this.audio.updateVolume(this.momentum);
                this.audio.updatePitch((float)this.momentum / 150.0f + 0.75f);
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
                this.momentum = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new TETurbofanPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.isRunning), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        }
    }

    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound(HBMSoundHandler.turbofanOperate, SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 1.0f, 1.0f);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        return !this.inventory.getStackInSlot(slot).func_190926_b() && this.isValidFluid(FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
    }

    private boolean isValidFluid(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.getFluid() == ModForgeFluids.kerosene;
    }

    protected void sendTurboPower() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getRotation(ForgeDirection.UP);
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * 2, 0, rot.offsetZ * 2), rot);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * 2 - dir.offsetX, 0, rot.offsetZ * 2 - dir.offsetZ), rot);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * -2, 0, rot.offsetZ * -2), rot.getOpposite());
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * -2 - dir.offsetX, 0, rot.offsetZ * -2 - dir.offsetZ), rot.getOpposite());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluid(resource)) {
            if (this.tank.fill(resource, false) > 0) {
                this.needsUpdate = true;
            }
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }
}

