/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityLoadedBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineSeleniumEngine
extends TileEntityLoadedBase
implements ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor {
    public ItemStackHandler inventory = new ItemStackHandler(14){

        protected void onContentsChanged(int slot) {
            TileEntityMachineSeleniumEngine.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    public long power;
    public int soundCycle = 0;
    public static final long maxPower = 250000L;
    public long powerCap = 250000L;
    public FluidTank tank = new FluidTank(16000);
    public Fluid tankType = ModForgeFluids.diesel;
    public boolean needsUpdate = true;
    public int pistonCount = 0;
    private String customName;

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.machineSelenium";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        this.powerCap = compound.func_74763_f("powerCap");
        this.tank.readFromNBT(compound);
        this.tankType = FluidRegistry.getFluid((String)compound.func_74779_i("tankType"));
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        compound.func_74772_a("powerCap", this.powerCap);
        this.tank.writeToNBT(compound);
        compound.func_74778_a("tankType", this.tankType.getName());
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public long getPowerScaled(long i) {
        return this.power * i / this.powerCap;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, 0), ForgeDirection.DOWN);
            this.pistonCount = this.countPistons();
            if (this.tank.getFluid() != null) {
                this.tankType = this.tank.getFluid().getFluid();
            }
            if (this.inputValidForTank(-1, 9) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 9, 10)) {
                this.needsUpdate = true;
            }
            this.powerCap = this.tankType == ModForgeFluids.nitan ? 2500000L : 250000L;
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 13, this.power, this.powerCap);
            if (this.pistonCount > 2) {
                this.generate();
            }
            if (this.needsUpdate) {
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tank}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
                this.needsUpdate = false;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.pistonCount, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), (int)this.powerCap, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
        }
    }

    public int countPistons() {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.piston_selenium) continue;
            ++count;
        }
        return count;
    }

    public boolean hasAcceptableFuel() {
        return this.getHEFromFuel() > 0;
    }

    public int getHEFromFuel() {
        if (this.tankType == ModForgeFluids.smear) {
            return 50;
        }
        if (this.tankType == ModForgeFluids.heatingoil) {
            return 75;
        }
        if (this.tankType == ModForgeFluids.diesel) {
            return 225;
        }
        if (this.tankType == ModForgeFluids.kerosene) {
            return 300;
        }
        if (this.tankType == ModForgeFluids.reclaimed) {
            return 100;
        }
        if (this.tankType == ModForgeFluids.petroil) {
            return 125;
        }
        if (this.tankType == ModForgeFluids.biofuel) {
            return 200;
        }
        if (this.tankType == ModForgeFluids.nitan) {
            return 2500;
        }
        return 0;
    }

    public void generate() {
        if (this.hasAcceptableFuel() && this.tank.getFluidAmount() > 0) {
            if (this.soundCycle == 0) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187619_bk, SoundCategory.BLOCKS, 1.0f, 0.5f);
            }
            ++this.soundCycle;
            if (this.soundCycle >= 3) {
                this.soundCycle = 0;
            }
            this.tank.drain(this.pistonCount * 5, true);
            this.needsUpdate = true;
            this.power = (long)((double)this.power + (double)this.getHEFromFuel() * Math.pow(this.pistonCount, 1.15));
            if (this.power > this.powerCap) {
                this.power = this.powerCap;
            }
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        return this.tank != null && this.isValidFluidForTank(tank, FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
    }

    private boolean isValidFluidForTank(int tank, FluidStack stack) {
        if (stack == null || this.tank == null) {
            return false;
        }
        Fluid f = stack.getFluid();
        return this.tank.getFluid() != null ? f == this.tank.getFluid().getFluid() : f == ModForgeFluids.smear || f == ModForgeFluids.heatingoil || f == ModForgeFluids.diesel || f == ModForgeFluids.kerosene || f == ModForgeFluids.reclaimed || f == ModForgeFluids.petroil || f == ModForgeFluids.biofuel || f == ModForgeFluids.nitan;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluidForTank(-1, resource)) {
            this.needsUpdate = true;
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 250000L;
    }
}

