/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.missile.EntityMinerRocket;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemSatChip;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.saveddata.satellites.SatelliteHorizons;
import com.hbm.saveddata.satellites.SatelliteMiner;
import com.hbm.saveddata.satellites.SatelliteSavedData;
import com.hbm.util.WeightedRandomObject;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineSatDock
extends TileEntity
implements ITickable {
    public ItemStackHandler inventory;
    private String customName;
    SatelliteSavedData data = null;
    private static Random rand = new Random();
    private WeightedRandomObject[] cargo = new WeightedRandomObject[]{new WeightedRandomObject(new ItemStack(ModItems.powder_aluminium, 3), 10), new WeightedRandomObject(new ItemStack(ModItems.powder_iron, 3), 10), new WeightedRandomObject(new ItemStack(ModItems.powder_titanium, 2), 8), new WeightedRandomObject(new ItemStack(ModItems.powder_coal, 4), 15), new WeightedRandomObject(new ItemStack(ModItems.powder_uranium, 2), 5), new WeightedRandomObject(new ItemStack(ModItems.powder_plutonium, 1), 5), new WeightedRandomObject(new ItemStack(ModItems.powder_thorium, 2), 7), new WeightedRandomObject(new ItemStack(ModItems.powder_desh_mix, 3), 5), new WeightedRandomObject(new ItemStack(ModItems.powder_diamond, 2), 7), new WeightedRandomObject(new ItemStack(Items.field_151137_ax, 5), 15), new WeightedRandomObject(new ItemStack(ModItems.powder_nitan_mix, 2), 5), new WeightedRandomObject(new ItemStack(ModItems.powder_power, 2), 5), new WeightedRandomObject(new ItemStack(ModItems.powder_copper, 5), 15), new WeightedRandomObject(new ItemStack(ModItems.powder_lead, 3), 10), new WeightedRandomObject(new ItemStack(ModItems.fluorite, 4), 15), new WeightedRandomObject(new ItemStack(ModItems.powder_lapis, 4), 10), new WeightedRandomObject(new ItemStack(ModItems.powder_combine_steel, 1), 1), new WeightedRandomObject(new ItemStack(ModItems.crystal_aluminium, 1), 5), new WeightedRandomObject(new ItemStack(ModItems.crystal_gold, 1), 5), new WeightedRandomObject(new ItemStack(ModItems.crystal_phosphorus, 1), 10), new WeightedRandomObject(new ItemStack(ModBlocks.gravel_diamond, 1), 3), new WeightedRandomObject(new ItemStack(ModItems.crystal_uranium, 1), 3), new WeightedRandomObject(new ItemStack(ModItems.crystal_plutonium, 1), 3), new WeightedRandomObject(new ItemStack(ModItems.crystal_trixite, 1), 1), new WeightedRandomObject(new ItemStack(ModItems.crystal_starmetal, 1), 1)};
    private WeightedRandomObject[] cargoGerald = new WeightedRandomObject[]{new WeightedRandomObject(new ItemStack(ModItems.powder_meteorite, 12), 128), new WeightedRandomObject(new ItemStack(ModItems.powder_plutonium, 4), 64), new WeightedRandomObject(new ItemStack(ModItems.powder_combine_steel, 6), 64), new WeightedRandomObject(new ItemStack(ModItems.powder_tektite, 8), 32), new WeightedRandomObject(new ItemStack(ModItems.powder_tantalium, 1), 16), new WeightedRandomObject(new ItemStack(ModItems.powder_schrabidium, 1), 8), new WeightedRandomObject(new ItemStack(ModItems.powder_bismuth, 1), 4), new WeightedRandomObject(new ItemStack(ModItems.powder_radspice, 1), 1)};

    public TileEntityMachineSatDock() {
        this.inventory = new ItemStackHandler(16){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityMachineSatDock.this.func_70296_d();
            }
        };
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.satDock";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.data == null) {
                this.data = (SatelliteSavedData)this.field_145850_b.getPerWorldStorage().func_75742_a(SatelliteSavedData.class, "satellites");
            }
            if (this.data == null) {
                this.field_145850_b.getPerWorldStorage().func_75745_a("satellites", (WorldSavedData)new SatelliteSavedData());
                this.data = (SatelliteSavedData)this.field_145850_b.getPerWorldStorage().func_75742_a(SatelliteSavedData.class, "satellites");
            }
            this.data.func_76185_a();
            if (this.data != null && !this.inventory.getStackInSlot(15).func_190926_b()) {
                EntityMinerRocket rocket;
                int freq = ItemSatChip.getFreq(this.inventory.getStackInSlot(15));
                Satellite sat = this.data.getSatFromFreq(freq);
                int delay = 600000;
                if (sat != null && sat instanceof SatelliteMiner) {
                    SatelliteMiner miner = (SatelliteMiner)sat;
                    if (miner.lastOp + (long)delay < System.currentTimeMillis()) {
                        rocket = new EntityMinerRocket(this.field_145850_b);
                        rocket.field_70165_t = (double)this.field_174879_c.func_177958_n() + 0.5;
                        rocket.field_70163_u = 300.0;
                        rocket.field_70161_v = (double)this.field_174879_c.func_177952_p() + 0.5;
                        this.field_145850_b.func_72838_d((Entity)rocket);
                        miner.lastOp = System.currentTimeMillis();
                        this.data.func_76185_a();
                    }
                }
                if (sat != null && sat instanceof SatelliteHorizons) {
                    SatelliteHorizons gerald = (SatelliteHorizons)sat;
                    if (gerald.lastOp + (long)delay < System.currentTimeMillis()) {
                        rocket = new EntityMinerRocket(this.field_145850_b, 1);
                        rocket.field_70165_t = (double)this.field_174879_c.func_177958_n() + 0.5;
                        rocket.field_70163_u = 300.0;
                        rocket.field_70161_v = (double)this.field_174879_c.func_177952_p() + 0.5;
                        rocket.setRocketType((byte)1);
                        this.field_145850_b.func_72838_d((Entity)rocket);
                        gerald.lastOp = System.currentTimeMillis();
                        this.data.func_76185_a();
                    }
                }
            }
            List list = this.field_145850_b.func_72839_b(null, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.25 + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() - 0.25 + 0.5, (double)this.field_174879_c.func_177958_n() + 0.25 + 0.5, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() + 0.25 + 0.5));
            for (Entity e : list) {
                EntityMinerRocket rocket;
                if (!(e instanceof EntityMinerRocket) || (Integer)(rocket = (EntityMinerRocket)e).func_184212_Q().func_187225_a(EntityMinerRocket.TIMER) != 1 || rocket.timer != 50) continue;
                byte type = rocket.getRocketType();
                if (type == 0) {
                    this.unloadCargo();
                    continue;
                }
                if (type != 1) continue;
                this.unloadGeraldCargo();
            }
            this.ejectInto(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            this.ejectInto(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            this.ejectInto(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2);
            this.ejectInto(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2);
        }
    }

    private void unloadCargo() {
        this.unloadTheCargo(this.cargo);
    }

    private void unloadGeraldCargo() {
        this.unloadTheCargo(this.cargoGerald);
    }

    private void unloadTheCargo(WeightedRandomObject[] cargo) {
        int items = rand.nextInt(6) + 10;
        rand = new Random();
        for (int i = 0; i < items; ++i) {
            ItemStack stack = ((WeightedRandomObject)WeightedRandom.func_76271_a((Random)rand, Arrays.asList(cargo))).asStack();
            this.addToInv(stack);
        }
    }

    private void addToInv(ItemStack stack) {
        int i;
        for (i = 0; i < 15; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b() || this.inventory.getStackInSlot(i).func_77973_b() != stack.func_77973_b() || this.inventory.getStackInSlot(i).func_77952_i() != stack.func_77952_i() || this.inventory.getStackInSlot(i).func_190916_E() >= this.inventory.getStackInSlot(i).func_77976_d()) continue;
            this.inventory.getStackInSlot(i).func_190917_f(1);
            return;
        }
        for (i = 0; i < 15; ++i) {
            if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
            this.inventory.setStackInSlot(i, new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i()));
            return;
        }
    }

    private void ejectInto(int x, int y, int z) {
        BlockPos eject = new BlockPos(x, y, z);
        TileEntity te = this.field_145850_b.func_175625_s(eject);
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler chest = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < 15; ++i) {
                ItemStack stack;
                for (int j = 0; j < chest.getSlots() && !(stack = this.inventory.getStackInSlot(i)).func_190926_b(); ++j) {
                    this.inventory.setStackInSlot(i, chest.insertItem(j, stack, false));
                }
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, facing));
    }
}

