/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.IDrillInteraction;
import api.hbm.block.IMiningDrill;
import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.gas.BlockGasBase;
import com.hbm.handler.MultiblockHandler;
import com.hbm.interfaces.Untested;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEDrillPacket;
import com.hbm.sound.SoundLoopMachine;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineMiningDrill
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
IMiningDrill {
    public long power;
    public int warning;
    public static final long maxPower = 100000L;
    int age = 0;
    int timer = 50;
    int radius = 100;
    int consumption = 100;
    int fortune = 0;
    boolean flag = true;
    public float torque;
    public float rotation;
    SoundLoopMachine sound;
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{2, 0};
    private static final int[] slots_side = new int[]{0};
    Random rand = new Random();

    public TileEntityMachineMiningDrill() {
        super(13);
    }

    @Override
    public String getName() {
        return "container.miningDrill";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 128.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        return super.func_189515_b(compound);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int p_94128_1_ = e.ordinal();
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    @Untested
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity capte;
            int i;
            this.updateConnections();
            this.consumption = 100;
            this.timer = 50;
            this.radius = 1;
            this.fortune = 0;
            for (i = 10; i < 13; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack == null) continue;
                if (stack.func_77973_b() == ModItems.upgrade_effect_1) {
                    ++this.radius;
                    this.consumption += 80;
                }
                if (stack.func_77973_b() == ModItems.upgrade_effect_2) {
                    this.radius += 2;
                    this.consumption += 160;
                }
                if (stack.func_77973_b() == ModItems.upgrade_effect_3) {
                    this.radius += 3;
                    this.consumption += 240;
                }
                if (stack.func_77973_b() == ModItems.upgrade_speed_1) {
                    this.timer -= 15;
                    this.consumption += 300;
                }
                if (stack.func_77973_b() == ModItems.upgrade_speed_2) {
                    this.timer -= 30;
                    this.consumption += 600;
                }
                if (stack.func_77973_b() == ModItems.upgrade_speed_3) {
                    this.timer -= 45;
                    this.consumption += 900;
                }
                if (stack.func_77973_b() == ModItems.upgrade_power_1) {
                    this.consumption -= 30;
                    this.timer += 5;
                }
                if (stack.func_77973_b() == ModItems.upgrade_power_2) {
                    this.consumption -= 60;
                    this.timer += 10;
                }
                if (stack.func_77973_b() == ModItems.upgrade_power_3) {
                    this.consumption -= 90;
                    this.timer += 15;
                }
                if (stack.func_77973_b() == ModItems.upgrade_fortune_1) {
                    ++this.fortune;
                    this.timer += 15;
                }
                if (stack.func_77973_b() == ModItems.upgrade_fortune_2) {
                    this.fortune += 2;
                    this.timer += 30;
                }
                if (stack.func_77973_b() != ModItems.upgrade_fortune_3) continue;
                this.fortune += 3;
                this.timer += 45;
            }
            if (this.timer < 5) {
                this.timer = 5;
            }
            if (this.consumption < 40) {
                this.consumption = 40;
            }
            if (this.radius > 4) {
                this.radius = 4;
            }
            if (this.fortune > 3) {
                this.fortune = 3;
            }
            ++this.age;
            if (this.age >= this.timer) {
                this.age -= this.timer;
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 100000L);
            if (this.power >= (long)this.consumption) {
                if (this.age == this.timer - 1) {
                    this.warning = 0;
                    for (i = this.field_174879_c.func_177956_o() - 1; i > this.field_174879_c.func_177956_o() - 1 - 100; --i) {
                        if (i <= 5) {
                            this.warning = 2;
                            break;
                        }
                        IBlockState ibs = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p()));
                        IBlockState ibs1 = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), i - 1, this.field_174879_c.func_177952_p()));
                        Block b = ibs.func_177230_c();
                        Block b1 = ibs1.func_177230_c();
                        ItemStack stack = new ItemStack(b.func_180660_a(ibs, this.rand, this.fortune), b.quantityDropped(ibs, this.fortune, this.rand), b.func_180651_a(ibs));
                        ItemStack stack1 = new ItemStack(b1.func_180660_a(ibs1, this.rand, this.fortune), b1.quantityDropped(ibs1, this.fortune, this.rand), b1.func_180651_a(ibs1));
                        if (i == this.field_174879_c.func_177956_o() - 1 && this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p())).func_177230_c() != ModBlocks.drill_pipe) {
                            if (this.isOreo(new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p())) && this.hasSpace(stack)) {
                                this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p()), ModBlocks.drill_pipe.func_176223_P());
                                break;
                            }
                            this.warning = 1;
                            break;
                        }
                        if (b1 == ModBlocks.drill_pipe) continue;
                        boolean bl = this.flag = i != this.field_174879_c.func_177956_o() - 1;
                        if (this.drill(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p(), this.radius)) break;
                        if (this.isOreo(new BlockPos(this.field_174879_c.func_177958_n(), i - 1, this.field_174879_c.func_177952_p())) && this.hasSpace(stack1)) {
                            this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), i - 1, this.field_174879_c.func_177952_p()), ModBlocks.drill_pipe.func_176223_P());
                            break;
                        }
                        this.warning = 1;
                        break;
                    }
                }
                this.power -= (long)this.consumption;
            } else {
                this.warning = 1;
            }
            int meta = this.func_145832_p();
            TileEntity te = null;
            if (meta == 2) {
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, 0, 0));
            }
            if (meta == 3) {
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, 0, 0));
            }
            if (meta == 4) {
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 2));
            }
            if (meta == 5) {
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -2));
            }
            if (te != null && te instanceof ICapabilityProvider && (capte = te).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e())) {
                IItemHandler cap = (IItemHandler)capte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e());
                for (int i2 = 1; i2 < 10 && !this.tryFillContainerCap(cap, i2); ++i2) {
                }
            }
            if (this.warning == 0) {
                this.torque = (float)((double)this.torque + 0.1);
                if (this.torque > (float)(100 / this.timer)) {
                    this.torque = 100 / this.timer;
                }
            } else {
                this.torque -= 0.1f;
                if (this.torque < (float)(-(100 / this.timer))) {
                    this.torque = -(100 / this.timer);
                }
            }
            if (this.torque < 0.0f) {
                this.torque = 0.0f;
            }
            this.rotation += this.torque;
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEDrillPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.rotation, this.torque), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new LoopedSoundPacket(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        }
    }

    private void updateConnections() {
        int meta = this.func_145832_p();
        if (meta == 5 || meta == 4) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 0), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 0), Library.NEG_X);
        } else if (meta == 3 || meta == 2) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 2), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -2), Library.NEG_Z);
        }
    }

    public boolean tryFillContainerCap(IItemHandler inv, int slot) {
        int i;
        int size = inv.getSlots();
        for (i = 0; i < size; ++i) {
            if (inv.getStackInSlot(i) == null) continue;
            if (this.inventory.getStackInSlot(slot).func_77973_b() == Items.field_190931_a) {
                return false;
            }
            ItemStack sta1 = inv.getStackInSlot(i).func_77946_l();
            ItemStack sta2 = this.inventory.getStackInSlot(slot).func_77946_l();
            if (sta1 == null || sta2 == null) continue;
            sta1.func_190920_e(1);
            sta2.func_190920_e(1);
            if (!ItemStack.func_77989_b((ItemStack)sta1, (ItemStack)sta2) || !ItemStack.func_77970_a((ItemStack)sta1, (ItemStack)sta2) || inv.getStackInSlot(i).func_190916_E() >= inv.getStackInSlot(i).func_77976_d()) continue;
            this.inventory.getStackInSlot(slot).func_190918_g(1);
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            ItemStack sta3 = inv.getStackInSlot(i).func_77946_l();
            sta3.func_190920_e(1);
            inv.insertItem(i, sta3, false);
            return true;
        }
        for (i = 0; i < size; ++i) {
            if (this.inventory.getStackInSlot(slot).func_77973_b() == Items.field_190931_a) {
                return false;
            }
            ItemStack sta2 = this.inventory.getStackInSlot(slot).func_77946_l();
            if (inv.getStackInSlot(i).func_77973_b() != Items.field_190931_a || sta2 == null) continue;
            sta2.func_190920_e(1);
            this.inventory.getStackInSlot(slot).func_190918_g(1);
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            inv.insertItem(i, sta2, false);
            return true;
        }
        return false;
    }

    public boolean isOreo(BlockPos pos) {
        IBlockState b = this.field_145850_b.func_180495_p(pos);
        float hardness = b.func_185887_b(this.field_145850_b, pos);
        if (b.func_177230_c() instanceof BlockGasBase) {
            return false;
        }
        return hardness < 70.0f && hardness >= 0.0f || b.func_185904_a().func_76224_d();
    }

    public boolean isMinableOreo(BlockPos pos) {
        IBlockState b = this.field_145850_b.func_180495_p(pos);
        float hardness = b.func_185887_b(this.field_145850_b, pos);
        if (b.func_177230_c() instanceof BlockGasBase) {
            return false;
        }
        return hardness < 70.0f && hardness >= 0.0f || b instanceof IDrillInteraction;
    }

    public boolean drill(int x, int y, int z, int rad) {
        if (!this.flag) {
            return false;
        }
        for (int ix = x - rad; ix <= x + rad; ++ix) {
            for (int iz = z - rad; iz <= z + rad; ++iz) {
                if (ix == x && iz == z || !this.tryDrill(ix, y, iz)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean drill2(int x, int y, int z) {
        if (!this.flag) {
            return false;
        }
        return this.tryDrill(x + 1, y, z) || this.tryDrill(x + 1, y, z + 1) || this.tryDrill(x, y, z + 1) || this.tryDrill(x - 1, y, z + 1) || this.tryDrill(x - 1, y, z) || this.tryDrill(x - 1, y, z - 1) || this.tryDrill(x, y, z - 1) || this.tryDrill(x + 1, y, z - 1) || this.tryDrill(x + 2, y, z) || this.tryDrill(x + 2, y, z + 1) || this.tryDrill(x + 1, y, z + 2) || this.tryDrill(x, y, z + 2) || this.tryDrill(x - 1, y, z + 2) || this.tryDrill(x - 2, y, z + 1) || this.tryDrill(x - 2, y, z) || this.tryDrill(x - 2, y, z - 1) || this.tryDrill(x - 1, y, z - 2) || this.tryDrill(x, y, z - 2) || this.tryDrill(x + 1, y, z - 2) || this.tryDrill(x + 2, y, z - 1) || this.tryDrill(x, y - 1, z);
    }

    public boolean drill3(int x, int y, int z) {
        if (!this.flag) {
            return false;
        }
        return this.tryDrill(x + 1, y, z) || this.tryDrill(x + 1, y, z + 1) || this.tryDrill(x, y, z + 1) || this.tryDrill(x - 1, y, z + 1) || this.tryDrill(x - 1, y, z) || this.tryDrill(x - 1, y, z - 1) || this.tryDrill(x, y, z - 1) || this.tryDrill(x + 1, y, z - 1) || this.tryDrill(x + 2, y, z) || this.tryDrill(x + 2, y, z + 1) || this.tryDrill(x + 1, y, z + 2) || this.tryDrill(x, y, z + 2) || this.tryDrill(x - 1, y, z + 2) || this.tryDrill(x - 2, y, z + 1) || this.tryDrill(x - 2, y, z) || this.tryDrill(x - 2, y, z - 1) || this.tryDrill(x - 1, y, z - 2) || this.tryDrill(x, y, z - 2) || this.tryDrill(x + 1, y, z - 2) || this.tryDrill(x + 2, y, z - 1) || this.tryDrill(x + 3, y, z) || this.tryDrill(x + 3, y, z + 1) || this.tryDrill(x + 2, y, z + 2) || this.tryDrill(x + 1, y, z + 3) || this.tryDrill(x, y, z + 3) || this.tryDrill(x - 1, y, z + 3) || this.tryDrill(x - 2, y, z + 2) || this.tryDrill(x - 3, y, z + 1) || this.tryDrill(x - 3, y, z) || this.tryDrill(x - 3, y, z - 1) || this.tryDrill(x - 2, y, z - 2) || this.tryDrill(x - 1, y, z - 3) || this.tryDrill(x, y, z - 3) || this.tryDrill(x + 1, y, z - 3) || this.tryDrill(x + 2, y, z - 2) || this.tryDrill(x + 3, y, z - 1) || this.tryDrill(x, y - 1, z);
    }

    public boolean drill4(int x, int y, int z) {
        if (!this.flag) {
            return false;
        }
        return this.tryDrill(x + 1, y, z) || this.tryDrill(x + 1, y, z + 1) || this.tryDrill(x, y, z + 1) || this.tryDrill(x - 1, y, z + 1) || this.tryDrill(x - 1, y, z) || this.tryDrill(x - 1, y, z - 1) || this.tryDrill(x, y, z - 1) || this.tryDrill(x + 1, y, z - 1) || this.tryDrill(x + 2, y, z) || this.tryDrill(x + 2, y, z + 1) || this.tryDrill(x + 1, y, z + 2) || this.tryDrill(x, y, z + 2) || this.tryDrill(x - 1, y, z + 2) || this.tryDrill(x - 2, y, z + 1) || this.tryDrill(x - 2, y, z) || this.tryDrill(x - 2, y, z - 1) || this.tryDrill(x - 1, y, z - 2) || this.tryDrill(x, y, z - 2) || this.tryDrill(x + 1, y, z - 2) || this.tryDrill(x + 2, y, z - 1) || this.tryDrill(x + 3, y, z) || this.tryDrill(x + 3, y, z + 1) || this.tryDrill(x + 2, y, z + 2) || this.tryDrill(x + 1, y, z + 3) || this.tryDrill(x, y, z + 3) || this.tryDrill(x - 1, y, z + 3) || this.tryDrill(x - 2, y, z + 2) || this.tryDrill(x - 3, y, z + 1) || this.tryDrill(x - 3, y, z) || this.tryDrill(x - 3, y, z - 1) || this.tryDrill(x - 2, y, z - 2) || this.tryDrill(x - 1, y, z - 3) || this.tryDrill(x, y, z - 3) || this.tryDrill(x + 1, y, z - 3) || this.tryDrill(x + 2, y, z - 2) || this.tryDrill(x + 3, y, z - 1) || this.tryDrill(x + 4, y, z) || this.tryDrill(x + 4, y, z + 1) || this.tryDrill(x + 4, y, z + 2) || this.tryDrill(x + 3, y, z + 2) || this.tryDrill(x + 3, y, z + 3) || this.tryDrill(x + 2, y, z + 3) || this.tryDrill(x + 2, y, z + 4) || this.tryDrill(x + 1, y, z + 4) || this.tryDrill(x, y, z + 4) || this.tryDrill(x - 1, y, z + 4) || this.tryDrill(x - 2, y, z + 4) || this.tryDrill(x - 2, y, z + 3) || this.tryDrill(x - 3, y, z + 3) || this.tryDrill(x - 3, y, z + 2) || this.tryDrill(x - 4, y, z + 2) || this.tryDrill(x - 4, y, z + 1) || this.tryDrill(x - 4, y, z) || this.tryDrill(x - 4, y, z - 1) || this.tryDrill(x - 4, y, z - 2) || this.tryDrill(x - 3, y, z - 2) || this.tryDrill(x - 3, y, z - 3) || this.tryDrill(x - 2, y, z - 3) || this.tryDrill(x - 2, y, z - 4) || this.tryDrill(x - 1, y, z - 4) || this.tryDrill(x, y, z - 4) || this.tryDrill(x + 1, y, z - 4) || this.tryDrill(x + 2, y, z - 4) || this.tryDrill(x + 2, y, z - 3) || this.tryDrill(x + 3, y, z - 3) || this.tryDrill(x + 3, y, z - 2) || this.tryDrill(x + 4, y, z - 2) || this.tryDrill(x + 4, y, z - 1) || this.tryDrill(x, y - 1, z);
    }

    public boolean tryDrill(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (this.field_145850_b.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || !this.isMinableOreo(pos)) {
            return false;
        }
        if (this.field_145850_b.func_180495_p(pos).func_185904_a().func_76224_d()) {
            this.field_145850_b.func_175655_b(pos, false);
            return false;
        }
        IBlockState b = this.field_145850_b.func_180495_p(pos);
        ItemStack stack = new ItemStack(b.func_177230_c().func_180660_a(b, this.rand, this.fortune), b.func_177230_c().quantityDropped(b, this.fortune, this.rand), b.func_177230_c().func_180651_a(b));
        if (b.func_177230_c() instanceof IDrillInteraction) {
            IDrillInteraction in = (IDrillInteraction)b.func_177230_c();
            if (!in.canBreak(this.field_145850_b, x, y, z, b, this)) {
                return true;
            }
            ItemStack sta = in.extractResource(this.field_145850_b, x, y, z, b, this);
            if (sta != null && this.hasSpace(sta)) {
                this.addItemToInventory(sta);
            }
        }
        if (stack != null && stack.func_77973_b() == null) {
            this.field_145850_b.func_175655_b(pos, false);
            return true;
        }
        if (this.hasSpace(stack)) {
            this.addItemToInventory(stack);
            this.field_145850_b.func_175655_b(pos, false);
            return true;
        }
        return true;
    }

    public boolean hasSpace(ItemStack stack) {
        ItemStack st = stack.func_77946_l();
        if (st == null) {
            return true;
        }
        for (int i = 1; i < 10; ++i) {
            if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        st.func_190920_e(1);
        boolean flag = true;
        for (int i = 0; i < stack.func_190916_E(); ++i) {
            if (this.canAddItemToArray(st, this.inventory)) continue;
            flag = false;
        }
        return flag;
    }

    public void addItemToInventory(ItemStack stack) {
        ItemStack st = stack.func_77946_l();
        if (st == null) {
            return;
        }
        int size = st.func_190916_E();
        st.func_190920_e(1);
        for (int i = 0; i < size; ++i) {
            this.canAddItemToArray(st, this.inventory);
        }
    }

    public boolean canAddItemToArray(ItemStack stack, ItemStackHandler array) {
        int i;
        ItemStack st = stack.func_77946_l();
        if (stack == null || st == null) {
            return true;
        }
        for (i = 1; i < 10; ++i) {
            if (array.getStackInSlot(i).func_190926_b()) continue;
            ItemStack sta = array.getStackInSlot(i).func_77946_l();
            if (stack == null || st == null) {
                return true;
            }
            if (sta == null || sta.func_77973_b() != st.func_77973_b() || sta.func_190916_E() >= st.func_77976_d()) continue;
            array.getStackInSlot(i).func_190917_f(1);
            return true;
        }
        for (i = 1; i < 10; ++i) {
            if (!array.getStackInSlot(i).func_190926_b()) continue;
            array.setStackInSlot(i, stack.func_77946_l());
            return true;
        }
        return false;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, facing));
    }

    @Override
    public IMiningDrill.DrillType getDrillTier() {
        return IMiningDrill.DrillType.INDUSTRIAL;
    }

    @Override
    public int getDrillRating() {
        return 50;
    }
}

