/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyConnector;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.machine.TileEntityMachineBattery;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineFENSU
extends TileEntityMachineBattery {
    public EnumDyeColor color = EnumDyeColor.LIGHT_BLUE;
    public static final long maxTransfer = 10000000000000000L;
    public float prevRotation = 0.0f;
    public float rotation = 0.0f;

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            super.func_73660_a();
        } else {
            this.prevRotation = this.rotation;
            this.rotation += this.getSpeed();
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    @Override
    protected void transmitPower() {
        IEnergyConnector con;
        short mode = this.getRelevantMode();
        ForgeDirection dir = ForgeDirection.DOWN;
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
        if (te instanceof IEnergyConductor && (con = (IEnergyConductor)te).getPowerNet() != null && con.getPowerNet().isSubscribed(this)) {
            con.getPowerNet().unsubscribe(this);
        }
        if ((mode == 1 || mode == 2) && te instanceof IEnergyConnector) {
            con = (IEnergyConnector)te;
            long max = 10000000000000000L;
            long toTransfer = Math.min(max, this.power);
            long remainder = this.power - toTransfer;
            long oldPower = this.power = toTransfer;
            long transfer = this.power - con.transferPower(this.power);
            this.power = oldPower - transfer;
            this.power += remainder;
        }
        if (te instanceof IEnergyConductor && (con = (IEnergyConductor)te).getPowerNet() != null) {
            if (mode == 2 || mode == 3) {
                if (con.getPowerNet().isSubscribed(this)) {
                    con.getPowerNet().unsubscribe(this);
                }
            } else if (!con.getPowerNet().isSubscribed(this)) {
                con.getPowerNet().subscribe(this);
            }
        }
    }

    @Override
    public NBTTagCompound packNBT(long avg) {
        NBTTagCompound nbt = super.packNBT(avg);
        nbt.func_74774_a("color", (byte)this.color.func_176765_a());
        return nbt;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.powerDelta = nbt.func_74763_f("powerDelta");
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
        this.color = EnumDyeColor.func_176764_b((int)nbt.func_74771_c("color"));
        this.priority = IEnergyConnector.ConnectionPriority.values()[nbt.func_74771_c("priority")];
    }

    @Override
    public long getPowerRemainingScaled(long i) {
        double powerScaled = (double)this.power / (double)this.getMaxPower();
        return (long)((double)i * powerScaled);
    }

    @Override
    public long getTransferWeight() {
        return Math.min(super.getTransferWeight(), 10000000000000000L);
    }

    public float getSpeed() {
        return (float)Math.pow(Math.log((double)this.power * 0.75 + 1.0) * (double)0.05f, 5.0);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.color = EnumDyeColor.func_176764_b((int)compound.func_74771_c("color"));
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("color", (byte)this.color.func_176765_a());
        return super.func_189515_b(compound);
    }

    @Override
    public long getMaxPower() {
        return Long.MAX_VALUE;
    }
}

