/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.lib.Library;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineDiesel
extends TileEntityMachineBase
implements ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public int soundCycle = 0;
    public static final long maxPower = 50000L;
    public long powerCap = 50000L;
    public int age = 0;
    public FluidTank tank;
    public Fluid tankType = ModForgeFluids.diesel;
    public boolean needsUpdate;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 2};
    private static final int[] slots_side = new int[]{2};

    public TileEntityMachineDiesel() {
        super(3);
        this.tank = new FluidTank(16000);
    }

    @Override
    public String getName() {
        return "container.machineDiesel";
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        compound.func_74772_a("powerCap", this.powerCap);
        this.tank.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        this.powerCap = compound.func_74763_f("powerCap");
        this.tank.readFromNBT(compound);
        super.func_145839_a(compound);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int p_94128_1_ = e.ordinal();
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public long getPowerScaled(long i) {
        return this.power * i / this.powerCap;
    }

    public void func_73660_a() {
        if (this.tank.getFluid() != null) {
            this.tankType = this.tank.getFluid().getFluid();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.sendPower(this.field_145850_b, this.field_174879_c);
            if (this.inputValidForTank(-1, 0) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 0, 1)) {
                this.needsUpdate = true;
            }
            Fluid type = this.tank.getFluid() == null ? null : this.tank.getFluid().getFluid();
            this.powerCap = type != null && type == ModForgeFluids.nitan ? 500000L : 50000L;
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 2, this.power, this.powerCap);
            this.generate();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("power", (int)this.power);
            data.func_74768_a("powerCap", (int)this.powerCap);
            this.networkPack(data, 50);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74762_e("power");
        this.powerCap = data.func_74762_e("powerCap");
    }

    public boolean hasAcceptableFuel() {
        return this.getHEFromFuel() > 0;
    }

    public int getHEFromFuel() {
        Fluid type = this.tankType;
        if (type == null) {
            return 0;
        }
        if (type == ModForgeFluids.diesel) {
            return 500;
        }
        if (type == ModForgeFluids.petroil) {
            return 300;
        }
        if (type == ModForgeFluids.biofuel) {
            return 400;
        }
        if (type == ModForgeFluids.nitan) {
            return 5000;
        }
        return 0;
    }

    public void generate() {
        if (this.hasAcceptableFuel() && this.tank.getFluidAmount() > 0) {
            if (this.soundCycle == 0) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187619_bk, SoundCategory.BLOCKS, 0.5f, -100.0f);
            }
            ++this.soundCycle;
            if (this.soundCycle >= 5) {
                this.soundCycle = 0;
            }
            this.tank.drain(10, true);
            this.needsUpdate = true;
            this.power = this.power + (long)this.getHEFromFuel() <= this.powerCap ? (this.power += (long)this.getHEFromFuel()) : this.powerCap;
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        return !this.inventory.getStackInSlot(slot).func_190926_b() && this.isValidFluid(FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
    }

    private boolean isValidFluid(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.getFluid() == ModForgeFluids.diesel || stack.getFluid() == ModForgeFluids.nitan || stack.getFluid() == ModForgeFluids.petroil || stack.getFluid() == ModForgeFluids.biofuel;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluid(resource)) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }
}

