/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.google.common.base.Predicate;
import com.hbm.blocks.machine.MachineChemplant;
import com.hbm.forgefluid.FFUtils;
import com.hbm.handler.MultiblockHandler;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.ChemplantRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemChemistryTemplate;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxParticlePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEChemplantPacket;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMachineChemplant
extends TileEntityMachineBase
implements IEnergyUser,
ITankPacketAcceptor,
ITickable {
    public static final long maxPower = 2000000L;
    public long power;
    public int progress;
    public boolean needsProcess = true;
    public int maxProgress = 100;
    public boolean isProgressing;
    public boolean needsUpdate = false;
    public boolean needsTankTypeUpdate = false;
    public FluidTank[] tanks;
    public Fluid[] tankTypes;
    public ItemStack previousTemplate = ItemStack.field_190927_a;
    public ItemStack previousTemplate2 = ItemStack.field_190927_a;
    int consumption = 100;
    int speed = 100;
    private long detectPower;
    private boolean detectIsProgressing;
    private FluidTank[] detectTanks = new FluidTank[]{null, null, null, null};

    public TileEntityMachineChemplant() {
        super(21);
        this.inventory = new ItemStackHandler(21){

            protected void onContentsChanged(int slot) {
                TileEntityMachineChemplant.this.func_70296_d();
                TileEntityMachineChemplant.this.OnContentsChanged(slot);
                super.onContentsChanged(slot);
            }
        };
        this.tanks = new FluidTank[4];
        this.tanks[0] = new FluidTank(24000);
        this.tanks[1] = new FluidTank(24000);
        this.tanks[2] = new FluidTank(24000);
        this.tanks[3] = new FluidTank(24000);
        this.tankTypes = new Fluid[]{null, null, null, null};
    }

    public void OnContentsChanged(int slot) {
        this.needsProcess = true;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_174831_c(this.field_174879_c) <= 128.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("powerTime");
        this.detectPower = this.power + 1L;
        this.isProgressing = nbt.func_74767_n("progressing");
        this.detectIsProgressing = !this.isProgressing;
        this.tanks[0].readFromNBT(nbt.func_74775_l("input1"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("input2"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("output1"));
        this.tanks[3].readFromNBT(nbt.func_74775_l("output2"));
        String[] types = new String[]{nbt.func_74779_i("tankType0"), nbt.func_74779_i("tankType1"), nbt.func_74779_i("tankType2"), nbt.func_74779_i("tankType3")};
        this.tankTypes[0] = !types[0].equals("empty") ? FluidRegistry.getFluid((String)types[0]) : null;
        this.tankTypes[1] = !types[1].equals("empty") ? FluidRegistry.getFluid((String)types[1]) : null;
        this.tankTypes[2] = !types[2].equals("empty") ? FluidRegistry.getFluid((String)types[2]) : null;
        this.tankTypes[3] = !types[3].equals("empty") ? FluidRegistry.getFluid((String)types[3]) : null;
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("inventory"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        String[] types = new String[]{this.tankTypes[0] != null ? this.tankTypes[0].getName() : "empty", this.tankTypes[1] != null ? this.tankTypes[1].getName() : "empty", this.tankTypes[2] != null ? this.tankTypes[2].getName() : "empty", this.tankTypes[3] != null ? this.tankTypes[3].getName() : "empty"};
        nbt.func_74757_a("progressing", this.isProgressing);
        NBTTagCompound input1 = new NBTTagCompound();
        NBTTagCompound input2 = new NBTTagCompound();
        NBTTagCompound output1 = new NBTTagCompound();
        NBTTagCompound output2 = new NBTTagCompound();
        this.tanks[0].writeToNBT(input1);
        this.tanks[1].writeToNBT(input2);
        this.tanks[2].writeToNBT(output1);
        this.tanks[3].writeToNBT(output2);
        nbt.func_74782_a("input1", (NBTBase)input1);
        nbt.func_74782_a("input2", (NBTBase)input2);
        nbt.func_74782_a("output1", (NBTBase)output1);
        nbt.func_74782_a("output2", (NBTBase)output2);
        nbt.func_74778_a("tankType0", types[0] != null ? types[0] : "empty");
        nbt.func_74778_a("tankType1", types[1] != null ? types[1] : "empty");
        nbt.func_74778_a("tankType2", types[2] != null ? types[2] : "empty");
        nbt.func_74778_a("tankType3", types[3] != null ? types[3] : "empty");
        NBTTagCompound inv = this.inventory.serializeNBT();
        nbt.func_74782_a("inventory", (NBTBase)inv);
        return nbt;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 2000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / Math.max(10, this.maxProgress);
    }

    public void func_73660_a() {
        this.needsTankTypeUpdate = this.previousTemplate2 != this.inventory.getStackInSlot(4);
        this.previousTemplate2 = this.inventory.getStackInSlot(4);
        this.consumption = 100;
        this.speed = 100;
        double c = 100.0;
        double s = 100.0;
        for (int i = 1; i < 4; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ModItems.upgrade_speed_1) {
                s *= 0.75;
                c *= 3.0;
            }
            if (stack.func_77973_b() == ModItems.upgrade_speed_2) {
                s *= 0.65;
                c *= 6.0;
            }
            if (stack.func_77973_b() == ModItems.upgrade_speed_3) {
                s *= 0.5;
                c *= 9.0;
            }
            if (stack.func_77973_b() == ModItems.upgrade_power_1) {
                c *= 0.8;
                s *= 1.25;
            }
            if (stack.func_77973_b() == ModItems.upgrade_power_2) {
                c *= 0.4;
                s *= 1.5;
            }
            if (stack.func_77973_b() != ModItems.upgrade_power_3) continue;
            c *= 0.2;
            s *= 2.0;
        }
        this.speed = (int)s;
        this.consumption = (int)c;
        if (this.speed < 2) {
            this.speed = 2;
        }
        if (this.consumption < 1) {
            this.consumption = 1;
        }
        if (this.needsTankTypeUpdate) {
            this.setContainers();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            int meta = (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)MachineChemplant.FACING);
            this.isProgressing = false;
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.fillFluidInit(this.tanks[2]);
                this.fillFluidInit(this.tanks[3]);
            }
            this.updateConnections();
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 2000000L);
            if (this.inputValidForTank(0, 17)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 17, 19);
            }
            if (this.inputValidForTank(1, 18)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 18, 20);
            }
            if (this.tankTypes[0] == FluidRegistry.WATER && this.inventory.getStackInSlot(17).func_77973_b() == ModItems.inf_water || this.inventory.getStackInSlot(17).func_77973_b() == ModItems.fluid_barrel_infinite) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 17, 19);
            }
            if (this.tankTypes[1] == FluidRegistry.WATER && this.inventory.getStackInSlot(18).func_77973_b() == ModItems.inf_water || this.inventory.getStackInSlot(18).func_77973_b() == ModItems.fluid_barrel_infinite) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 18, 20);
            }
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[2], 9, 11);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[3], 10, 12);
            ItemStack[] itemOutputs = ChemplantRecipes.getChemOutputFromTempate(this.inventory.getStackInSlot(4));
            Object[] fluidOutputs = ChemplantRecipes.getFluidOutputFromTempate(this.inventory.getStackInSlot(4));
            if (this.needsProcess && (itemOutputs != null || !Library.isArrayEmpty(fluidOutputs))) {
                List<RecipesCommon.AStack> itemInputs = ChemplantRecipes.getChemInputFromTempate(this.inventory.getStackInSlot(4));
                FluidStack[] fluidInputs = ChemplantRecipes.getFluidInputFromTempate(this.inventory.getStackInSlot(4));
                int duration = ChemplantRecipes.getProcessTime(this.inventory.getStackInSlot(4));
                this.maxProgress = duration * this.speed / 100;
                if (this.removeItems(itemInputs, this.cloneItemStackProper((IItemHandlerModifiable)this.inventory)) && this.hasFluidsStored(fluidInputs)) {
                    if (this.power >= (long)this.consumption && this.hasSpaceForItems(itemOutputs) && this.hasSpaceForFluids((FluidStack[])fluidOutputs)) {
                        ++this.progress;
                        this.isProgressing = true;
                        if (this.progress >= this.maxProgress) {
                            this.progress = 0;
                            if (itemOutputs != null) {
                                this.addItems(itemOutputs);
                            }
                            if (fluidOutputs != null) {
                                this.addFluids((FluidStack[])fluidOutputs);
                            }
                            this.removeItems(itemInputs, (IItemHandlerModifiable)this.inventory);
                            this.removeFluids(fluidInputs);
                            if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.meteorite_sword_machined) {
                                this.inventory.setStackInSlot(0, new ItemStack(ModItems.meteorite_sword_treated));
                            }
                        }
                        this.power -= (long)this.consumption;
                    }
                } else {
                    this.progress = 0;
                    this.needsProcess = false;
                }
            } else {
                this.progress = 0;
            }
            TileEntity te1 = null;
            TileEntity te2 = null;
            if (meta == 2) {
                te1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, 0, 0));
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(3, 0, -1));
            }
            if (meta == 3) {
                te1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, 0, 0));
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-3, 0, 1));
            }
            if (meta == 4) {
                te1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 2));
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, -3));
            }
            if (meta == 5) {
                te1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -2));
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 3));
            }
            if (!this.isProgressing) {
                this.tryExchangeTemplates(te1, te2);
            }
            if (te1 != null && te1.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e())) {
                int[] outputSlots;
                IItemHandler cap = (IItemHandler)te1.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e());
                for (int i : outputSlots = new int[]{5, 6, 7, 8, 11, 12, 19, 20}) {
                    this.tryFillContainerCap(cap, i);
                }
            }
            if (te2 != null && te2.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e())) {
                int[] slots;
                IItemHandler cap = (IItemHandler)te2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e());
                if (te2 instanceof TileEntityMachineBase) {
                    slots = ((TileEntityMachineBase)te2).getAccessibleSlotsFromSide(MultiblockHandler.intToEnumFacing(meta).func_176746_e());
                    this.tryFillAssemblerCap(cap, slots, (TileEntityMachineBase)te2);
                } else {
                    slots = new int[cap.getSlots()];
                    for (int i = 0; i < slots.length; ++i) {
                        slots[i] = i;
                    }
                    this.tryFillAssemblerCap(cap, slots, null);
                }
            }
            if (this.isProgressing) {
                if (meta == 2) {
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket((double)this.field_174879_c.func_177958_n() + 0.375, this.field_174879_c.func_177956_o() + 3, (double)this.field_174879_c.func_177952_p() - 0.625, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.375, (double)(this.field_174879_c.func_177956_o() + 3), (double)this.field_174879_c.func_177952_p() - 0.625, 50.0));
                }
                if (meta == 3) {
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket((double)this.field_174879_c.func_177958_n() + 0.625, this.field_174879_c.func_177956_o() + 3, (double)this.field_174879_c.func_177952_p() + 1.625, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.625, (double)(this.field_174879_c.func_177956_o() + 3), (double)this.field_174879_c.func_177952_p() + 1.625, 50.0));
                }
                if (meta == 4) {
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket((double)this.field_174879_c.func_177958_n() - 0.625, this.field_174879_c.func_177956_o() + 3, (double)this.field_174879_c.func_177952_p() + 0.625, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() - 0.625, (double)(this.field_174879_c.func_177956_o() + 3), (double)this.field_174879_c.func_177952_p() + 0.625, 50.0));
                }
                if (meta == 5) {
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket((double)this.field_174879_c.func_177958_n() + 1.625, this.field_174879_c.func_177956_o() + 3, (double)this.field_174879_c.func_177952_p() + 0.375, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 1.625, (double)(this.field_174879_c.func_177956_o() + 3), (double)this.field_174879_c.func_177952_p() + 0.375, 50.0));
                }
            }
            this.detectAndSendChanges();
        }
    }

    public boolean tryExchangeTemplates(TileEntity te1, TileEntity te2) {
        boolean te1Valid = this.validateTe(te1);
        boolean te2Valid = this.validateTe(te2);
        if (te1Valid && te2Valid) {
            int i;
            IItemHandler iTe1 = (IItemHandler)te1.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            IItemHandler iTe2e = (IItemHandler)te2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (!(iTe2e instanceof IItemHandlerModifiable)) {
                return false;
            }
            IItemHandlerModifiable iTe2 = (IItemHandlerModifiable)iTe2e;
            boolean openSlot = false;
            boolean existingTemplate = false;
            boolean filledContainer = false;
            for (i = 0; i < iTe1.getSlots(); ++i) {
                if (iTe1.getStackInSlot(i) != null && iTe1.getStackInSlot(i) != ItemStack.field_190927_a) continue;
                openSlot = true;
            }
            if (this.inventory.getStackInSlot(4) != ItemStack.field_190927_a && this.inventory.getStackInSlot(4).func_77973_b() instanceof ItemChemistryTemplate) {
                existingTemplate = true;
            }
            for (i = 0; i < iTe2.getSlots(); ++i) {
                iTe2.getStackInSlot(i);
                if (iTe2.getStackInSlot(i) == ItemStack.field_190927_a || !(iTe2.getStackInSlot(i).func_77973_b() instanceof ItemChemistryTemplate)) continue;
                if (openSlot && existingTemplate) {
                    filledContainer = this.tryFillContainerCap(iTe1, 4);
                }
                if (!filledContainer && existingTemplate) continue;
                ItemStack copy = iTe2.getStackInSlot(i).func_77946_l();
                iTe2.setStackInSlot(i, ItemStack.field_190927_a);
                this.inventory.setStackInSlot(4, copy);
            }
        }
        return false;
    }

    private void updateConnections() {
        int meta = this.func_145832_p();
        if (meta == 5) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 0), Library.NEG_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 1), Library.NEG_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(3, 0, 0), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(3, 0, 1), Library.POS_X);
        } else if (meta == 3) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -2), Library.NEG_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, -2), Library.NEG_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 3), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, 3), Library.POS_Z);
        } else if (meta == 4) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 0), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -1), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-3, 0, 0), Library.NEG_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-3, 0, -1), Library.NEG_X);
        } else if (meta == 2) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 2), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, 2), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -3), Library.NEG_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, -3), Library.NEG_Z);
        }
    }

    private boolean validateTe(TileEntity te) {
        return te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    private void setContainers() {
        if (this.inventory.getStackInSlot(4) != ItemStack.field_190927_a && (this.inventory.getStackInSlot(4) == ItemStack.field_190927_a || this.inventory.getStackInSlot(4).func_77973_b() instanceof ItemChemistryTemplate)) {
            this.needsTankTypeUpdate = true;
            if (this.previousTemplate != ItemStack.field_190927_a && ItemStack.func_77989_b((ItemStack)this.previousTemplate, (ItemStack)this.inventory.getStackInSlot(4))) {
                this.needsTankTypeUpdate = false;
            }
            this.previousTemplate = this.inventory.getStackInSlot(4).func_77946_l();
            FluidStack[] fluidInputs = ChemplantRecipes.getFluidInputFromTempate(this.inventory.getStackInSlot(4));
            FluidStack[] fluidOutputs = ChemplantRecipes.getFluidOutputFromTempate(this.inventory.getStackInSlot(4));
            if (fluidInputs != null) {
                Fluid fluid = this.tankTypes[0] = fluidInputs[0] == null ? null : fluidInputs[0].getFluid();
                if (fluidInputs.length == 2) {
                    Fluid fluid2 = this.tankTypes[1] = fluidInputs[1] == null ? null : fluidInputs[1].getFluid();
                }
            }
            if (fluidOutputs != null) {
                Fluid fluid = this.tankTypes[2] = fluidOutputs[0] == null ? null : fluidOutputs[0].getFluid();
                if (fluidOutputs.length == 2) {
                    Fluid fluid3 = this.tankTypes[3] = fluidOutputs[1] == null ? null : fluidOutputs[1].getFluid();
                }
            }
            if (fluidInputs != null) {
                if (fluidInputs[0] != null && this.tanks[0].getFluid() == null || this.tanks[0].getFluid() != null && this.tanks[0].getFluid().getFluid() != this.tankTypes[0]) {
                    this.tanks[0].setFluid(null);
                    if (this.needsTankTypeUpdate) {
                        this.needsTankTypeUpdate = false;
                    }
                }
                if (fluidInputs.length == 2 && (fluidInputs[1] != null && this.tanks[1].getFluid() == null || this.tanks[1].getFluid() != null && this.tanks[1].getFluid().getFluid() != this.tankTypes[1])) {
                    this.tanks[1].setFluid(null);
                    if (this.needsTankTypeUpdate) {
                        this.needsTankTypeUpdate = false;
                    }
                }
            }
            if (fluidOutputs != null) {
                if (fluidOutputs[0] != null && this.tanks[2].getFluid() == null || this.tanks[2].getFluid() != null && this.tanks[2].getFluid().getFluid() != this.tankTypes[2]) {
                    this.tanks[2].setFluid(null);
                }
                if (fluidOutputs.length == 2 && (fluidOutputs[1] != null && this.tanks[3].getFluid() == null || this.tanks[3].getFluid() != null && this.tanks[3].getFluid().getFluid() != this.tankTypes[3])) {
                    this.tanks[3].setFluid(null);
                    if (this.needsTankTypeUpdate) {
                        this.needsTankTypeUpdate = false;
                    }
                }
            }
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        if (!this.inventory.getStackInSlot(slot).func_190926_b() && this.tankTypes[tank] != null) {
            return FFUtils.checkRestrictions(this.inventory.getStackInSlot(slot), (Predicate<FluidStack>)((Predicate)f -> f.getFluid() == this.tankTypes[tank]));
        }
        return false;
    }

    public boolean hasFluidsStored(FluidStack[] fluids) {
        if (Library.isArrayEmpty(fluids)) {
            return true;
        }
        return fluids.length == 2 ? !(fluids[0] != null && fluids[0].amount > this.tanks[0].getFluidAmount() || fluids[1] != null && fluids[1].amount > this.tanks[1].getFluidAmount()) : fluids[0] == null || fluids[0].amount <= this.tanks[0].getFluidAmount();
    }

    public boolean hasSpaceForFluids(FluidStack[] fluids) {
        if (Library.isArrayEmpty(fluids)) {
            return true;
        }
        return fluids.length == 2 ? (fluids[0] == null || this.tanks[2].fill(fluids[0], false) == fluids[0].amount) && (fluids[1] == null || fluids[1] != null && this.tanks[3].fill(fluids[1], false) == fluids[1].amount) : fluids[0] == null || this.tanks[2].fill(fluids[0], false) == fluids[0].amount;
    }

    public void removeFluids(FluidStack[] fluids) {
        if (Library.isArrayEmpty(fluids)) {
            return;
        }
        this.tanks[0].drain(fluids[0].amount, true);
        if (fluids.length == 2) {
            this.tanks[1].drain(fluids[1].amount, true);
        }
    }

    public boolean hasSpaceForItems(ItemStack[] stacks) {
        if (stacks == null) {
            return true;
        }
        if (stacks != null && Library.isArrayEmpty(stacks)) {
            return true;
        }
        for (int i = 0; i < stacks.length; ++i) {
            if (this.inventory.getStackInSlot(5 + i) == ItemStack.field_190927_a || Library.areItemStacksCompatible(stacks[i].func_77946_l(), this.inventory.getStackInSlot(5 + i).func_77946_l(), false) && this.inventory.getStackInSlot(5 + i).func_190916_E() + stacks[i].func_190916_E() <= this.inventory.getStackInSlot(5 + i).func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void addItems(ItemStack[] stacks) {
        if (stacks == null) {
            return;
        }
        if (stacks != null && Library.isArrayEmpty(stacks)) {
            return;
        }
        for (int i = 0; i < stacks.length; ++i) {
            if (this.inventory.getStackInSlot(5 + i) == ItemStack.field_190927_a) {
                this.inventory.setStackInSlot(5 + i, stacks[i].func_77946_l());
                continue;
            }
            this.inventory.getStackInSlot(5 + i).func_190920_e(this.inventory.getStackInSlot(5 + i).func_190916_E() + stacks[i].func_190916_E());
        }
    }

    public void addFluids(FluidStack[] stacks) {
        if (stacks != null) {
            this.tanks[2].fill(stacks[0], true);
            if (stacks.length == 2 && stacks[1] != null) {
                this.tanks[3].fill(stacks[1], true);
            }
        }
    }

    public IItemHandlerModifiable cloneItemStackProper(IItemHandlerModifiable array) {
        ItemStackHandler stack = new ItemStackHandler(array.getSlots());
        for (int i = 0; i < array.getSlots(); ++i) {
            if (array.getStackInSlot(i) != null) {
                stack.setStackInSlot(i, array.getStackInSlot(i).func_77946_l());
                continue;
            }
            stack.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return stack;
    }

    public boolean tryFillContainerCap(IItemHandler chest, int slot) {
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            return false;
        }
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack outputStack = this.inventory.getStackInSlot(slot).func_77946_l();
            if (outputStack.func_190926_b()) {
                return false;
            }
            ItemStack chestItem = chest.getStackInSlot(i).func_77946_l();
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d())) continue;
            this.inventory.getStackInSlot(slot).func_190918_g(1);
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            outputStack.func_190920_e(1);
            chest.insertItem(i, outputStack, false);
            return true;
        }
        return false;
    }

    private int getValidSlot(RecipesCommon.AStack nextIngredient) {
        int firstFreeSlot = -1;
        int stackCount = (int)Math.ceil((float)nextIngredient.count() / 64.0f);
        int stacksFound = 0;
        nextIngredient = nextIngredient.singulize();
        for (int k = 13; k < 17; ++k) {
            if (stacksFound < stackCount) {
                ItemStack assStack = this.inventory.getStackInSlot(k).func_77946_l();
                if (assStack.func_190926_b()) {
                    if (firstFreeSlot >= 13) continue;
                    firstFreeSlot = k;
                    continue;
                }
                assStack.func_190920_e(1);
                if (!nextIngredient.isApplicable(assStack)) continue;
                if (this.inventory.getStackInSlot(k).func_190916_E() < assStack.func_77976_d()) {
                    return k;
                }
                ++stacksFound;
                continue;
            }
            return -1;
        }
        if (firstFreeSlot < 13) {
            return -2;
        }
        return firstFreeSlot;
    }

    public boolean tryFillAssemblerCap(IItemHandler container, int[] allowedSlots, TileEntityMachineBase te) {
        if (allowedSlots.length < 1) {
            return false;
        }
        List<RecipesCommon.AStack> recipeIngredients = ChemplantRecipes.getChemInputFromTempate(this.inventory.getStackInSlot(4));
        if (recipeIngredients == null) {
            return false;
        }
        HashMap<Integer, ItemStack> itemStackMap = new HashMap<Integer, ItemStack>();
        for (int slot : allowedSlots) {
            container.getStackInSlot(slot);
            if (container.getStackInSlot(slot).func_190926_b()) continue;
            itemStackMap.put(slot, container.getStackInSlot(slot).func_77946_l());
        }
        if (itemStackMap.size() == 0) {
            return false;
        }
        block1: for (int ig = 0; ig < recipeIngredients.size(); ++ig) {
            RecipesCommon.AStack nextIngredient = recipeIngredients.get(ig).copy();
            int ingredientSlot = this.getValidSlot(nextIngredient);
            if (ingredientSlot < 13) continue;
            int possibleAmount = this.inventory.getStackInSlot(ingredientSlot).func_77976_d() - this.inventory.getStackInSlot(ingredientSlot).func_190916_E();
            if (possibleAmount == 0) {
                System.out.println("This should never happen method getValidSlot broke");
                continue;
            }
            for (Map.Entry set : itemStackMap.entrySet()) {
                ItemStack stack = (ItemStack)set.getValue();
                int slot = (Integer)set.getKey();
                ItemStack compareStack = stack.func_77946_l();
                compareStack.func_190920_e(1);
                if (!this.isItemAcceptable(nextIngredient.getStack(), compareStack)) continue;
                int foundCount = Math.min(stack.func_190916_E(), possibleAmount);
                if (te != null && !te.canExtractItem(slot, stack, foundCount)) continue;
                if (foundCount <= 0) continue block1;
                possibleAmount -= foundCount;
                container.extractItem(slot, foundCount, false);
                this.inventory.getStackInSlot(ingredientSlot);
                if (this.inventory.getStackInSlot(ingredientSlot).func_190926_b()) {
                    stack.func_190920_e(foundCount);
                    this.inventory.setStackInSlot(ingredientSlot, stack);
                } else {
                    this.inventory.getStackInSlot(ingredientSlot).func_190917_f(foundCount);
                }
                this.needsProcess = true;
            }
        }
        return true;
    }

    public boolean removeItems(List<RecipesCommon.AStack> stack, IItemHandlerModifiable array) {
        if (stack == null) {
            return true;
        }
        for (int i = 0; i < stack.size(); ++i) {
            for (int j = 0; j < stack.get(i).count(); ++j) {
                RecipesCommon.AStack sta = stack.get(i).copy();
                sta.setCount(1);
                if (this.canRemoveItemFromArray(sta, array)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRemoveItemFromArray(RecipesCommon.AStack stack, IItemHandlerModifiable array) {
        RecipesCommon.AStack st = stack.copy();
        for (int i = 6; i < 18; ++i) {
            if (array.getStackInSlot(i).func_77973_b() == Items.field_190931_a) continue;
            ItemStack sta = array.getStackInSlot(i).func_77946_l();
            sta.func_190920_e(1);
            if (!st.isApplicable(sta) || array.getStackInSlot(i).func_190916_E() <= 0) continue;
            array.getStackInSlot(i).func_190918_g(1);
            if (array.getStackInSlot(i).func_190926_b()) {
                array.setStackInSlot(i, ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public boolean isItemAcceptable(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null && stack2 != null && stack1.func_77973_b() != Items.field_190931_a && stack1.func_77973_b() != Items.field_190931_a) {
            if (Library.areItemStacksCompatible(stack1, stack2)) {
                return true;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1.length > 0 && ids2.length > 0) {
                for (int i = 0; i < ids1.length; ++i) {
                    for (int j = 0; j < ids2.length; ++j) {
                        if (ids1[i] != ids2[j]) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 2000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void fillFluidInit(FluidTank tank) {
        int meta = (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)MachineChemplant.FACING);
        BlockPos.MutableBlockPos fill = new BlockPos.MutableBlockPos();
        boolean update = this.needsUpdate;
        if (meta == 5) {
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), 2000) || update;
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1), 2000) || update;
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() + 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), 2000) || update;
            boolean bl = update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() + 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1), 2000) || update;
        }
        if (meta == 3) {
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2), 2000) || update;
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2), 2000) || update;
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 3), 2000) || update;
            boolean bl = update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 3), 2000) || update;
        }
        if (meta == 2) {
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2), 2000) || update;
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2), 2000) || update;
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 3), 2000) || update;
            boolean bl = update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 3), 2000) || update;
        }
        if (meta == 4) {
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), 2000) || update;
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1), 2000) || update;
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() - 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), 2000) || update;
            update = FFUtils.fillFluid(this, tank, this.field_145850_b, (BlockPos)fill.func_181079_c(this.field_174879_c.func_177958_n() - 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1), 2000) || update;
        }
        this.needsUpdate = update;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new ChemplantFluidHandler(this.tanks, this.tankTypes)) : super.getCapability(capability, facing));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 4) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
        this.tanks[2].readFromNBT(tags[2]);
        this.tanks[3].readFromNBT(tags[3]);
    }

    public void haveNeedProess() {
        this.needsProcess = true;
    }

    public ItemStack getStackInSlot(int i) {
        return this.inventory.getStackInSlot(i);
    }

    @Override
    public String getName() {
        return "container.chemplant";
    }

    private void detectAndSendChanges() {
        PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
        boolean mark = false;
        if (this.detectIsProgressing != this.isProgressing) {
            mark = true;
            this.detectIsProgressing = this.isProgressing;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEChemplantPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.isProgressing), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        if (!FFUtils.areTanksEqual(this.detectTanks[0], this.tanks[0])) {
            this.detectTanks[0] = FFUtils.copyTank(this.tanks[0]);
            mark = true;
            this.needsUpdate = true;
        }
        if (!FFUtils.areTanksEqual(this.detectTanks[1], this.tanks[1])) {
            this.detectTanks[1] = FFUtils.copyTank(this.tanks[1]);
            mark = true;
            this.needsUpdate = true;
        }
        if (!FFUtils.areTanksEqual(this.detectTanks[2], this.tanks[2])) {
            this.detectTanks[2] = FFUtils.copyTank(this.tanks[2]);
            mark = true;
            this.needsUpdate = true;
        }
        if (!FFUtils.areTanksEqual(this.detectTanks[3], this.tanks[3])) {
            this.detectTanks[3] = FFUtils.copyTank(this.tanks[3]);
            mark = true;
            this.needsUpdate = true;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tanks[0], this.tanks[1], this.tanks[2], this.tanks[3]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    private class ChemplantFluidHandler
    implements IFluidHandler {
        private FluidTank[] tanks;
        private Fluid[] tankTypes;

        public ChemplantFluidHandler(FluidTank[] tanks, Fluid[] tankTypes) {
            this.tanks = tanks;
            this.tankTypes = tankTypes;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0], this.tanks[3].getTankProperties()[0]};
        }

        public int fill(FluidStack resource, boolean doFill) {
            TileEntityMachineChemplant.this.needsProcess = true;
            if (resource == null) {
                return 0;
            }
            if (this.tankTypes[0] != null && resource.getFluid() == this.tankTypes[0]) {
                return this.tanks[0].fill(resource, doFill);
            }
            if (this.tankTypes[1] != null && resource.getFluid() == this.tankTypes[1]) {
                return this.tanks[1].fill(resource, doFill);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            if (resource.isFluidEqual(this.tanks[2].getFluid())) {
                return this.tanks[2].drain(resource.amount, doDrain);
            }
            if (resource.isFluidEqual(this.tanks[3].getFluid())) {
                return this.tanks[3].drain(resource.amount, doDrain);
            }
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.tanks[2].getFluid() != null) {
                return this.tanks[2].drain(maxDrain, doDrain);
            }
            if (this.tanks[3].getFluid() != null) {
                return this.tanks[3].drain(maxDrain, doDrain);
            }
            return null;
        }
    }
}

