/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerChemfac;
import com.hbm.inventory.gui.GUIChemfac;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.machine.TileEntityMachineChemplantBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityMachineChemfac
extends TileEntityMachineChemplantBase
implements IGUIProvider {
    float rotSpeed;
    public float rot;
    public float prevRot;
    public TileEntityMachineChemplantBase.TypedFluidTank water = new TileEntityMachineChemplantBase.TypedFluidTank(ModForgeFluids.coolant, new FluidTank(6400));
    public TileEntityMachineChemplantBase.TypedFluidTank steam = new TileEntityMachineChemplantBase.TypedFluidTank(ModForgeFluids.hotcoolant, new FluidTank(6400));
    private final UpgradeManager upgradeManager;
    List<Pair<BlockPos, ForgeDirection>> conPos;
    BlockPos[] inPos;
    BlockPos[] outPos;
    IFluidTankProperties[] properties;
    AxisAlignedBB bb = null;

    public TileEntityMachineChemfac() {
        super(77);
        this.inventory = new ItemStackHandler(77){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityMachineChemfac.this.func_70296_d();
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                super.setStackInSlot(slot, stack);
                if (!stack.func_190926_b() && slot >= 1 && slot <= 4 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
                    TileEntityMachineChemfac.this.field_145850_b.func_184148_a(null, (double)TileEntityMachineChemfac.this.field_174879_c.func_177958_n() + 0.5, (double)TileEntityMachineChemfac.this.field_174879_c.func_177956_o() + 0.5, (double)TileEntityMachineChemfac.this.field_174879_c.func_177952_p() + 0.5, HBMSoundHandler.upgradePlug, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        };
        this.upgradeManager = new UpgradeManager();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 60L == 0L) {
                this.updateConnections();
            }
            this.sendFluids();
            this.speed = 100;
            this.consumption = 100;
            this.upgradeManager.eval((IItemHandler)this.inventory, 1, 4);
            int speedLevel = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 6);
            int powerLevel = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            int overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.speed -= speedLevel * 15;
            this.consumption += speedLevel * 300;
            this.speed += powerLevel * 5;
            this.consumption -= powerLevel * 30;
            this.speed /= overLevel + 1;
            this.consumption *= overLevel + 1;
            if (this.speed <= 0) {
                this.speed = 1;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74783_a("progress", this.progress);
            data.func_74783_a("maxProgress", this.maxProgress);
            data.func_74757_a("isProgressing", this.isProgressing);
            data.func_74782_a("tanks", (NBTBase)this.serializeTanks());
            NBTTagCompound tankWater = new NBTTagCompound();
            this.water.writeToNBT(tankWater);
            data.func_74782_a("water", (NBTBase)tankWater);
            NBTTagCompound tankSteam = new NBTTagCompound();
            this.steam.writeToNBT(tankSteam);
            data.func_74782_a("steam", (NBTBase)tankSteam);
            PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            this.networkPack(data, 150);
        } else {
            float maxSpeed = 30.0f;
            if (this.isProgressing) {
                this.rotSpeed = (float)((double)this.rotSpeed + 0.1);
                if (this.rotSpeed > maxSpeed) {
                    this.rotSpeed = maxSpeed;
                }
                if (this.rotSpeed == maxSpeed && this.field_145850_b.func_82737_E() % 5L == 0L) {
                    ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getOpposite();
                    ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                    Random rand = this.field_145850_b.field_73012_v;
                    double x = (double)this.field_174879_c.func_177958_n() + 0.5 - (double)rot.offsetX * 0.5;
                    double y = this.field_174879_c.func_177956_o() + 3;
                    double z = (double)this.field_174879_c.func_177952_p() + 0.5 - (double)rot.offsetZ * 0.5;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.CLOUD, x + (double)dir.offsetX * 1.5 + rand.nextGaussian() * 0.2, y, z + (double)dir.offsetZ * 1.5 + rand.nextGaussian() * 0.2, 0.0, 0.15, 0.0, new int[0]);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.CLOUD, x + (double)dir.offsetX * -0.5 + rand.nextGaussian() * 0.2, y, z + (double)dir.offsetZ * -0.5 + rand.nextGaussian() * 0.2, 0.0, 0.15, 0.0, new int[0]);
                }
            } else {
                this.rotSpeed = (float)((double)this.rotSpeed - 0.1);
                if (this.rotSpeed < 0.0f) {
                    this.rotSpeed = 0.0f;
                }
            }
            this.prevRot = this.rot;
            this.rot += this.rotSpeed;
            if (this.rot >= 360.0f) {
                this.rot -= 360.0f;
                this.prevRot -= 360.0f;
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74759_k("progress");
        this.maxProgress = nbt.func_74759_k("maxProgress");
        this.isProgressing = nbt.func_74767_n("isProgressing");
        this.deserializeTanks(nbt.func_150295_c("tanks", 10));
        this.water.readFromNBT(nbt.func_74775_l("water"));
        this.steam.readFromNBT(nbt.func_74775_l("steam"));
    }

    private int getWaterRequired() {
        return 100 / this.speed;
    }

    @Override
    protected boolean canProcess(int index) {
        return super.canProcess(index) && this.water.tank.getFluidAmount() >= this.getWaterRequired() && this.steam.tank.getFluidAmount() + this.getWaterRequired() <= this.steam.tank.getCapacity();
    }

    @Override
    protected void process(int index) {
        super.process(index);
        this.water.tank.drain(this.getWaterRequired(), true);
        this.steam.tank.fill(new FluidStack(ModForgeFluids.hotcoolant, this.getWaterRequired()), true);
    }

    private void updateConnections() {
        for (Pair<BlockPos, ForgeDirection> pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, (BlockPos)pos.getLeft(), (ForgeDirection)((Object)pos.getRight()));
        }
    }

    private void sendFluids() {
        for (Pair<BlockPos, ForgeDirection> pos : this.getConPos()) {
            for (TileEntityMachineChemplantBase.TypedFluidTank tank : this.outTanks()) {
                if (tank.type == null || tank.tank.getFluidAmount() <= 0) continue;
                FFUtils.fillFluid(this, tank.tank, this.field_145850_b, (BlockPos)pos.getLeft(), tank.tank.getFluidAmount());
            }
        }
    }

    protected List<Pair<BlockPos, ForgeDirection>> getConPos() {
        if (this.conPos != null && !this.conPos.isEmpty()) {
            return this.conPos;
        }
        this.conPos = new ArrayList<Pair<BlockPos, ForgeDirection>>();
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        for (int i = 0; i < 6; ++i) {
            this.conPos.add((Pair<BlockPos, ForgeDirection>)Pair.of((Object)this.field_174879_c.func_177982_a(dir.offsetX * (3 - i) + rot.offsetX * 3, 4, dir.offsetZ * (3 - i) + rot.offsetZ * 3), (Object)((Object)Library.POS_Y)));
            this.conPos.add((Pair<BlockPos, ForgeDirection>)Pair.of((Object)this.field_174879_c.func_177982_a(dir.offsetX * (3 - i) - rot.offsetX * 2, 4, dir.offsetZ * (3 - i) - rot.offsetZ * 2), (Object)((Object)Library.POS_Y)));
            for (int j = 0; j < 2; ++j) {
                this.conPos.add((Pair<BlockPos, ForgeDirection>)Pair.of((Object)this.field_174879_c.func_177982_a(dir.offsetX * (3 - i) + rot.offsetX * 5, 1 + j, dir.offsetZ * (3 - i) + rot.offsetZ * 5), (Object)((Object)rot)));
                this.conPos.add((Pair<BlockPos, ForgeDirection>)Pair.of((Object)this.field_174879_c.func_177982_a(dir.offsetX * (3 - i) - rot.offsetX * 4, 1 + j, dir.offsetZ * (3 - i) - rot.offsetZ * 4), (Object)((Object)rot.getOpposite())));
            }
        }
        return this.conPos;
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    @Override
    public String getName() {
        return "container.machineChemFac";
    }

    @Override
    public int getRecipeCount() {
        return 8;
    }

    @Override
    public int getTankCapacity() {
        return 32000;
    }

    @Override
    public int getTemplateIndex(int index) {
        return 13 + index * 9;
    }

    @Override
    public int[] getSlotIndicesFromIndex(int index) {
        return new int[]{5 + index * 9, 8 + index * 9, 9 + index * 9, 12 + index * 9};
    }

    @Override
    public BlockPos[] getInputPositions() {
        if (this.inPos != null) {
            return this.inPos;
        }
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.inPos = new BlockPos[]{this.field_174879_c.func_177982_a(dir.offsetX * 4 - rot.offsetX * 1, 0, dir.offsetZ * 4 - rot.offsetZ * 1), this.field_174879_c.func_177982_a(-dir.offsetX * 5 + rot.offsetX * 2, 0, -dir.offsetZ * 5 + rot.offsetZ * 2), this.field_174879_c.func_177982_a(-dir.offsetX * 2 - rot.offsetX * 4, 0, -dir.offsetZ * 2 - rot.offsetZ * 4), this.field_174879_c.func_177982_a(dir.offsetX * 1 + rot.offsetX * 5, 0, dir.offsetZ * 1 + rot.offsetZ * 5)};
        return this.inPos;
    }

    @Override
    public BlockPos[] getOutputPositions() {
        if (this.outPos != null) {
            return this.outPos;
        }
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.outPos = new BlockPos[]{this.field_174879_c.func_177982_a(dir.offsetX * 4 + rot.offsetX * 2, 0, dir.offsetZ * 4 + rot.offsetZ * 2), this.field_174879_c.func_177982_a(-dir.offsetX * 5 - rot.offsetX * 1, 0, -dir.offsetZ * 5 - rot.offsetZ * 1), this.field_174879_c.func_177982_a(dir.offsetX * 1 - rot.offsetX * 4, 0, dir.offsetZ * 1 - rot.offsetZ * 4), this.field_174879_c.func_177982_a(-dir.offsetX * 2 + rot.offsetX * 5, 0, -dir.offsetZ * 2 + rot.offsetZ * 5)};
        return this.outPos;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.properties == null) {
            this.properties = new IFluidTankProperties[this.tanks.length + 2];
            for (int i = 0; i < this.tanks.length; ++i) {
                this.properties[i] = this.tanks[i].tank.getTankProperties()[0];
            }
            this.properties[this.tanks.length] = this.water.tank.getTankProperties()[0];
            this.properties[this.tanks.length + 1] = this.steam.tank.getTankProperties()[0];
        }
        return this.properties;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound tankWater = new NBTTagCompound();
        this.water.tank.writeToNBT(tankWater);
        nbt.func_74782_a("water", (NBTBase)tankWater);
        NBTTagCompound tankSteam = new NBTTagCompound();
        this.steam.tank.writeToNBT(tankSteam);
        nbt.func_74782_a("steam", (NBTBase)tankSteam);
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.water.tank.readFromNBT(nbt.func_74775_l("water"));
        this.steam.tank.readFromNBT(nbt.func_74775_l("steam"));
    }

    @Override
    protected List<TileEntityMachineChemplantBase.TypedFluidTank> inTanks() {
        List<TileEntityMachineChemplantBase.TypedFluidTank> inTanks = super.inTanks();
        inTanks.add(this.water);
        return inTanks;
    }

    @Override
    public List<TileEntityMachineChemplantBase.TypedFluidTank> outTanks() {
        List<TileEntityMachineChemplantBase.TypedFluidTank> outTanks = super.outTanks();
        outTanks.add(this.steam);
        return outTanks;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 5), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 5), (double)(this.field_174879_c.func_177958_n() + 5), (double)(this.field_174879_c.func_177956_o() + 4), (double)(this.field_174879_c.func_177952_p() + 5));
        }
        return this.bb;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerChemfac(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIChemfac(player.field_71071_by, this);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

