/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IEnergyUser;
import api.hbm.energy.IPowerNet;
import api.hbm.energy.PowerNet;
import com.hbm.blocks.machine.MachineBattery;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineBattery
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public long[] log = new long[20];
    public long power = 0L;
    public long powerDelta = 0L;
    public static final int mode_input = 0;
    public static final int mode_buffer = 1;
    public static final int mode_output = 2;
    public static final int mode_none = 3;
    public short redLow = 0;
    public short redHigh = (short)2;
    public IEnergyConnector.ConnectionPriority priority = IEnergyConnector.ConnectionPriority.NORMAL;
    public byte lastRedstone = 0;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 3};
    private static final int[] slots_side = new int[]{2};
    private String customName;
    private long bufferedMax = 0L;

    public TileEntityMachineBattery() {
        super(4);
    }

    public TileEntityMachineBattery(long power) {
        this();
    }

    @Override
    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.battery";
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
    }

    @Override
    public String getName() {
        return "container.battery";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public long getPowerRemainingScaled(long i) {
        return this.power * i / this.getMaxPower();
    }

    public byte getComparatorPower() {
        if (this.power == 0L) {
            return 0;
        }
        double frac = (double)this.power / (double)this.getMaxPower() * 15.0;
        return (byte)MathHelper.func_76125_a((int)((int)frac + 1), (int)0, (int)15);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74772_a("powerDelta", this.powerDelta);
        compound.func_74777_a("redLow", this.redLow);
        compound.func_74777_a("redHigh", this.redHigh);
        compound.func_74774_a("priority", (byte)this.priority.ordinal());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.powerDelta = compound.func_74763_f("powerDelta");
        this.redLow = compound.func_74765_d("redLow");
        this.redHigh = compound.func_74765_d("redHigh");
        this.priority = IEnergyConnector.ConnectionPriority.values()[compound.func_74771_c("priority")];
        super.func_145839_a(compound);
    }

    public void writeNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("power", this.power);
        data.func_74772_a("powerDelta", this.powerDelta);
        data.func_74777_a("redLow", this.redLow);
        data.func_74777_a("redHigh", this.redHigh);
        data.func_74774_a("priority", (byte)this.priority.ordinal());
        nbt.func_74782_a("NBT_PERSISTENT_KEY", (NBTBase)data);
    }

    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("NBT_PERSISTENT_KEY");
        this.power = data.func_74763_f("power");
        this.powerDelta = data.func_74763_f("powerDelta");
        this.redLow = data.func_74765_d("redLow");
        this.redHigh = data.func_74765_d("redHigh");
        this.priority = IEnergyConnector.ConnectionPriority.values()[data.func_74771_c("priority")];
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing p_94128_1_) {
        return p_94128_1_ == EnumFacing.DOWN ? slots_bottom : (p_94128_1_ == EnumFacing.UP ? slots_top : slots_side);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 0) {
            return stack.func_77973_b() instanceof IBatteryItem;
        }
        if (i == 2) {
            return stack.func_77973_b() instanceof IBatteryItem;
        }
        return true;
    }

    @Override
    public boolean canInsertItem(int i, ItemStack itemStack, int j) {
        return this.isItemValidForSlot(i, itemStack);
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return i == 1 || i == 3;
    }

    public void tryMoveItems() {
        IBatteryItem itemFill;
        ItemStack itemStackFill;
        IBatteryItem itemDrain;
        ItemStack itemStackDrain = this.inventory.getStackInSlot(0);
        if (itemStackDrain.func_77973_b() instanceof IBatteryItem && (itemDrain = (IBatteryItem)itemStackDrain.func_77973_b()).getCharge(itemStackDrain) == 0L && (this.inventory.getStackInSlot(1) == null || this.inventory.getStackInSlot(1).func_190926_b())) {
            this.inventory.setStackInSlot(1, itemStackDrain);
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
        if ((itemStackFill = this.inventory.getStackInSlot(2)).func_77973_b() instanceof IBatteryItem && (itemFill = (IBatteryItem)itemStackFill.func_77973_b()).getCharge(itemStackFill) == itemFill.getMaxCharge() && (this.inventory.getStackInSlot(3) == null || this.inventory.getStackInSlot(3).func_190926_b())) {
            this.inventory.setStackInSlot(3, itemStackFill);
            this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            long prevPower = this.power;
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, this.getMaxPower());
            this.transmitPowerFairly();
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 2, this.power, this.getMaxPower());
            byte comp = this.getComparatorPower();
            if (comp != this.lastRedstone) {
                this.func_70296_d();
            }
            this.lastRedstone = comp;
            this.tryMoveItems();
            long avg = (this.power >> 1) + (prevPower >> 1);
            this.powerDelta = avg - this.log[0];
            for (int i = 1; i < this.log.length; ++i) {
                this.log[i - 1] = this.log[i];
            }
            this.log[this.log.length - 1] = avg;
            this.networkPack(this.packNBT(avg), 20);
        }
    }

    public NBTTagCompound packNBT(long power) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("power", power);
        nbt.func_74772_a("powerDelta", this.powerDelta);
        nbt.func_74777_a("redLow", this.redLow);
        nbt.func_74777_a("redHigh", this.redHigh);
        nbt.func_74774_a("priority", (byte)this.priority.ordinal());
        return nbt;
    }

    protected void transmitPowerFairly() {
        short mode = this.getRelevantMode();
        HashSet<IPowerNet> nets = new HashSet<IPowerNet>();
        HashSet<IEnergyConnector> consumers = new HashSet<IEnergyConnector>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyConnector con;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
            if (te instanceof IEnergyConductor) {
                con = (IEnergyConductor)te;
                if (!con.canConnect(dir.getOpposite()) || con.getPowerNet() == null) continue;
                nets.add(con.getPowerNet());
                con.getPowerNet().unsubscribe(this);
                consumers.addAll(con.getPowerNet().getSubscribers());
                continue;
            }
            if (!(te instanceof IEnergyConnector) || !(con = (IEnergyConnector)te).canConnect(dir.getOpposite())) continue;
            consumers.add((IEnergyConnector)te);
        }
        if (this.power > 0L && (mode == 1 || mode == 2)) {
            ArrayList<IEnergyConnector> con = new ArrayList<IEnergyConnector>();
            con.addAll(consumers);
            this.power = PowerNet.fairTransfer(con, this.power);
        }
        if (mode == 1 || mode == 0) {
            nets.forEach(x -> x.subscribe(this));
        }
    }

    protected void transmitPower() {
        short mode = this.getRelevantMode();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyConnector con;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
            if (te instanceof IEnergyConductor && (con = (IEnergyConductor)te).getPowerNet() != null && con.getPowerNet().isSubscribed(this)) {
                con.getPowerNet().unsubscribe(this);
            }
            if ((mode == 1 || mode == 2) && te instanceof IEnergyConnector) {
                con = (IEnergyConnector)te;
                long oldPower = this.power;
                long transfer = this.power - con.transferPower(this.power);
                this.power = oldPower - transfer;
            }
            if (!(te instanceof IEnergyConductor) || (con = (IEnergyConductor)te).getPowerNet() == null) continue;
            if (mode == 2 || mode == 3) {
                if (!con.getPowerNet().isSubscribed(this)) continue;
                con.getPowerNet().unsubscribe(this);
                continue;
            }
            if (con.getPowerNet().isSubscribed(this)) continue;
            con.getPowerNet().subscribe(this);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.powerDelta = nbt.func_74763_f("powerDelta");
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
        this.priority = IEnergyConnector.ConnectionPriority.values()[nbt.func_74771_c("priority")];
    }

    public short getRelevantMode() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            return this.redHigh;
        }
        return this.redLow;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        if (this.bufferedMax == 0L) {
            this.bufferedMax = ((MachineBattery)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).getMaxPower();
        }
        return this.bufferedMax;
    }

    @Override
    public long transferPower(long powerInput) {
        short mode = this.getRelevantMode();
        if (mode == 2 || mode == 3) {
            return powerInput;
        }
        this.func_70296_d();
        long ownMaxPower = this.getMaxPower();
        if (powerInput > ownMaxPower - this.power) {
            long overshoot = powerInput - (ownMaxPower - this.power);
            this.power = ownMaxPower;
            return overshoot;
        }
        this.power += powerInput;
        return 0L;
    }

    @Override
    public long getTransferWeight() {
        short mode = this.getRelevantMode();
        if (mode == 2 || mode == 3) {
            return 0L;
        }
        return Math.max(this.getMaxPower() - this.getPower(), 0L);
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return true;
    }

    @Override
    public IEnergyConnector.ConnectionPriority getPriority() {
        return this.priority;
    }
}

