/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.ArmorUtil;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemKeyPin;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;

public class TileEntityLockableBase
extends TileEntity {
    protected int lock;
    private boolean isLocked = false;
    protected double lockMod = 0.1;

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean canLock(EntityPlayer player, EnumHand hand, EnumFacing facing) {
        return true;
    }

    public void lock() {
        if (this.lock == 0) {
            MainRegistry.logger.error("A block has been set to locked state before setting pins, this should not happen and may cause errors! " + ((Object)((Object)this)).toString());
        }
        if (!this.isLocked) {
            this.func_70296_d();
        }
        this.isLocked = true;
    }

    public void setPins(int pins) {
        if (this.lock != pins) {
            this.func_70296_d();
        }
        this.lock = pins;
    }

    public int getPins() {
        return this.lock;
    }

    public void setMod(double mod) {
        if (this.lockMod != mod) {
            this.func_70296_d();
        }
        this.lockMod = mod;
    }

    public double getMod() {
        return this.lockMod;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.lock = compound.func_74762_e("lock");
        this.isLocked = compound.func_74767_n("isLocked");
        this.lockMod = compound.func_74769_h("lockMod");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("lock", this.lock);
        compound.func_74757_a("isLocked", this.isLocked);
        compound.func_74780_a("lockMod", this.lockMod);
        return super.func_189515_b(compound);
    }

    public boolean canAccess(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemKeyPin && ItemKeyPin.getPins(stack) == this.lock) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.lockOpen, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (stack.func_77973_b() == ModItems.key_red) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.lockOpen, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return this.tryPick(player);
    }

    public boolean tryPick(EntityPlayer player) {
        boolean canPick = false;
        ItemStack stack = player.func_184614_ca();
        double chanceOfSuccess = this.lockMod * 100.0;
        if (stack != null && stack.func_77973_b() == ModItems.pin && Library.hasInventoryItem(player.field_71071_by, ModItems.screwdriver)) {
            stack.func_190918_g(1);
            canPick = true;
        }
        if (stack != null && stack.func_77973_b() == ModItems.screwdriver && Library.hasInventoryItem(player.field_71071_by, ModItems.pin)) {
            Library.consumeInventoryItem(player.field_71071_by, ModItems.pin);
            player.field_71069_bz.func_75142_b();
            canPick = true;
        }
        if (canPick) {
            double rand;
            if (ArmorUtil.checkArmorPiece(player, ModItems.jackt, 2) || ArmorUtil.checkArmorPiece(player, ModItems.jackt2, 2)) {
                chanceOfSuccess *= 100.0;
            }
            if (chanceOfSuccess > (rand = player.field_70170_p.field_73012_v.nextDouble() * 100.0)) {
                this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.pinUnlock, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.pinBreak, SoundCategory.BLOCKS, 1.0f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        }
        return false;
    }
}

