/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.HeatRecipes;
import com.hbm.inventory.container.ContainerHeaterHeatex;
import com.hbm.inventory.gui.GUIHeaterHeatex;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.lib.ForgeDirection;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.FluidTypePacketTest;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHeaterHeatex
extends TileEntityMachineBase
implements IHeatSource,
IControlReceiver,
IGUIProvider,
ITickable,
ITankPacketAcceptor,
IFluidHandler {
    public FluidTank[] tanks = new FluidTank[2];
    public Fluid[] tankTypes = new Fluid[2];
    public int amountToCool = 1;
    public int tickDelay = 1;
    public int heatGen;
    public int heatEnergy;
    AxisAlignedBB bb = null;

    public TileEntityHeaterHeatex() {
        super(1);
        this.tanks[0] = new FluidTank(ModForgeFluids.hotcoolant, 0, 24000);
        this.tankTypes[0] = ModForgeFluids.hotcoolant;
        this.tanks[1] = new FluidTank(ModForgeFluids.coolant, 0, 24000);
        this.tankTypes[1] = ModForgeFluids.coolant;
    }

    @Override
    public String getName() {
        return "container.heaterHeatex";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.setFluidType();
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tanks[0], this.tanks[1]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTypePacketTest(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.tankTypes), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            this.heatEnergy = (int)((double)this.heatEnergy * 0.999);
            this.tryConvert();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("heatGen", this.heatGen);
            data.func_74768_a("heatEnergy", this.heatEnergy);
            data.func_74768_a("toCool", this.amountToCool);
            data.func_74768_a("delay", this.tickDelay);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            INBTPacketReceiver.networkPack(this, data, 25);
            this.fillFluidInit(this.tanks[1]);
            this.func_70296_d();
        }
    }

    public void fillFluidInit(FluidTank tank) {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * 2 + rot.offsetX, 0, dir.offsetZ * 2 + rot.offsetZ), 12000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * 2 - rot.offsetX, 0, dir.offsetZ * 2 - rot.offsetZ), 12000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-dir.offsetX * 2 + rot.offsetX, 0, -dir.offsetZ * 2 + rot.offsetZ), 12000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-dir.offsetX * 2 - rot.offsetX, 0, -dir.offsetZ * 2 - rot.offsetZ), 12000);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.heatGen = nbt.func_74762_e("heatGen");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
        this.amountToCool = nbt.func_74762_e("toCool");
        this.tickDelay = nbt.func_74762_e("delay");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    public void setFluidType() {
        ItemStack inFluid = this.inventory.getStackInSlot(0);
        if (inFluid.func_77973_b() == ModItems.forge_fluid_identifier) {
            this.setFluidTypes(ItemForgeFluidIdentifier.getType(inFluid));
        }
        if (this.tankTypes[0] == null) {
            this.setFluidTypes(ModForgeFluids.hotcoolant);
        }
    }

    public void setFluidTypes(Fluid f) {
        if (HeatRecipes.hasCoolRecipe(f) && this.tankTypes[0] != f) {
            this.tankTypes[0] = f;
            this.tankTypes[1] = HeatRecipes.getCoolFluid(f);
            this.tanks[0].setFluid(new FluidStack(f, 0));
            this.tanks[1].setFluid(new FluidStack(this.tankTypes[1], 0));
            this.func_70296_d();
        }
    }

    protected void tryConvert() {
        if (this.tickDelay < 1) {
            this.tickDelay = 1;
        }
        if (this.field_145850_b.func_82737_E() % (long)this.tickDelay != 0L) {
            return;
        }
        if (!HeatRecipes.hasCoolRecipe(this.tankTypes[0])) {
            return;
        }
        int amountReq = HeatRecipes.getInputAmountCold(this.tankTypes[0]);
        int amountProduced = HeatRecipes.getOutputAmountCold(this.tankTypes[0]);
        int heat = HeatRecipes.getResultingHeat(this.tankTypes[0]);
        int inputOps = this.tanks[0].getFluidAmount() / amountReq;
        int outputOps = (this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount()) / amountProduced;
        int opCap = this.amountToCool;
        int ops = Math.min(inputOps, Math.min(outputOps, opCap));
        this.tanks[0].drain(ops * amountReq, true);
        this.tanks[1].fill(new FluidStack(this.tankTypes[1], ops * amountProduced), true);
        this.heatGen = heat * ops >> 1;
        this.heatEnergy += this.heatGen;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
        this.amountToCool = nbt.func_74762_e("toCool");
        this.tickDelay = nbt.func_74762_e("delay");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        if (nbt.func_74764_b("tankTypes0")) {
            this.tankTypes[0] = FluidRegistry.getFluid((String)nbt.func_74779_i("tankTypes0"));
        }
        if (nbt.func_74764_b("tankTypes1")) {
            this.tankTypes[1] = FluidRegistry.getFluid((String)nbt.func_74779_i("tankTypes1"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
        nbt.func_74768_a("toCool", this.amountToCool);
        nbt.func_74768_a("delay", this.tickDelay);
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        nbt.func_74778_a("tankTypes0", this.tankTypes[0].getName());
        nbt.func_74778_a("tankTypes1", this.tankTypes[1].getName());
        return super.func_189515_b(nbt);
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 2) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == this.tankTypes[0] && resource.amount > 0) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == this.tankTypes[1] && resource.amount > 0) {
            return this.tanks[1].drain(resource, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain > 0) {
            return this.tanks[1].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        ForgeDirection dir;
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == (dir = ForgeDirection.getOrientation(this.func_145832_p() - 10)).toEnumFacing().func_176734_d() || facing == dir.toEnumFacing() || facing == null)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        ForgeDirection dir;
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == (dir = ForgeDirection.getOrientation(this.func_145832_p() - 10)).toEnumFacing().func_176734_d() || facing == dir.toEnumFacing() || facing == null)) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerHeaterHeatex(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIHeaterHeatex(player.field_71071_by, this);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70011_f((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 16.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toCool")) {
            this.amountToCool = Math.max(data.func_74762_e("toCool"), 1);
        }
        if (data.func_74764_b("delay")) {
            this.tickDelay = Math.max(data.func_74762_e("delay"), 1);
        }
        this.func_70296_d();
    }
}

