/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityDeuteriumExtractor
extends TileEntityLoadedBase
implements ITickable,
IFluidHandler,
IEnergyUser,
ITankPacketAcceptor,
INBTPacketReceiver {
    public int age = 0;
    public long power = 0L;
    public FluidTank[] tanks = new FluidTank[2];

    public TileEntityDeuteriumExtractor() {
        this.tanks[0] = new FluidTank(FluidRegistry.WATER, 0, 1000);
        this.tanks[1] = new FluidTank(ModForgeFluids.heavywater, 0, 100);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[1]);
            }
            if (this.hasPower() && this.hasEnoughWater() && this.tanks[1].getCapacity() > this.tanks[1].getFluidAmount()) {
                int convert = Math.min(this.tanks[1].getCapacity(), this.tanks[0].getFluidAmount()) / 50;
                convert = Math.min(convert, this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount());
                this.tanks[0].drain(convert * 50, true);
                this.tanks[1].fill(new FluidStack(ModForgeFluids.heavywater, convert), true);
                this.power -= this.getMaxPower() / 20L;
                this.func_70296_d();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            INBTPacketReceiver.networkPack(this, data, 50);
        }
    }

    protected void updateConnections() {
        this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
    }

    public void fillFluidInit(FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177976_e(), 100);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177974_f(), 100);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177977_b(), 100);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177984_a(), 100);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177978_c(), 100);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177968_d(), 100);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        if (data.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(data.func_150295_c("tanks", 10), this.tanks);
        }
    }

    public boolean hasPower() {
        return this.power >= this.getMaxPower() / 20L;
    }

    public boolean hasEnoughWater() {
        return this.tanks[0].getFluidAmount() >= 100;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("power", this.power);
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(nbt);
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 2) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tanks[1].getFluid())) {
            return null;
        }
        return this.tanks[1].drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[1].drain(maxDrain, doDrain);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

