/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.entity.effect.EntityCloudFleijaRainbow;
import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.ArmorUtil;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.machine.ItemCatalyst;
import com.hbm.items.special.ItemAMSCore;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.TileEntityAMSEmitter;
import com.hbm.tileentity.machine.TileEntityAMSLimiter;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import scala.util.Random;

public class TileEntityAMSBase
extends TileEntity
implements ITickable,
IFluidHandler,
ITankPacketAcceptor {
    public ItemStackHandler inventory;
    public long power = 0L;
    public static final long maxPower = 1000000000000000L;
    public int field = 0;
    public static final int maxField = 100;
    public int efficiency = 0;
    public static final int maxEfficiency = 100;
    public int heat = 0;
    public static final int maxHeat = 5000;
    public int age = 0;
    public int warning = 0;
    public int mode = 0;
    public boolean locked = false;
    public FluidTank[] tanks;
    public Fluid[] tankTypes;
    public int color = -1;
    public boolean needsUpdate = false;
    Random rand = new Random();
    private String customName;

    public TileEntityAMSBase() {
        this.inventory = new ItemStackHandler(16){

            protected void onContentsChanged(int slot) {
                TileEntityAMSBase.this.func_70296_d();
                super.onContentsChanged(slot);
            }
        };
        this.tanks = new FluidTank[4];
        this.tankTypes = new Fluid[4];
        this.tanks[0] = new FluidTank(8000);
        this.tankTypes[0] = ModForgeFluids.coolant;
        this.tanks[1] = new FluidTank(8000);
        this.tankTypes[1] = ModForgeFluids.cryogel;
        this.tanks[2] = new FluidTank(8000);
        this.tankTypes[2] = ModForgeFluids.deuterium;
        this.tanks[3] = new FluidTank(8000);
        this.tankTypes[3] = ModForgeFluids.tritium;
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.amsBase";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 128.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.field = compound.func_74762_e("field");
        this.efficiency = compound.func_74762_e("efficiency");
        this.heat = compound.func_74762_e("heat");
        this.locked = compound.func_74767_n("locked");
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        this.tankTypes[0] = ModForgeFluids.coolant;
        this.tankTypes[1] = ModForgeFluids.cryogel;
        this.tankTypes[2] = ModForgeFluids.deuterium;
        this.tankTypes[3] = ModForgeFluids.tritium;
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74768_a("field", this.field);
        compound.func_74768_a("efficiency", this.efficiency);
        compound.func_74768_a("heat", this.heat);
        compound.func_74757_a("locked", this.locked);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            for (int i = 0; i < this.tanks.length; ++i) {
                this.tanks[i].fill(new FluidStack(this.tankTypes[i], this.tanks[i].getCapacity()), true);
                this.needsUpdate = true;
            }
            if (!this.locked) {
                TileEntity te;
                ++this.age;
                if (this.age >= 20) {
                    this.age = 0;
                }
                int f1 = 0;
                int f2 = 0;
                int f3 = 0;
                int f4 = 0;
                int booster = 0;
                if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(6, 0, 0)) instanceof TileEntityAMSLimiter) {
                    te = (TileEntityAMSLimiter)this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(6, 0, 0));
                    if (!te.locked && te.func_145832_p() == 4) {
                        f1 = te.efficiency;
                        if (te.mode == 2) {
                            ++booster;
                        }
                    }
                }
                if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-6, 0, 0)) instanceof TileEntityAMSLimiter) {
                    te = (TileEntityAMSLimiter)this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-6, 0, 0));
                    if (!te.locked && te.func_145832_p() == 5) {
                        f2 = te.efficiency;
                        if (te.mode == 2) {
                            ++booster;
                        }
                    }
                }
                if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 6)) instanceof TileEntityAMSLimiter) {
                    te = (TileEntityAMSLimiter)this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 6));
                    if (!te.locked && te.func_145832_p() == 2) {
                        f3 = te.efficiency;
                        if (te.mode == 2) {
                            ++booster;
                        }
                    }
                }
                if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -6)) instanceof TileEntityAMSLimiter) {
                    te = (TileEntityAMSLimiter)this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -6));
                    if (!te.locked && te.func_145832_p() == 3) {
                        f4 = te.efficiency;
                        if (te.mode == 2) {
                            ++booster;
                        }
                    }
                }
                this.field = Math.round(this.calcField(f1, f2, f3, f4));
                this.mode = 0;
                if (this.field > 0) {
                    this.mode = 1;
                }
                if (booster > 0) {
                    this.mode = 2;
                }
                if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 9, 0)) instanceof TileEntityAMSEmitter) {
                    te = (TileEntityAMSEmitter)this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 9, 0));
                    this.efficiency = ((TileEntityAMSEmitter)te).efficiency;
                }
                this.color = -1;
                float powerMod = 1.0f;
                float heatMod = 1.0f;
                float fuelMod = 1.0f;
                long powerBase = 0L;
                int heatBase = 0;
                int fuelBase = 0;
                if (this.inventory.getStackInSlot(8).func_77973_b() instanceof ItemCatalyst && this.inventory.getStackInSlot(9).func_77973_b() instanceof ItemCatalyst && this.inventory.getStackInSlot(10).func_77973_b() instanceof ItemCatalyst && this.inventory.getStackInSlot(11).func_77973_b() instanceof ItemCatalyst && this.inventory.getStackInSlot(12).func_77973_b() instanceof ItemAMSCore && this.hasResonators() && this.efficiency > 0) {
                    int g;
                    int a = ((ItemCatalyst)this.inventory.getStackInSlot(8).func_77973_b()).getColor();
                    int b = ((ItemCatalyst)this.inventory.getStackInSlot(9).func_77973_b()).getColor();
                    int c = ((ItemCatalyst)this.inventory.getStackInSlot(10).func_77973_b()).getColor();
                    int d = ((ItemCatalyst)this.inventory.getStackInSlot(11).func_77973_b()).getColor();
                    int e = this.calcAvgHex(a, b);
                    int f = this.calcAvgHex(c, d);
                    this.color = g = this.calcAvgHex(e, f);
                    for (int i = 8; i < 12; ++i) {
                        powerBase += ItemCatalyst.getPowerAbs(this.inventory.getStackInSlot(i));
                        powerMod *= ItemCatalyst.getPowerMod(this.inventory.getStackInSlot(i));
                        heatMod *= ItemCatalyst.getHeatMod(this.inventory.getStackInSlot(i));
                        fuelMod *= ItemCatalyst.getFuelMod(this.inventory.getStackInSlot(i));
                    }
                    powerBase = ItemAMSCore.getPowerBase(this.inventory.getStackInSlot(12));
                    heatBase = (int)ItemAMSCore.getHeatBase(this.inventory.getStackInSlot(12));
                    fuelBase = (int)ItemAMSCore.getFuelBase(this.inventory.getStackInSlot(12));
                    powerBase *= (long)this.efficiency;
                    powerBase = (long)((double)powerBase * Math.pow(1.25, booster));
                    heatBase = (int)((double)heatBase * Math.pow(1.25, booster));
                    heatBase *= 100 - this.field;
                    if (this.getFuelPower(this.tanks[2].getFluid()) > 0 && this.getFuelPower(this.tanks[3].getFluid()) > 0 && this.tanks[2].getFluidAmount() > 0 && this.tanks[3].getFluidAmount() > 0) {
                        this.power = (long)((float)this.power + (float)powerBase * powerMod * this.gauss(1.0f, (this.heat - 2500) / 5000) / 1000.0f * (float)this.getFuelPower(this.tanks[2].getFluid()) * (float)this.getFuelPower(this.tanks[3].getFluid()));
                        this.heat = (int)((float)this.heat + (float)heatBase * heatMod / ((float)this.field / 100.0f));
                        this.tanks[2].drain((int)((float)fuelBase * fuelMod), true);
                        this.tanks[3].drain((int)((float)fuelBase * fuelMod), true);
                        this.radiation();
                        if (this.heat > 5000) {
                            this.explode();
                            this.heat = 5000;
                        }
                        if (this.field <= 0) {
                            this.explode();
                        }
                    }
                }
                if (this.power > 1000000000000000L) {
                    this.power = 1000000000000000L;
                }
                if (this.heat > 0 && this.tanks[0].getFluidAmount() > 0 && this.tanks[1].getFluidAmount() > 0) {
                    this.heat -= this.getCoolingStrength(this.tanks[0].getFluid()) * this.getCoolingStrength(this.tanks[1].getFluid());
                    this.tanks[0].drain(10, true);
                    this.tanks[1].drain(10, true);
                    if (this.heat < 0) {
                        this.heat = 0;
                    }
                }
            } else {
                this.field = 0;
                this.efficiency = 0;
                this.power = 0L;
                this.warning = 3;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.locked ? 1 : 0, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.color, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.efficiency, 2), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.field, 3), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1], this.tanks[2], this.tanks[3]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
        }
    }

    private void radiation() {
        double minSize;
        double maxSize = 5.0;
        double scale = minSize = 0.5;
        scale += ((double)this.tanks[2].getFluidAmount() / (double)this.tanks[2].getCapacity() + (double)this.tanks[3].getFluidAmount() / (double)this.tanks[3].getCapacity()) * ((maxSize - minSize) / 2.0);
        scale *= 0.6;
        List list = this.field_145850_b.func_72839_b(null, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 10) + 0.5, (double)(this.field_174879_c.func_177956_o() - 10) + 0.5 + 6.0, (double)(this.field_174879_c.func_177952_p() - 10) + 0.5, (double)(this.field_174879_c.func_177958_n() + 10) + 0.5, (double)(this.field_174879_c.func_177956_o() + 10) + 0.5 + 6.0, (double)(this.field_174879_c.func_177952_p() + 10) + 0.5));
        for (Entity e : list) {
            if (e instanceof EntityPlayer && ArmorUtil.checkForHazmat((EntityPlayer)e) || Library.isObstructed(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5 + 6.0, (double)this.field_174879_c.func_177952_p() + 0.5, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) continue;
            e.func_70097_a(ModDamageSource.ams, 1000.0f);
            e.func_70015_d(3);
        }
        List list2 = this.field_145850_b.func_72839_b(null, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - scale + 0.5, (double)this.field_174879_c.func_177956_o() - scale + 0.5 + 6.0, (double)this.field_174879_c.func_177952_p() - scale + 0.5, (double)this.field_174879_c.func_177958_n() + scale + 0.5, (double)this.field_174879_c.func_177956_o() + scale + 0.5 + 6.0, (double)this.field_174879_c.func_177952_p() + scale + 0.5));
        for (Entity e : list2) {
            if (e instanceof EntityPlayer && ArmorUtil.checkForHaz2((EntityPlayer)e)) continue;
            e.func_70097_a(ModDamageSource.amsCore, 10000.0f);
        }
    }

    private void explode() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                EntityCloudFleijaRainbow cloud = new EntityCloudFleijaRainbow(this.field_145850_b, 100);
                cloud.field_70165_t = this.field_174879_c.func_177958_n() + this.rand.nextInt(201) - 100;
                cloud.field_70163_u = this.field_174879_c.func_177956_o() + this.rand.nextInt(201) - 100;
                cloud.field_70161_v = this.field_174879_c.func_177952_p() + this.rand.nextInt(201) - 100;
                this.field_145850_b.func_72838_d((Entity)cloud);
            }
            int radius = (int)(50.0 + (double)(this.tanks[2].getFluidAmount() + this.tanks[3].getFluidAmount()) / 16000.0 * 150.0);
            this.field_145850_b.func_72838_d((Entity)EntityNukeExplosionMK4.statFacExperimental(this.field_145850_b, radius, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    private int getCoolingStrength(FluidStack type) {
        if (type == null) {
            return 0;
        }
        if (type.getFluid() == FluidRegistry.WATER) {
            return 5;
        }
        if (type.getFluid() == ModForgeFluids.oil) {
            return 15;
        }
        if (type.getFluid() == ModForgeFluids.coolant) {
            return this.heat / 250;
        }
        if (type.getFluid() == ModForgeFluids.cryogel) {
            return this.heat > this.heat / 2 ? 25 : 5;
        }
        return 0;
    }

    private int getFuelPower(FluidStack type) {
        if (type == null) {
            return 0;
        }
        if (type.getFluid() == ModForgeFluids.deuterium) {
            return 50;
        }
        if (type.getFluid() == ModForgeFluids.tritium) {
            return 75;
        }
        return 0;
    }

    private float gauss(float a, float x) {
        double amplifier = 0.1;
        return (float)(1.0 / Math.sqrt((double)a * Math.PI) * Math.pow(Math.E, -1.0 * Math.pow(x, 2.0) / amplifier));
    }

    private float calcField(int a, int b, int c, int d) {
        return (float)(a + b + c + d) * (float)(a * 25 + b * 25 + c * 25 + d * 25) / 40000.0f;
    }

    private int calcAvgHex(int h1, int h2) {
        int r1 = (h1 & 0xFF0000) >> 16;
        int g1 = (h1 & 0xFF00) >> 8;
        int b1 = (h1 & 0xFF) >> 0;
        int r2 = (h2 & 0xFF0000) >> 16;
        int g2 = (h2 & 0xFF00) >> 8;
        int b2 = (h2 & 0xFF) >> 0;
        int r = (r1 + r2) / 2 << 16;
        int g = (g1 + g2) / 2 << 8;
        int b = (b1 + b2) / 2 << 0;
        return r | g | b;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000000000000L;
    }

    public int getEfficiencyScaled(int i) {
        return this.efficiency * i / 100;
    }

    public int getFieldScaled(int i) {
        return this.field * i / 100;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    public boolean hasResonators() {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0], this.tanks[3].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == ModForgeFluids.coolant) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (resource.getFluid() == ModForgeFluids.cryogel) {
            return this.tanks[1].fill(resource, doFill);
        }
        if (resource.getFluid() == ModForgeFluids.deuterium) {
            return this.tanks[2].fill(resource, doFill);
        }
        if (resource.getFluid() == ModForgeFluids.tritium) {
            return this.tanks[3].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 4) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
        this.tanks[2].readFromNBT(tags[2]);
        this.tanks[3].readFromNBT(tags[3]);
    }
}

