/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.conductor;

import com.hbm.forgefluid.FFPipeNetwork;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.IFluidPipe;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEFluidTypePacketTest;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFFDuctBase
extends TileEntity
implements IFluidPipe,
IFluidHandler,
ITickable {
    public EnumFacing[] connections = new EnumFacing[6];
    public Fluid type = null;
    public FFPipeNetwork network = null;
    public ICapabilityProvider[] fluidHandlerCache = new ICapabilityProvider[6];
    public boolean isValidForForming = true;
    public boolean firstUpdate = true;
    public boolean needsBuildNetwork = false;
    public boolean thisIsATest = false;
    public int weirdTest = 0;

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("fluidType")) {
            this.type = FluidRegistry.getFluid((String)compound.func_74779_i("fluidType"));
        }
        this.needsBuildNetwork = true;
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.type != null) {
            compound.func_74778_a("fluidType", this.type.getName());
        }
        return super.func_189515_b(compound);
    }

    public void onChunkUnload() {
        if (this.getNetworkTrue() != null) {
            this.getNetworkTrue().getPipes().remove(this);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.detectAndSendChanges();
        }
        this.updateConnections();
        if (this.needsBuildNetwork) {
            if (this.network == null) {
                FFPipeNetwork.buildNewNetwork(this);
            }
            this.checkFluidHandlers();
            this.needsBuildNetwork = false;
        }
        if (this.thisIsATest) {
            this.typeChanged(this.type);
            this.checkFluidHandlers();
            this.thisIsATest = false;
        }
    }

    public void updateConnections() {
        this.connections[0] = FFUtils.checkFluidConnectables(this.field_145850_b, this.field_174879_c.func_177984_a(), this.getNetworkTrue(), EnumFacing.UP.func_176734_d()) ? EnumFacing.UP : null;
        this.connections[1] = FFUtils.checkFluidConnectables(this.field_145850_b, this.field_174879_c.func_177977_b(), this.getNetworkTrue(), EnumFacing.DOWN.func_176734_d()) ? EnumFacing.DOWN : null;
        this.connections[2] = FFUtils.checkFluidConnectables(this.field_145850_b, this.field_174879_c.func_177978_c(), this.getNetworkTrue(), EnumFacing.NORTH.func_176734_d()) ? EnumFacing.NORTH : null;
        this.connections[3] = FFUtils.checkFluidConnectables(this.field_145850_b, this.field_174879_c.func_177974_f(), this.getNetworkTrue(), EnumFacing.EAST.func_176734_d()) ? EnumFacing.EAST : null;
        this.connections[4] = FFUtils.checkFluidConnectables(this.field_145850_b, this.field_174879_c.func_177968_d(), this.getNetworkTrue(), EnumFacing.SOUTH.func_176734_d()) ? EnumFacing.SOUTH : null;
        this.connections[5] = FFUtils.checkFluidConnectables(this.field_145850_b, this.field_174879_c.func_177976_e(), this.getNetworkTrue(), EnumFacing.WEST.func_176734_d()) ? EnumFacing.WEST : null;
    }

    public void checkOtherNetworks() {
        ArrayList<FFPipeNetwork> list = new ArrayList<FFPipeNetwork>();
        list.add(this.getNetworkTrue());
        FFPipeNetwork largeNet = null;
        for (int i = 0; i < 6; ++i) {
            TileEntity te = FFPipeNetwork.getTileEntityAround(this, i);
            if (!(te instanceof IFluidPipe) || ((IFluidPipe)te).getNetworkTrue() == null || ((IFluidPipe)te).getNetworkTrue().getType() != this.getType() || list.contains(((IFluidPipe)te).getNetworkTrue())) continue;
            list.add(((IFluidPipe)te).getNetworkTrue());
            if (largeNet != null && ((IFluidPipe)te).getNetworkTrue().getSize() <= largeNet.getSize()) continue;
            largeNet = ((IFluidPipe)te).getNetworkTrue();
        }
        if (largeNet != null) {
            for (FFPipeNetwork network : list) {
                FFPipeNetwork.mergeNetworks(largeNet, network);
            }
            this.network = largeNet;
        } else {
            this.getNetwork().Destroy();
            this.network = this.createNewNetwork();
        }
    }

    public FFPipeNetwork createNewNetwork() {
        return new FFPipeNetwork(this.type);
    }

    public void typeChanged(Fluid type) {
        this.getNetwork().setType(type);
        FFPipeNetwork.buildNewNetwork(this);
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAll((IMessage)new TEFluidTypePacketTest(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), type));
        }
    }

    public void onNeighborBlockChange() {
        this.checkFluidHandlers();
    }

    public void checkFluidHandlers() {
        if (this.network == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            TileEntity te = FFPipeNetwork.getTileEntityAround(this, i);
            if (te == null || te instanceof IFluidPipe || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) continue;
            if (this.fluidHandlerCache[i] != null) {
                this.network.getConsumers().remove(this.fluidHandlerCache[i]);
            }
            if (!this.network.getConsumers().contains(te)) {
                this.network.getConsumers().add((ICapabilityProvider)te);
            }
            this.fluidHandlerCache[i] = te;
        }
    }

    private void detectAndSendChanges() {
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEFluidTypePacketTest(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.type), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
        this.func_70296_d();
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.getNetwork().getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.getNetwork().fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.getNetwork().drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.getNetwork().drain(maxDrain, doDrain);
    }

    @Override
    public FFPipeNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        this.network = new FFPipeNetwork();
        this.network.setType(this.getType());
        this.network.addPipe(this);
        return this.network;
    }

    @Override
    public FFPipeNetwork getNetworkTrue() {
        return this.network;
    }

    @Override
    public void setNetwork(FFPipeNetwork net) {
        this.network = net;
    }

    @Override
    public Fluid getType() {
        return this.type;
    }

    @Override
    public void setType(Fluid fluid) {
        this.type = fluid;
        this.typeChanged(fluid);
    }

    @Override
    public void setTypeTrue(Fluid fluid) {
        this.type = fluid;
    }

    @Override
    public boolean getIsValidForForming() {
        return this.isValidForForming;
    }

    @Override
    public void breakBlock() {
        this.getNetwork().Destroy();
        this.isValidForForming = false;
        for (int i = 0; i < 6; ++i) {
            TileEntity ent = FFPipeNetwork.getTileEntityAround(this, i);
            if (ent == null || !(ent instanceof IFluidPipe)) continue;
            FFPipeNetwork.buildNewNetwork(ent);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this) : super.getCapability(capability, facing));
    }
}

