/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.energy.IBatteryItem;
import com.hbm.entity.effect.EntityNukeCloudSmall;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityNukeBalefire
extends TileEntityMachineBase
implements ITickable {
    public boolean loaded;
    public boolean started;
    public int timer = 18000;

    public TileEntityNukeBalefire() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.nukeFstbmb";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isLoaded()) {
                this.started = false;
            }
            if (this.started) {
                --this.timer;
                if (this.timer % 20 == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.fstbmbPing, SoundCategory.BLOCKS, 5.0f, 1.0f);
                }
            }
            if (this.timer <= 0) {
                this.explode();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("timer", this.timer);
            data.func_74757_a("loaded", this.isLoaded());
            data.func_74757_a("started", this.started);
            this.networkPack(data, 250);
        }
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0 && this.isLoaded()) {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.fstbmbStart, SoundCategory.BLOCKS, 5.0f, 1.0f);
            this.started = true;
        }
        if (meta == 1) {
            this.timer = value * 20;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.timer = data.func_74762_e("timer");
        this.started = data.func_74767_n("started");
        this.loaded = data.func_74767_n("loaded");
    }

    @Override
    public boolean isLoaded() {
        return this.hasEgg() && this.hasBattery();
    }

    public boolean hasEgg() {
        return this.inventory.getStackInSlot(0).func_77973_b() == ModItems.egg_balefire;
    }

    public boolean hasBattery() {
        return this.getBattery() > 0;
    }

    public int getBattery() {
        if (this.inventory.getStackInSlot(1).func_77973_b() == ModItems.battery_spark && ((IBatteryItem)ModItems.battery_spark).getCharge(this.inventory.getStackInSlot(1)) == ((IBatteryItem)ModItems.battery_spark).getMaxCharge()) {
            return 1;
        }
        if (this.inventory.getStackInSlot(1).func_77973_b() == ModItems.battery_trixite && ((IBatteryItem)ModItems.battery_trixite).getCharge(this.inventory.getStackInSlot(1)) == ((IBatteryItem)ModItems.battery_trixite).getMaxCharge()) {
            return 2;
        }
        return 0;
    }

    public void explode() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.field_145850_b.func_175655_b(this.field_174879_c, false);
        EntityBalefire bf = new EntityBalefire(this.field_145850_b);
        bf.field_70165_t = (double)this.field_174879_c.func_177958_n() + 0.5;
        bf.field_70163_u = (double)this.field_174879_c.func_177956_o() + 0.5;
        bf.field_70161_v = (double)this.field_174879_c.func_177952_p() + 0.5;
        bf.destructionRange = 250;
        this.field_145850_b.func_72838_d((Entity)bf);
        this.field_145850_b.func_72838_d((Entity)EntityNukeCloudSmall.statFacBale(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 5, (double)this.field_174879_c.func_177952_p() + 0.5, 250.0f));
    }

    public String getMinutes() {
        String mins = "" + this.timer / 1200;
        if (mins.length() == 1) {
            mins = "0" + mins;
        }
        return mins;
    }

    public String getSeconds() {
        String mins = "" + this.timer / 20 % 60;
        if (mins.length() == 1) {
            mins = "0" + mins;
        }
        return mins;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.started = compound.func_74767_n("started");
        this.timer = compound.func_74762_e("timer");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("started", this.started);
        compound.func_74768_a("timer", this.timer);
        return super.func_189515_b(compound);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

