/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import api.hbm.energy.IEnergyUser;
import api.hbm.tile.IHeatSource;
import com.hbm.tileentity.TileEntityProxyBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityProxyCombo
extends TileEntityProxyBase
implements IEnergyUser,
IHeatSource {
    TileEntity tile;
    boolean inventory;
    boolean power;
    boolean fluid;
    boolean heat;

    public TileEntityProxyCombo() {
    }

    public TileEntityProxyCombo(boolean inventory, boolean power, boolean fluid) {
        this.inventory = inventory;
        this.power = power;
        this.fluid = fluid;
        this.heat = false;
    }

    public TileEntityProxyCombo(boolean inventory, boolean power, boolean fluid, boolean heat) {
        this.inventory = inventory;
        this.power = power;
        this.fluid = fluid;
        this.heat = heat;
    }

    public TileEntity getTile() {
        if (this.tile == null) {
            this.tile = this.getTE();
        }
        return this.tile;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.tile == null) {
            this.tile = this.getTE();
            if (this.tile == null) {
                return (T)super.getCapability(capability, facing);
            }
        }
        if (this.inventory && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.tile.getCapability(capability, facing);
        }
        if (this.power && capability == CapabilityEnergy.ENERGY) {
            return (T)this.tile.getCapability(capability, facing);
        }
        if (this.fluid && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tile.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.tile == null) {
            this.tile = this.getTE();
            if (this.tile == null) {
                return super.hasCapability(capability, facing);
            }
        }
        if (this.inventory && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.tile.hasCapability(capability, facing);
        }
        if (this.power && capability == CapabilityEnergy.ENERGY) {
            return this.tile.hasCapability(capability, facing);
        }
        if (this.fluid && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tile.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public void setPower(long i) {
        if (!this.power) {
            return;
        }
        if (this.getTile() instanceof IEnergyUser) {
            ((IEnergyUser)this.getTile()).setPower(i);
        }
    }

    @Override
    public long getPower() {
        if (!this.power) {
            return 0L;
        }
        if (this.getTile() instanceof IEnergyUser) {
            return ((IEnergyUser)this.getTile()).getPower();
        }
        return 0L;
    }

    @Override
    public long getMaxPower() {
        if (!this.power) {
            return 0L;
        }
        if (this.getTile() instanceof IEnergyUser) {
            return ((IEnergyUser)this.getTile()).getMaxPower();
        }
        return 0L;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory = compound.func_74767_n("inv");
        this.fluid = compound.func_74767_n("flu");
        this.power = compound.func_74767_n("pow");
        this.heat = compound.func_74767_n("hea");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("inv", this.inventory);
        compound.func_74757_a("flu", this.fluid);
        compound.func_74757_a("pow", this.power);
        compound.func_74757_a("hea", this.heat);
        return super.func_189515_b(compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Override
    public int getHeatStored() {
        if (!this.heat) {
            return 0;
        }
        if (this.getTile() instanceof IHeatSource) {
            return ((IHeatSource)this.getTile()).getHeatStored();
        }
        return 0;
    }

    @Override
    public void useUpHeat(int heat) {
        if (!this.heat) {
            return;
        }
        if (this.getTile() instanceof IHeatSource) {
            ((IHeatSource)this.getTile()).useUpHeat(heat);
        }
    }
}

