/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.main.ResourceManager;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.util.I18nUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class RenderRBMKConsole
extends TileEntitySpecialRenderer<TileEntityRBMKConsole> {
    public boolean isGlobalRenderer(TileEntityRBMKConsole te) {
        return true;
    }

    public void render(TileEntityRBMKConsole te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        switch (te.func_145832_p() - 10) {
            case 2: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
        GlStateManager.func_179103_j((int)7425);
        this.func_147499_a(ResourceManager.rbmk_console_tex);
        ResourceManager.rbmk_console.renderAll();
        GlStateManager.func_179103_j((int)7424);
        TileEntityRBMKConsole console = te;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GL11.glDisable((int)3553);
        block11: for (int i = 0; i < console.columns.length; ++i) {
            TileEntityRBMKConsole.RBMKColumn col = console.columns[i];
            if (col == null) continue;
            double kx = -0.37;
            double ky = (double)(-(i / 15)) * 0.125 + 3.625;
            double kz = (double)(-(i % 15)) * 0.125 + 0.875;
            this.drawColumn(buf, kx, ky, kz, (float)(0.75 + (double)(i % 2) * 0.05), col.data.func_74769_h("heat") / col.data.func_74769_h("maxHeat"));
            switch (col.type) {
                case FUEL: 
                case FUEL_SIM: {
                    this.drawFuel(buf, kx + 0.01, ky, kz, col.data.func_74769_h("enrichment"));
                    continue block11;
                }
                case CONTROL: {
                    this.drawControl(buf, kx + 0.01, ky, kz, col.data.func_74769_h("level"));
                    continue block11;
                }
                case CONTROL_AUTO: {
                    this.drawControlAuto(buf, kx + 0.01, ky, kz, col.data.func_74769_h("level"));
                    continue block11;
                }
            }
        }
        tess.func_78381_a();
        GL11.glEnable((int)3553);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslatef((float)-0.42f, (float)3.5f, (float)1.75f);
        GlStateManager.func_179132_a((boolean)false);
        GL11.glEnable((int)32826);
        for (int i = 0; i < console.screens.length; ++i) {
            GL11.glPushMatrix();
            if (i % 2 == 1) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-3.5f);
            }
            GL11.glTranslatef((float)0.0f, (float)(-0.75f * (float)(i / 2)), (float)0.0f);
            TileEntityRBMKConsole.RBMKScreen screen = console.screens[i];
            String text = screen.display;
            if (text != null && !text.isEmpty()) {
                String[] parts = text.split("=");
                if (parts.length == 2) {
                    text = I18nUtil.resolveKey(parts[0], parts[1]);
                }
                int width = font.func_78256_a(text);
                int height = font.field_78288_b;
                float f3 = Math.min(0.03f, 0.8f / (float)Math.max(width, 1));
                GL11.glScalef((float)f3, (float)(-f3), (float)f3);
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                font.func_78276_b(text, -width / 2, -height / 2, 65280);
            }
            GL11.glPopMatrix();
        }
        GlStateManager.func_179132_a((boolean)true);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void drawColumn(BufferBuilder buf, double x, double y, double z, float color, double heat) {
        double width = 0.046875;
        float r = (float)((double)color + (double)(1.0f - color) * Math.max(0.0, heat - 0.4));
        float d = (float)((double)color - (double)color * Math.max(0.0, heat - 0.6));
        buf.func_181662_b(x, y + width, z - width).func_181666_a(r, d, d, 1.0f).func_181675_d();
        buf.func_181662_b(x, y + width, z + width).func_181666_a(r, d, d, 1.0f).func_181675_d();
        buf.func_181662_b(x, y - width, z + width).func_181666_a(r, d, d, 1.0f).func_181675_d();
        buf.func_181662_b(x, y - width, z - width).func_181666_a(r, d, d, 1.0f).func_181675_d();
    }

    private void drawFuel(BufferBuilder buf, double x, double y, double z, double enrichment) {
        this.drawDot(buf, x, y, z, 0.0f, 0.25f + (float)(enrichment * 0.75), 0.0f);
    }

    private void drawControl(BufferBuilder buf, double x, double y, double z, double level) {
        this.drawDot(buf, x, y, z, (float)level, (float)level, 0.0f);
    }

    private void drawControlAuto(BufferBuilder buf, double x, double y, double z, double level) {
        this.drawDot(buf, x, y, z, (float)level, 0.0f, (float)level);
    }

    private void drawDot(BufferBuilder buf, double x, double y, double z, float r, float g, float b) {
        double width = 0.03125;
        double edge = 0.022097;
        buf.func_181662_b(x, y + width, z).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y + edge, z + edge).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y, z + width).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y - edge, z + edge).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y + edge, z - edge).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y + width, z).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y - edge, z - edge).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y, z - width).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y + width, z).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y - edge, z + edge).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y - width, z).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buf.func_181662_b(x, y - edge, z - edge).func_181666_a(r, g, b, 1.0f).func_181675_d();
    }
}

