/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.machine.TileEntityForceField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class RenderMachineForceField
extends TileEntitySpecialRenderer<TileEntityForceField> {
    public boolean isGlobalRenderer(TileEntityForceField te) {
        return true;
    }

    public void render(TileEntityForceField te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.func_179145_e();
        GlStateManager.func_179129_p();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(ResourceManager.forcefield_base_tex);
        ResourceManager.radar_body.renderAll();
        TileEntityForceField ff = te;
        GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
        int segments = (int)(16.0 + (double)ff.radius * 0.125);
        this.func_147499_a(ResourceManager.forcefield_top_tex);
        if (ff.isOn && ff.health > 0 && ff.power > 0L && ff.cooldown == 0) {
            this.generateSphere(segments, segments * 2, ff.radius, ff.color);
            double rot = (double)System.currentTimeMillis() / 10.0 % 360.0;
            GL11.glRotated((double)(-rot), (double)0.0, (double)1.0, (double)0.0);
        }
        GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
        ResourceManager.forcefield_top.renderAll();
        GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.func_179089_o();
        GL11.glPopMatrix();
    }

    private void generateSphere(int l, int s, float rad, int hex) {
        float r = (float)(hex >> 16 & 0xFF) / 255.0f;
        float g = (float)(hex >> 8 & 0xFF) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        float sRot = 360.0f / (float)s;
        float lRot = (float)Math.PI / (float)l;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        for (int k = 0; k < s; ++k) {
            buf.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            GL11.glRotatef((float)sRot, (float)0.0f, (float)1.0f, (float)0.0f);
            Vec3 vec = Vec3.createVectorHelper(0.0, rad, 0.0);
            for (int i = 0; i < l; ++i) {
                buf.func_181662_b(vec.xCoord, vec.yCoord, vec.zCoord).func_181666_a(r, g, b, 1.0f).func_181675_d();
                vec.rotateAroundX(lRot);
                buf.func_181662_b(vec.xCoord, vec.yCoord, vec.zCoord).func_181666_a(r, g, b, 1.0f).func_181675_d();
            }
            tes.func_78381_a();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
        this.generateSphere2(l, s, rad, hex);
    }

    private void generateSphere2(int l, int s, float rad, int hex) {
        float r = (float)(hex >> 16 & 0xFF) / 255.0f;
        float g = (float)(hex >> 8 & 0xFF) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        float sRot = (float)Math.PI * 2 / (float)s;
        float lRot = (float)Math.PI / (float)l;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        Vec3 vec2 = Vec3.createVectorHelper(0.0, rad, 0.0);
        buf.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (int k = 0; k < l; ++k) {
            vec2.rotateAroundZ(lRot);
            for (int i = 0; i < s; ++i) {
                buf.func_181662_b(vec2.xCoord, vec2.yCoord, vec2.zCoord).func_181666_a(r, g, b, 1.0f).func_181675_d();
                vec2.rotateAroundY(sRot);
                buf.func_181662_b(vec2.xCoord, vec2.yCoord, vec2.zCoord).func_181666_a(r, g, b, 1.0f).func_181675_d();
            }
        }
        tes.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
    }
}

