/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.render.misc.BeamPronter;
import com.hbm.tileentity.machine.TileEntityMachineMiningLaser;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderLaserMiner
extends TileEntitySpecialRenderer<TileEntityMachineMiningLaser> {
    public boolean isGlobalRenderer(TileEntityMachineMiningLaser te) {
        return true;
    }

    public void render(TileEntityMachineMiningLaser te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y - 1.0), (double)(z + 0.5));
        TileEntityMachineMiningLaser laser = te;
        double tx = x;
        double ty = 0.0;
        double tz = z;
        if (laser.beam) {
            tx = (float)(laser.targetX - laser.lastTargetX) * partialTicks + (float)laser.lastTargetX;
            ty = (float)(laser.targetY - laser.lastTargetY) * partialTicks + (float)laser.lastTargetY;
            tz = (float)(laser.targetZ - laser.lastTargetZ) * partialTicks + (float)laser.lastTargetZ;
        }
        double vx = tx - (double)laser.func_174877_v().func_177958_n();
        double vy = ty - (double)laser.func_174877_v().func_177956_o() + 3.0;
        double vz = tz - (double)laser.func_174877_v().func_177952_p();
        Vec3 nVec = Vec3.createVectorHelper(vx, vy, vz);
        nVec = nVec.normalize();
        double d = 1.5;
        nVec.xCoord *= d;
        nVec.yCoord *= d;
        nVec.zCoord *= d;
        Vec3 vec = Vec3.createVectorHelper(vx - nVec.xCoord, vy - nVec.yCoord, vz - nVec.zCoord);
        double length = vec.lengthVector();
        double yaw = Math.toDegrees(Math.atan2(vec.xCoord, vec.zCoord));
        double sqrt = MathHelper.func_76133_a((double)(vec.xCoord * vec.xCoord + vec.zCoord * vec.zCoord));
        double pitch = Math.toDegrees(Math.atan2(vec.yCoord, sqrt));
        this.func_147499_a(ResourceManager.mining_laser_base_tex);
        ResourceManager.mining_laser.renderPart("Base");
        GL11.glPushMatrix();
        GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
        this.func_147499_a(ResourceManager.mining_laser_pivot_tex);
        ResourceManager.mining_laser.renderPart("Pivot");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
        GL11.glRotated((double)(pitch + 90.0), (double)-1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
        this.func_147499_a(ResourceManager.mining_laser_laser_tex);
        ResourceManager.mining_laser.renderPart("Laser");
        GL11.glPopMatrix();
        if (laser.beam) {
            length = vec.lengthVector();
            GL11.glTranslated((double)nVec.xCoord, (double)(nVec.yCoord - 1.0), (double)nVec.zCoord);
            int range = (int)Math.ceil(length * 0.5);
            BeamPronter.prontBeam(vec, BeamPronter.EnumWaveType.STRAIGHT, BeamPronter.EnumBeamType.SOLID, 0xA00000, 0xFFFFFF, 0, 1, 0.0f, 3, 0.09f);
        }
        GL11.glPopMatrix();
    }
}

