/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.effect;

import com.hbm.entity.effect.EntityNukeCloudSmall;
import com.hbm.hfr.render.loader.HFRWavefrontObject;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.IModelCustom;
import java.util.Random;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;

public class RenderSmallNukeMK4
extends Render<EntityNukeCloudSmall> {
    public static final IRenderFactory<EntityNukeCloudSmall> FACTORY = man -> new RenderSmallNukeMK4(man);
    public static final IModelCustom mush = new HFRWavefrontObject(new ResourceLocation("hbm", "models/effect/mush.obj"));
    public static final IModelCustom shockwave = new HFRWavefrontObject(new ResourceLocation("hbm", "models/effect/ring_roller.obj"));
    public static final IModelCustom thinring = new HFRWavefrontObject(new ResourceLocation("hbm", "models/effect/ring_thin.obj"));
    private static final ResourceLocation cloudlet = new ResourceLocation("hbm:textures/particle/particle_base.png");
    private static final double lightmapSizeMult = 0.01;

    protected RenderSmallNukeMK4(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityNukeCloudSmall cloud, double x, double y, double z, float entityYaw, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        int cloudAge = (Integer)cloud.func_184212_Q().func_187225_a(EntityNukeCloudSmall.AGE);
        if (cloud.age < cloudAge) {
            cloud.age = cloudAge;
        }
        this.mushWrapper(cloud, partialTicks);
        this.cloudletWrapper(cloud, partialTicks);
        this.flashWrapper(cloud, partialTicks);
        GL11.glPopMatrix();
    }

    protected ResourceLocation getEntityTexture(EntityNukeCloudSmall entity) {
        return null;
    }

    private void flashWrapper(EntityNukeCloudSmall cloud, float interp) {
        if (cloud.age < 100) {
            GL11.glPushMatrix();
            double scale = (double)((float)cloud.age + interp) / 100.0;
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            scale = scale * Math.pow(Math.E, -scale) * 2.717391304;
            this.renderFlash(scale);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GL11.glPopMatrix();
        }
    }

    private ResourceLocation getMushroomTexture(float cloudAge, boolean isBalefire, boolean isEmissive, float radius) {
        float sizeFactor = (float)(Math.pow(radius, 2.0) / 15129.0);
        if (cloudAge < 100.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_0_e;
                }
                return ResourceManager.balefire_0;
            }
            if (isEmissive) {
                return ResourceManager.fireball_0_e;
            }
            return ResourceManager.fireball_0;
        }
        if (cloudAge < 140.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_1_e;
                }
                return ResourceManager.balefire_1;
            }
            if (isEmissive) {
                return ResourceManager.fireball_1_e;
            }
            return ResourceManager.fireball_1;
        }
        if (cloudAge < 200.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_2_e;
                }
                return ResourceManager.balefire_2;
            }
            if (isEmissive) {
                return ResourceManager.fireball_2_e;
            }
            return ResourceManager.fireball_2;
        }
        if (cloudAge < 300.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_3_e;
                }
                return ResourceManager.balefire_3;
            }
            if (isEmissive) {
                return ResourceManager.fireball_3_e;
            }
            return ResourceManager.fireball_3;
        }
        if (cloudAge < 460.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_4_e;
                }
                return ResourceManager.balefire_4;
            }
            if (isEmissive) {
                return ResourceManager.fireball_4_e;
            }
            return ResourceManager.fireball_4;
        }
        if (cloudAge < 720.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_5_e;
                }
                return ResourceManager.balefire_5;
            }
            if (isEmissive) {
                return ResourceManager.fireball_5_e;
            }
            return ResourceManager.fireball_5;
        }
        if (cloudAge < 1140.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_6_e;
                }
                return ResourceManager.balefire_6;
            }
            if (isEmissive) {
                return ResourceManager.fireball_6_e;
            }
            return ResourceManager.fireball_6;
        }
        if (cloudAge < 1820.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_7_e;
                }
                return ResourceManager.balefire_7;
            }
            if (isEmissive) {
                return ResourceManager.fireball_7_e;
            }
            return ResourceManager.fireball_7;
        }
        if (cloudAge < 2920.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_8_e;
                }
                return ResourceManager.balefire_8;
            }
            if (isEmissive) {
                return ResourceManager.fireball_8_e;
            }
            return ResourceManager.fireball_8;
        }
        if (cloudAge < 4700.0f * sizeFactor) {
            if (isBalefire) {
                if (isEmissive) {
                    return ResourceManager.balefire_9_e;
                }
                return ResourceManager.balefire_9;
            }
            if (isEmissive) {
                return ResourceManager.fireball_9_e;
            }
            return ResourceManager.fireball_9;
        }
        if (isBalefire) {
            if (isEmissive) {
                return ResourceManager.balefire_10_e;
            }
            return ResourceManager.balefire_10;
        }
        if (isEmissive) {
            return ResourceManager.fireball_10_e;
        }
        return ResourceManager.fireball_10;
    }

    private void mushWrapper(EntityNukeCloudSmall cloud, float interp) {
        float size = ((Float)cloud.func_184212_Q().func_187225_a(EntityNukeCloudSmall.SCALE)).floatValue() * 5.0f;
        float maxage = ((Integer)cloud.func_184212_Q().func_187225_a(EntityNukeCloudSmall.MAXAGE)).intValue();
        double height = Math.max(20.0f - 1000.0f / ((float)cloud.age + interp - 13.0f), 0.0f);
        boolean balefire = (Byte)cloud.func_184212_Q().func_187225_a(EntityNukeCloudSmall.TYPE) == 1;
        float percentageAge = maxage > 0.0f ? ((float)cloud.age + interp) / maxage : 0.0f;
        double raise_speed = (double)0.014f * Math.pow(0.02, percentageAge) + (double)0.005f;
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GL11.glScalef((float)size, (float)size, (float)size);
        GlStateManager.func_179128_n((int)5890);
        GL11.glLoadIdentity();
        GL11.glTranslated((double)0.0, (double)((double)(-((float)cloud.age + interp)) * raise_speed), (double)0.0);
        GlStateManager.func_179128_n((int)5888);
        GL11.glPushMatrix();
        this.func_110776_a(this.getMushroomTexture(cloud.age, balefire, false, size * 40.0f));
        this.renderMushHead((float)cloud.age + interp, height, false);
        this.renderMushStem((float)cloud.age + interp, height, false);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.func_110776_a(this.getMushroomTexture(cloud.age, balefire, true, size * 40.0f));
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GL11.glPushAttrib((int)64);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        this.renderMushHead((float)cloud.age + interp, height, true);
        this.renderMushStem((float)cloud.age + interp, height, true);
        GL11.glPopAttrib();
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
        GlStateManager.func_179128_n((int)5890);
        GL11.glLoadIdentity();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GL11.glPopMatrix();
    }

    private void cloudletWrapper(EntityNukeCloudSmall cloud, float interp) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)518, (float)0.01f);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        this.func_110776_a(cloudlet);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (EntityNukeCloudSmall.Cloudlet cloudlet : cloud.cloudlets) {
            float scale = (float)cloud.age + interp - (float)cloudlet.age;
            this.tessellateCloudlet(buf, cloudlet.posX, cloudlet.posY - cloud.field_70163_u + 2.0, cloudlet.posZ, scale, ((Byte)cloud.func_184212_Q().func_187225_a(EntityNukeCloudSmall.TYPE)).byteValue());
        }
        tess.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
    }

    private void renderFlash(double intensity) {
        GL11.glScalef((float)0.2f, (float)0.2f, (float)0.2f);
        double inverse = 1.0 - intensity;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        RenderHelper.func_74518_a();
        Random random = new Random(432L);
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)false);
        GL11.glPushMatrix();
        float scale = 100.0f;
        for (int i = 0; i < 300; ++i) {
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            float vert1 = (random.nextFloat() * 20.0f + 5.0f + 10.0f) * (float)(intensity * (double)scale);
            float vert2 = (random.nextFloat() * 2.0f + 1.0f + 2.0f) * (float)(intensity * (double)scale);
            buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buf.func_181662_b(0.0, 0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)inverse).func_181675_d();
            buf.func_181662_b(-0.866 * (double)vert2, (double)vert1, (double)(-0.5f * vert2)).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(0.866 * (double)vert2, (double)vert1, (double)(-0.5f * vert2)).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(0.0, (double)vert1, (double)(1.0f * vert2)).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(-0.866 * (double)vert2, (double)vert1, (double)(-0.5f * vert2)).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        GL11.glPopMatrix();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
    }

    private void renderMushHead(float progress, double height, boolean outer) {
        GL11.glPushMatrix();
        double expansion = 100.0;
        double width = Math.min((double)progress, expansion) / expansion * 0.3 + 0.7;
        if (outer) {
            GL11.glTranslated((double)0.0, (double)(-26.26 + height), (double)0.0);
            GL11.glScaled((double)(width * 1.01), (double)1.01, (double)(width * 1.01));
        } else {
            GL11.glTranslated((double)0.0, (double)(-26.0 + height), (double)0.0);
            GL11.glScaled((double)width, (double)1.0, (double)width);
        }
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        mush.renderPart("Ball");
        GL11.glEnable((int)3008);
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }

    private void renderMushStem(float progress, double height, boolean outer) {
        GL11.glPushMatrix();
        if (outer) {
            GL11.glTranslated((double)0.0, (double)(-26.0 + height), (double)0.0);
            GL11.glScaled((double)1.01, (double)1.01, (double)1.01);
        } else {
            GL11.glTranslated((double)0.0, (double)(-26.0 + height), (double)0.0);
        }
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        mush.renderPart("Stem");
        GL11.glEnable((int)3008);
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }

    private void tessellateCloudlet(BufferBuilder buf, double posX, double posY, double posZ, float age, int type) {
        float a;
        float b;
        float g;
        float r;
        float alpha;
        float alphaorig = alpha = 1.0f - Math.max(age / (float)EntityNukeCloudSmall.cloudletLife, 0.0f);
        float scale = 2.5f * alpha + 2.5f;
        if (age < 3.0f) {
            alpha = age * 0.333f;
        }
        float f1 = ActiveRenderInfo.func_178808_b();
        float f2 = ActiveRenderInfo.func_178803_d();
        float f3 = ActiveRenderInfo.func_178805_e();
        float f4 = ActiveRenderInfo.func_178807_f();
        float f5 = ActiveRenderInfo.func_178809_c();
        Random rand = new Random((long)((posX * 5.0 + posY * 25.0 + posZ * 125.0) * 1000.0));
        float brightness = rand.nextFloat() * 0.25f + 0.25f;
        if (type == 1) {
            r = 0.25f * alphaorig;
            g = alphaorig - brightness * 0.5f;
            b = 0.25f * alphaorig;
            a = alpha;
        } else {
            g = b = brightness;
            r = b;
            a = alpha;
        }
        a = MathHelper.func_76131_a((float)a, (float)0.0f, (float)1.0f);
        buf.func_181662_b(posX - (double)(f1 * scale) - (double)(f3 * scale), posY - (double)(f5 * scale), posZ - (double)(f2 * scale) - (double)(f4 * scale)).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(posX - (double)(f1 * scale) + (double)(f3 * scale), posY + (double)(f5 * scale), posZ - (double)(f2 * scale) + (double)(f4 * scale)).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(posX + (double)(f1 * scale) + (double)(f3 * scale), posY + (double)(f5 * scale), posZ + (double)(f2 * scale) + (double)(f4 * scale)).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(posX + (double)(f1 * scale) - (double)(f3 * scale), posY - (double)(f5 * scale), posZ + (double)(f2 * scale) - (double)(f4 * scale)).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
    }
}

