/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity;

import com.hbm.entity.effect.EntityFalloutRain;
import com.hbm.render.RenderHelper;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import org.lwjgl.opengl.GL11;

public class RenderFallout
extends Render<EntityFalloutRain> {
    private Minecraft mc;
    private Random random = new Random();
    float[] rainXCoords;
    float[] rainYCoords;
    private int rendererUpdateCount;
    long lastTime = System.nanoTime();
    private static final ResourceLocation falloutTexture = new ResourceLocation("hbm", "textures/entity/fallout.png");

    public RenderFallout(RenderManager renderManager) {
        super(renderManager);
        this.mc = Minecraft.func_71410_x();
        this.rainXCoords = new float[1024];
        this.rainYCoords = new float[1024];
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainXCoords[i << 5 | j] = -f1 / f2;
                this.rainYCoords[i << 5 | j] = f / f2;
            }
        }
    }

    public boolean shouldRender(EntityFalloutRain livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    public void doRender(EntityFalloutRain entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GL11.glPushMatrix();
        GlStateManager.func_179129_p();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.resetColor();
        GlStateManager.func_179140_f();
        Entity ent = this.mc.func_175606_aa();
        Vec3 vector = Vec3.createVectorHelper(ent.field_70165_t - entity.field_70165_t, ent.field_70163_u - entity.field_70163_u, ent.field_70161_v - entity.field_70161_v);
        double d = vector.lengthVector();
        if (d <= (double)entity.getScale()) {
            ++this.rendererUpdateCount;
            long time = System.nanoTime();
            float t = (time - this.lastTime) / 50000000L;
            if (t <= 1.0f) {
                this.renderRainSnow(t);
            } else {
                this.renderRainSnow(1.0f);
            }
            this.lastTime = time;
        }
        GlStateManager.func_179089_o();
        GL11.glPopMatrix();
    }

    protected void renderRainSnow(float p_78474_1_) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float f1 = 1.0f;
        if (f1 > 0.0f) {
            if (this.rainXCoords == null) {
                this.rainXCoords = new float[1024];
                this.rainYCoords = new float[1024];
                for (int i = 0; i < 32; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        float f2 = j - 16;
                        float f3 = i - 16;
                        float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                        this.rainXCoords[i << 5 | j] = -f3 / f4;
                        this.rainYCoords[i << 5 | j] = f2 / f4;
                    }
                }
            }
            Entity entitylivingbase = this.mc.func_175606_aa();
            WorldClient worldclient = this.mc.field_71441_e;
            int k2 = MathHelper.func_76128_c((double)entitylivingbase.field_70165_t);
            int l2 = MathHelper.func_76128_c((double)entitylivingbase.field_70163_u);
            int i3 = MathHelper.func_76128_c((double)entitylivingbase.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entitylivingbase.field_70142_S + (entitylivingbase.field_70165_t - entitylivingbase.field_70142_S) * (double)p_78474_1_;
            double d1 = entitylivingbase.field_70137_T + (entitylivingbase.field_70163_u - entitylivingbase.field_70137_T) * (double)p_78474_1_;
            double d2 = entitylivingbase.field_70136_U + (entitylivingbase.field_70161_v - entitylivingbase.field_70136_U) * (double)p_78474_1_;
            int k = MathHelper.func_76128_c((double)d1);
            int b0 = 5;
            if (this.mc.field_71474_y.field_74347_j) {
                b0 = 10;
            }
            int b1 = -1;
            float f5 = (float)this.rendererUpdateCount + p_78474_1_;
            if (this.mc.field_71474_y.field_74347_j) {
                b0 = 10;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.resetColor();
            for (int l = i3 - b0; l <= i3 + b0; ++l) {
                for (int i1 = k2 - b0; i1 <= k2 + b0; ++i1) {
                    int j1 = (l - i3 + 16) * 32 + i1 - k2 + 16;
                    float f6 = this.rainXCoords[j1] * 0.5f;
                    float f7 = this.rainYCoords[j1] * 0.5f;
                    pos.func_181079_c(i1, 50, l);
                    Biome biomegenbase = worldclient.getBiomeForCoordsBody((BlockPos)pos);
                    int k1 = worldclient.func_175725_q((BlockPos)pos).func_177956_o();
                    int l1 = l2 - b0;
                    int i2 = l2 + b0;
                    if (l1 < k1) {
                        l1 = k1;
                    }
                    if (i2 < k1) {
                        i2 = k1;
                    }
                    float f8 = 1.0f;
                    int j2 = k1;
                    if (k1 < k) {
                        j2 = k;
                    }
                    if (l1 == i2) continue;
                    pos.func_185336_p(l1);
                    this.random.setSeed(i1 * i1 * 3121 + i1 * 45238971 ^ l * l * 418711 + l * 13761);
                    biomegenbase.func_180626_a((BlockPos)pos);
                    if (b1 != 1) {
                        if (b1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        b1 = 1;
                        this.mc.func_110434_K().func_110577_a(falloutTexture);
                        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    }
                    float f10 = ((float)(this.rendererUpdateCount & 0x1FF) + p_78474_1_) / 512.0f;
                    float f16 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                    float f11 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                    double d4 = (double)((float)i1 + 0.5f) - entitylivingbase.field_70165_t;
                    double d5 = (double)((float)l + 0.5f) - entitylivingbase.field_70161_v;
                    float f14 = MathHelper.func_76133_a((double)(d4 * d4 + d5 * d5)) / (float)b0;
                    float f15 = 1.0f;
                    BufferBuilder buf = tessellator.func_178180_c();
                    worldclient.func_175724_o((BlockPos)pos.func_181079_c(i1, j2, l));
                    buf.func_178969_c(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                    buf.func_181662_b((double)((float)i1 - f6) + 0.5, (double)l1, (double)((float)l - f7) + 0.5).func_187315_a((double)(0.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11)).func_181666_a(f15, f15, f15, ((1.0f - f14 * f14) * 0.3f + 0.5f) * f1).func_181675_d();
                    buf.func_181662_b((double)((float)i1 + f6) + 0.5, (double)l1, (double)((float)l + f7) + 0.5).func_187315_a((double)(1.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11)).func_181666_a(f15, f15, f15, ((1.0f - f14 * f14) * 0.3f + 0.5f) * f1).func_181675_d();
                    buf.func_181662_b((double)((float)i1 + f6) + 0.5, (double)i2, (double)((float)l + f7) + 0.5).func_187315_a((double)(1.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11)).func_181666_a(f15, f15, f15, ((1.0f - f14 * f14) * 0.3f + 0.5f) * f1).func_181675_d();
                    buf.func_181662_b((double)((float)i1 - f6) + 0.5, (double)i2, (double)((float)l - f7) + 0.5).func_187315_a((double)(0.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11)).func_181666_a(f15, f15, f15, ((1.0f - f14 * f14) * 0.3f + 0.5f) * f1).func_181675_d();
                    buf.func_178969_c(0.0, 0.0, 0.0);
                }
            }
            if (b1 >= 0) {
                tessellator.func_78381_a();
            }
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    protected ResourceLocation getEntityTexture(EntityFalloutRain entity) {
        return null;
    }
}

